/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Branch;
import org.fenixedu.academic.domain.CandidacyPeriodInDegreeCurricularPlan;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularCourseScope;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan$callable$editApplyPreviousYearsEnrolment;
import org.fenixedu.academic.domain.DegreeCurricularPlan$callable$editDuration;
import org.fenixedu.academic.domain.DegreeCurricularPlanEquivalencePlan;
import org.fenixedu.academic.domain.DegreeCurricularPlan_Base;
import org.fenixedu.academic.domain.DegreeModuleScope;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.EmptyDegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentPeriod;
import org.fenixedu.academic.domain.EnrolmentPeriodInClasses;
import org.fenixedu.academic.domain.EnrolmentPeriodInCurricularCourses;
import org.fenixedu.academic.domain.EnrolmentPeriodInCurricularCoursesFlunkedSeason;
import org.fenixedu.academic.domain.EnrolmentPeriodInCurricularCoursesSpecialSeason;
import org.fenixedu.academic.domain.EnrolmentPeriodInSpecialSeasonEvaluations;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionDegree_Base;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.RegistrationPeriodInDegreeCurricularPlan;
import org.fenixedu.academic.domain.ReingressionPeriod;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accounting.serviceAgreementTemplates.DegreeCurricularPlanServiceAgreementTemplate;
import org.fenixedu.academic.domain.branch.BranchType;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.curricularRules.CurricularRule;
import org.fenixedu.academic.domain.curricularRules.MaximumNumberOfCreditsForEnrolmentPeriod;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degree.degreeCurricularPlan.DegreeCurricularPlanState;
import org.fenixedu.academic.domain.degreeStructure.BranchCourseGroup;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CurricularCourseFunctor;
import org.fenixedu.academic.domain.degreeStructure.CurricularStage;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.OptionalCurricularCourse;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.degreeStructure.RootCourseGroup;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.space.SpaceUtils;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarEntry;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarRootEntry;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicYearCE;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicYears;
import org.fenixedu.academic.dto.CurricularPeriodInfoDTO;
import org.fenixedu.academic.predicate.AcademicPredicates;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.DegreeCurricularPlanPredicates;
import org.fenixedu.academic.util.MarkType;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.academic.util.PeriodState;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.groups.NobodyGroup;
import org.fenixedu.bennu.core.groups.UserGroup;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.YearMonthDay;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class DegreeCurricularPlan
extends DegreeCurricularPlan_Base {
    public static final Comparator<DegreeCurricularPlan> COMPARATOR_BY_NAME;
    public static final Comparator<DegreeCurricularPlan> COMPARATOR_BY_PRESENTATION_NAME;
    public static final Comparator<DegreeCurricularPlan> DEGREE_CURRICULAR_PLAN_COMPARATOR_BY_DEGREE_TYPE_AND_EXECUTION_DEGREE_AND_DEGREE_CODE;
    public static final Advice advice$editDuration;
    public static final Advice advice$editApplyPreviousYearsEnrolment;

    protected DegreeCurricularPlan() {
        super.setRootDomainObject(Bennu.getInstance());
        super.setApplyPreviousYearsEnrolmentRule(Boolean.TRUE);
    }

    private DegreeCurricularPlan(Degree degree, String name, GradeScale gradeScale) {
        this();
        if (degree == null) {
            throw new DomainException("degreeCurricularPlan.degree.not.null", new String[0]);
        }
        if (name == null) {
            throw new DomainException("degreeCurricularPlan.name.not.null", new String[0]);
        }
        super.setDegree(degree);
        super.setName(name);
        super.setGradeScale(gradeScale);
    }

    protected DegreeCurricularPlan(Degree degree, String name, DegreeCurricularPlanState state, Date inicialDate, Date endDate, Integer degreeDuration, Integer minimalYearForOptionalCourses, Double neededCredits, MarkType markType, Integer numerusClausus, String annotation, GradeScale gradeScale) {
        this(degree, name, gradeScale);
        super.setCurricularStage(CurricularStage.OLD);
        super.setState(state);
        this.oldStructureFieldsChange(inicialDate, endDate, degreeDuration, minimalYearForOptionalCourses, neededCredits, markType, numerusClausus, annotation);
    }

    private void oldStructureFieldsChange(Date inicialDate, Date endDate, Integer degreeDuration, Integer minimalYearForOptionalCourses, Double neededCredits, MarkType markType, Integer numerusClausus, String annotation) {
        if (inicialDate == null) {
            throw new DomainException("degreeCurricularPlan.inicialDate.not.null", new String[0]);
        }
        if (degreeDuration == null) {
            throw new DomainException("degreeCurricularPlan.degreeDuration.not.null", new String[0]);
        }
        if (minimalYearForOptionalCourses == null) {
            throw new DomainException("degreeCurricularPlan.minimalYearForOptionalCourses.not.null", new String[0]);
        }
        this.setInitialDateYearMonthDay(new YearMonthDay((Object)inicialDate));
        this.setEndDateYearMonthDay(endDate != null ? new YearMonthDay((Object)endDate) : null);
        this.setDegreeDuration(degreeDuration);
        this.setMinimalYearForOptionalCourses(minimalYearForOptionalCourses);
        this.setNeededCredits(neededCredits);
        this.setMarkType(markType);
        this.setNumerusClausus(numerusClausus);
        this.setAnotation(annotation);
    }

    DegreeCurricularPlan(Degree degree, String name, GradeScale gradeScale, Person creator, CurricularPeriod curricularPeriod) {
        this(degree, name, gradeScale);
        if (creator == null) {
            throw new DomainException("degreeCurricularPlan.creator.not.null", new String[0]);
        }
        if (curricularPeriod == null) {
            throw new DomainException("degreeCurricularPlan.curricularPeriod.not.null", new String[0]);
        }
        this.createDefaultCourseGroups();
        this.setCurricularPlanMembersGroup(UserGroup.of((User[])new User[]{creator.getUser()}));
        this.setDegreeStructure(curricularPeriod);
        this.setState(DegreeCurricularPlanState.ACTIVE);
        this.newStructureFieldsChange(CurricularStage.DRAFT, null);
        this.createDefaultCurricularRules();
        new DegreeCurricularPlanServiceAgreementTemplate(this);
    }

    private void createDefaultCourseGroups() {
        RootCourseGroup.createRoot(this, this.getName(), this.getName());
    }

    private void createDefaultCurricularRules() {
        new MaximumNumberOfCreditsForEnrolmentPeriod((DegreeModule)((Object)this.getRoot()), ExecutionSemester.readActualExecutionSemester());
    }

    private void newStructureFieldsChange(CurricularStage curricularStage, ExecutionYear beginExecutionYear) {
        if (curricularStage == null) {
            throw new DomainException("degreeCurricularPlan.curricularStage.not.null", new String[0]);
        }
        if (!this.getExecutionDegreesSet().isEmpty() && curricularStage == CurricularStage.DRAFT) {
            throw new DomainException("degreeCurricularPlan.has.already.been.executed", new String[0]);
        }
        if (curricularStage == CurricularStage.APPROVED) {
            this.approve(beginExecutionYear);
        } else {
            this.setCurricularStage(curricularStage);
        }
    }

    private void commonFieldsChange(String name, GradeScale gradeScale) {
        if (name == null) {
            throw new DomainException("degreeCurricularPlan.name.not.null", new String[0]);
        }
        for (DegreeCurricularPlan dcp : this.getDegree().getDegreeCurricularPlansSet()) {
            if (dcp == this || !dcp.getName().equalsIgnoreCase(name)) continue;
            throw new DomainException("error.degreeCurricularPlan.existing.name.and.degree", new String[0]);
        }
        this.setName(name);
        this.setGradeScale(gradeScale);
    }

    public void edit(String name, DegreeCurricularPlanState state, Date inicialDate, Date endDate, Integer degreeDuration, Integer minimalYearForOptionalCourses, Double neededCredits, MarkType markType, Integer numerusClausus, String annotation, GradeScale gradeScale) {
        this.commonFieldsChange(name, gradeScale);
        this.oldStructureFieldsChange(inicialDate, endDate, degreeDuration, minimalYearForOptionalCourses, neededCredits, markType, numerusClausus, annotation);
        this.setState(state);
    }

    public void edit(String name, CurricularStage stage, DegreeCurricularPlanState state, GradeScale gradeScale, ExecutionYear beginExecutionInterval) {
        if (this.isApproved() && (name != null && !this.getName().equals(name) || gradeScale != null && !this.getGradeScale().equals((Object)gradeScale))) {
            throw new DomainException("error.degreeCurricularPlan.already.approved", new String[0]);
        }
        this.commonFieldsChange(name, gradeScale);
        this.newStructureFieldsChange(stage, beginExecutionInterval);
        this.setState(state);
        this.getRoot().setName(name);
        this.getRoot().setNameEn(name);
    }

    private void approve(ExecutionYear beginExecutionYear) {
        if (this.isApproved()) {
            return;
        }
        if (!this.getCanModify().booleanValue()) {
            throw new DomainException("error.degreeCurricularPlan.already.approved", new String[0]);
        }
        if (beginExecutionYear == null) {
            throw new DomainException("error.invalid.execution.year", new String[0]);
        }
        ExecutionSemester beginExecutionPeriod = beginExecutionYear.getFirstExecutionPeriod();
        if (beginExecutionPeriod == null) {
            throw new DomainException("error.invalid.execution.period", new String[0]);
        }
        this.checkIfCurricularCoursesBelongToApprovedCompetenceCourses();
        this.initBeginExecutionPeriodForDegreeCurricularPlan((CourseGroup)((Object)this.getRoot()), beginExecutionPeriod);
        this.setCurricularStage(CurricularStage.APPROVED);
    }

    private void checkIfCurricularCoursesBelongToApprovedCompetenceCourses() {
        ArrayList<String> notApprovedCompetenceCourses = new ArrayList<String>();
        for (DegreeModule degreeModule : this.getDcpDegreeModules(CurricularCourse.class)) {
            CurricularCourse curricularCourse = (CurricularCourse)((Object)degreeModule);
            if (curricularCourse.isOptional() || curricularCourse.getCompetenceCourse().isApproved()) continue;
            notApprovedCompetenceCourses.add(curricularCourse.getCompetenceCourse().getDepartmentUnit().getName() + " > " + curricularCourse.getCompetenceCourse().getName());
        }
        if (!notApprovedCompetenceCourses.isEmpty()) {
            String[] result = new String[notApprovedCompetenceCourses.size()];
            throw new DomainException("error.not.all.competence.courses.are.approved", notApprovedCompetenceCourses.toArray(result));
        }
    }

    private void initBeginExecutionPeriodForDegreeCurricularPlan(CourseGroup courseGroup, ExecutionSemester beginExecutionPeriod) {
        if (beginExecutionPeriod == null) {
            throw new DomainException("", new String[0]);
        }
        for (CurricularRule curricularRule : courseGroup.getCurricularRulesSet()) {
            curricularRule.setBegin(beginExecutionPeriod);
        }
        for (Context context : courseGroup.getChildContextsSet()) {
            context.setBeginExecutionPeriod(beginExecutionPeriod);
            if (context.getChildDegreeModule().isLeaf()) continue;
            this.initBeginExecutionPeriodForDegreeCurricularPlan((CourseGroup)((Object)context.getChildDegreeModule()), beginExecutionPeriod);
        }
    }

    public boolean isBolonhaDegree() {
        return this.getDegree().isBolonhaDegree();
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isApproved() {
        return this.getCurricularStage() == CurricularStage.APPROVED;
    }

    public boolean isDraft() {
        return this.getCurricularStage() == CurricularStage.DRAFT;
    }

    public boolean isActive() {
        return this.getState() == DegreeCurricularPlanState.ACTIVE;
    }

    private Boolean getCanBeDeleted() {
        return this.canDeleteRoot() && this.getStudentCurricularPlansSet().isEmpty() && this.getCurricularCourseEquivalencesSet().isEmpty() && this.getEnrolmentPeriodsSet().isEmpty() && this.getCurricularCoursesSet().isEmpty() && this.getExecutionDegreesSet().isEmpty() && this.getAreasSet().isEmpty() && this.canDeleteServiceAgreement() && this.getTeachersWithIncompleteEvaluationWorkGroupSet().isEmpty() && this.getEquivalencePlan() == null && this.getTargetEquivalencePlansSet().isEmpty() && this.getDegreeContextsSet().isEmpty();
    }

    private boolean canDeleteRoot() {
        return this.getRoot().getCanBeDeleted();
    }

    private boolean canDeleteServiceAgreement() {
        return this.getServiceAgreementTemplate() == null || this.getServiceAgreementTemplate().getPostingRulesSet().isEmpty() && this.getServiceAgreementTemplate().getServiceAgreementsSet().isEmpty();
    }

    public void delete() {
        if (this.getCanBeDeleted().booleanValue()) {
            this.setDegree(null);
            this.getRoot().delete();
            if (this.getDegreeStructure() != null) {
                this.getDegreeStructure().delete();
            }
            if (this.getServiceAgreementTemplate() != null) {
                DegreeCurricularPlanServiceAgreementTemplate template = this.getServiceAgreementTemplate();
                this.setServiceAgreementTemplate(null);
                template.delete();
            }
        } else {
            throw new DomainException("error.degree.curricular.plan.cant.delete", new String[0]);
        }
        this.setShift(null);
        this.setMembersGroup(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public String print() {
        StringBuilder dcp = new StringBuilder();
        dcp.append("[DCP ").append(this.getExternalId()).append("] ").append(this.getName()).append("\n");
        this.getRoot().print(dcp, "", null);
        return dcp.toString();
    }

    public GradeScale getGradeScaleChain() {
        return super.getGradeScale() != null ? super.getGradeScale() : this.getDegree().getGradeScaleChain();
    }

    @Deprecated
    public ExecutionDegree getExecutionDegreeByYear(ExecutionYear executionYear) {
        for (ExecutionDegree executionDegree : this.getExecutionDegreesSet()) {
            if (executionDegree.getExecutionYear() != executionYear) continue;
            return executionDegree;
        }
        return null;
    }

    public ExecutionDegree getExecutionDegreeByAcademicInterval(AcademicInterval academicInterval) {
        AcademicCalendarEntry academicCalendarEntry = academicInterval.getAcademicCalendarEntry();
        while (!(academicCalendarEntry instanceof AcademicCalendarRootEntry)) {
            if (academicCalendarEntry instanceof AcademicYearCE) {
                ExecutionYear year = ExecutionYear.getExecutionYear((AcademicYearCE)((Object)academicCalendarEntry));
                for (ExecutionDegree executionDegree : this.getExecutionDegreesSet()) {
                    if (!executionDegree.getExecutionYear().getAcademicInterval().equals(year.getAcademicInterval())) continue;
                    return executionDegree;
                }
            }
            academicCalendarEntry = academicCalendarEntry.getParentEntry();
        }
        return null;
    }

    public Set<ExecutionYear> getExecutionYears() {
        HashSet<ExecutionYear> result = new HashSet<ExecutionYear>();
        for (ExecutionDegree executionDegree : this.getExecutionDegreesSet()) {
            result.add(executionDegree.getExecutionYear());
        }
        return result;
    }

    public ExecutionYear getMostRecentExecutionYear() {
        return this.getMostRecentExecutionDegree().getExecutionYear();
    }

    public ExecutionDegree getExecutionDegreeByYearAndCampus(ExecutionYear executionYear, Space campus) {
        for (ExecutionDegree executionDegree : this.getExecutionDegreesSet()) {
            if (executionDegree.getExecutionYear() != executionYear || executionDegree.getCampus() != campus) continue;
            return executionDegree;
        }
        return null;
    }

    public boolean hasExecutionDegreeByYearAndCampus(ExecutionYear executionYear, Space campus) {
        return this.getExecutionDegreeByYearAndCampus(executionYear, campus) != null;
    }

    public boolean hasAnyExecutionDegreeFor(ExecutionYear executionYear) {
        for (ExecutionDegree executionDegree : this.getExecutionDegreesSet()) {
            if (executionDegree.getExecutionYear() != executionYear) continue;
            return true;
        }
        return false;
    }

    public boolean hasExecutionDegreeFor(ExecutionYear executionYear) {
        return this.getExecutionDegreeByYear(executionYear) != null;
    }

    public ExecutionDegree getMostRecentExecutionDegree() {
        if (this.getExecutionDegreesSet().isEmpty()) {
            return null;
        }
        ExecutionYear currentYear = ExecutionYear.readCurrentExecutionYear();
        ExecutionDegree result = this.getExecutionDegreeByYear(currentYear);
        if (result != null) {
            return result;
        }
        ArrayList sorted = new ArrayList(this.getExecutionDegreesSet());
        Collections.sort(sorted, ExecutionDegree.EXECUTION_DEGREE_COMPARATORY_BY_YEAR);
        ExecutionDegree first = (ExecutionDegree)sorted.iterator().next();
        if (sorted.size() == 1) {
            return first;
        }
        if (first.getExecutionYear().isAfter(currentYear)) {
            return first;
        }
        ListIterator iter = sorted.listIterator(sorted.size());
        while (iter.hasPrevious()) {
            ExecutionDegree executionDegree = (ExecutionDegree)iter.previous();
            if (!executionDegree.getExecutionYear().isBeforeOrEquals(currentYear)) continue;
            return executionDegree;
        }
        return null;
    }

    public ExecutionDegree getFirstExecutionDegree() {
        if (this.getExecutionDegreesSet().isEmpty()) {
            return null;
        }
        return Collections.min(this.getExecutionDegreesSet(), ExecutionDegree.EXECUTION_DEGREE_COMPARATORY_BY_YEAR);
    }

    public Set<ExecutionCourse> getExecutionCoursesByExecutionPeriod(ExecutionSemester executionSemester) {
        HashSet<ExecutionCourse> result = new HashSet<ExecutionCourse>();
        this.addExecutionCoursesForExecutionPeriod(result, executionSemester, this.getRoot().getChildContextsSet());
        return result;
    }

    public SortedSet<DegreeModuleScope> getDegreeModuleScopes() {
        TreeSet<DegreeModuleScope> degreeModuleScopes = new TreeSet<DegreeModuleScope>(DegreeModuleScope.COMPARATOR_BY_CURRICULAR_YEAR_AND_SEMESTER_AND_CURRICULAR_COURSE_NAME);
        for (CurricularCourse curricularCourse : this.getCurricularCoursesSet()) {
            degreeModuleScopes.addAll(curricularCourse.getDegreeModuleScopes());
        }
        return degreeModuleScopes;
    }

    public Set<DegreeModuleScope> getDegreeModuleScopesFor(Integer year, Integer semester) {
        TreeSet<DegreeModuleScope> result = new TreeSet<DegreeModuleScope>(DegreeModuleScope.COMPARATOR_BY_CURRICULAR_YEAR_AND_SEMESTER_AND_CURRICULAR_COURSE_NAME);
        for (DegreeModuleScope each : this.getDegreeModuleScopes()) {
            if (!each.isActive(year, semester)) continue;
            result.add(each);
        }
        return result;
    }

    public Set<DegreeModuleScope> getDegreeModuleScopesFor(ExecutionYear executionYear) {
        TreeSet<DegreeModuleScope> result = new TreeSet<DegreeModuleScope>(DegreeModuleScope.COMPARATOR_BY_CURRICULAR_YEAR_AND_SEMESTER_AND_CURRICULAR_COURSE_NAME);
        for (DegreeModuleScope each : this.getDegreeModuleScopes()) {
            if (!each.isActiveForExecutionYear(executionYear)) continue;
            result.add(each);
        }
        return result;
    }

    public void addExecutionCoursesForExecutionPeriod(Set<ExecutionCourse> executionCourses, ExecutionSemester executionSemester, Set<Context> contexts) {
        for (Context context : contexts) {
            DegreeModule degreeModule = context.getChildDegreeModule();
            if (degreeModule instanceof CurricularCourse) {
                CurricularCourse curricularCourse = (CurricularCourse)((Object)degreeModule);
                executionCourses.addAll(curricularCourse.getExecutionCoursesByExecutionPeriod(executionSemester));
                continue;
            }
            if (!(degreeModule instanceof CourseGroup)) continue;
            CourseGroup courseGroup = (CourseGroup)((Object)degreeModule);
            this.addExecutionCoursesForExecutionPeriod(executionCourses, executionSemester, courseGroup.getChildContextsSet());
        }
    }

    public List<ExecutionCourse> getExecutionCoursesByExecutionPeriodAndSemesterAndYear(ExecutionSemester executionSemester, Integer curricularYear, Integer semester) {
        ArrayList<ExecutionCourse> result = new ArrayList<ExecutionCourse>();
        block0: for (CurricularCourse curricularCourse : this.getCurricularCoursesSet()) {
            for (DegreeModuleScope degreeModuleScope : curricularCourse.getDegreeModuleScopes()) {
                if (!degreeModuleScope.getCurricularSemester().equals(semester) || !degreeModuleScope.getCurricularYear().equals(curricularYear)) continue;
                for (ExecutionCourse executionCourse : curricularCourse.getAssociatedExecutionCoursesSet()) {
                    if (!executionCourse.getExecutionPeriod().equals(executionSemester)) continue;
                    result.add(executionCourse);
                }
                continue block0;
            }
        }
        return result;
    }

    public Set<CurricularCourse> getAllCurricularCourses() {
        TreeSet<DegreeModule> curricularCourses = new TreeSet<DegreeModule>(DegreeModule.COMPARATOR_BY_NAME){

            @Override
            public boolean add(DegreeModule degreeModule) {
                return degreeModule instanceof CurricularCourse && super.add(degreeModule);
            }
        };
        this.getRoot().getAllDegreeModules(curricularCourses);
        return curricularCourses;
    }

    public List<CurricularCourse> getCurricularCoursesWithExecutionIn(ExecutionYear executionYear) {
        ArrayList<CurricularCourse> curricularCourses = new ArrayList<CurricularCourse>();
        block0: for (CurricularCourse curricularCourse : this.getCurricularCoursesSet()) {
            for (ExecutionSemester executionSemester : executionYear.getExecutionPeriodsSet()) {
                List<ExecutionCourse> executionCourses = curricularCourse.getExecutionCoursesByExecutionPeriod(executionSemester);
                if (executionCourses.isEmpty()) continue;
                curricularCourses.add(curricularCourse);
                continue block0;
            }
        }
        return curricularCourses;
    }

    public List<CurricularCourse> getCurricularCoursesByBasicAttribute(Boolean basic) {
        if (this.isBolonhaDegree()) {
            return Collections.emptyList();
        }
        ArrayList<CurricularCourse> curricularCourses = new ArrayList<CurricularCourse>();
        for (CurricularCourse curricularCourse : this.getCurricularCoursesSet()) {
            if (!curricularCourse.getBasic().equals(basic)) continue;
            curricularCourses.add(curricularCourse);
        }
        return curricularCourses;
    }

    public EnrolmentPeriodInCurricularCourses getActualEnrolmentPeriod() {
        for (EnrolmentPeriod enrolmentPeriod : this.getEnrolmentPeriodsSet()) {
            if (!(enrolmentPeriod instanceof EnrolmentPeriodInCurricularCourses) || !enrolmentPeriod.isValid()) continue;
            return (EnrolmentPeriodInCurricularCourses)((Object)enrolmentPeriod);
        }
        return null;
    }

    public Optional<EnrolmentPeriod> getActiveCurricularCourseEnrolmentPeriod(ExecutionSemester executionSemester) {
        return this.getEnrolmentPeriodsSet().stream().filter(ep -> ep.getExecutionPeriod() == executionSemester && ep instanceof EnrolmentPeriodInCurricularCourses && ep.isValid()).findAny();
    }

    public boolean hasActualEnrolmentPeriodInCurricularCourses() {
        return this.getActualEnrolmentPeriod() != null;
    }

    public EnrolmentPeriodInSpecialSeasonEvaluations getNextSpecialSeasonEnrolmentPeriod() {
        ArrayList<EnrolmentPeriodInSpecialSeasonEvaluations> positivesSet = new ArrayList<EnrolmentPeriodInSpecialSeasonEvaluations>();
        for (EnrolmentPeriod enrolmentPeriod : this.getEnrolmentPeriodsSet()) {
            if (!(enrolmentPeriod instanceof EnrolmentPeriodInSpecialSeasonEvaluations) || !enrolmentPeriod.isUpcomingPeriod()) continue;
            positivesSet.add((EnrolmentPeriodInSpecialSeasonEvaluations)((Object)enrolmentPeriod));
        }
        return positivesSet.isEmpty() ? null : Collections.min(positivesSet, EnrolmentPeriodInSpecialSeasonEvaluations.COMPARATOR_BY_START);
    }

    public boolean hasOpenSpecialSeasonEnrolmentPeriod(ExecutionSemester executionSemester) {
        for (EnrolmentPeriod enrolmentPeriod : this.getEnrolmentPeriodsSet()) {
            if (!(enrolmentPeriod instanceof EnrolmentPeriodInSpecialSeasonEvaluations) || !enrolmentPeriod.isFor(executionSemester) || !enrolmentPeriod.isValid()) continue;
            return true;
        }
        return false;
    }

    public EnrolmentPeriodInCurricularCoursesSpecialSeason getActualEnrolmentPeriodInCurricularCoursesSpecialSeason() {
        for (EnrolmentPeriod enrolmentPeriod : this.getEnrolmentPeriodsSet()) {
            if (!(enrolmentPeriod instanceof EnrolmentPeriodInCurricularCoursesSpecialSeason) || !enrolmentPeriod.isValid()) continue;
            return (EnrolmentPeriodInCurricularCoursesSpecialSeason)((Object)enrolmentPeriod);
        }
        return null;
    }

    public Optional<EnrolmentPeriod> getActiveEnrolmentPeriodInCurricularCoursesSpecialSeason(ExecutionSemester executionSemester) {
        return this.getEnrolmentPeriodsSet().stream().filter(ep -> ep.getExecutionPeriod() == executionSemester && ep instanceof EnrolmentPeriodInCurricularCoursesSpecialSeason && ep.isValid()).findAny();
    }

    public boolean hasOpenEnrolmentPeriodInCurricularCoursesSpecialSeason(ExecutionSemester executionSemester) {
        for (EnrolmentPeriod enrolmentPeriod : this.getEnrolmentPeriodsSet()) {
            EnrolmentPeriodInCurricularCoursesSpecialSeason enrolmentPeriodInCurricularCourses;
            if (!(enrolmentPeriod instanceof EnrolmentPeriodInCurricularCoursesSpecialSeason) || !(enrolmentPeriodInCurricularCourses = (EnrolmentPeriodInCurricularCoursesSpecialSeason)((Object)enrolmentPeriod)).isFor(executionSemester) || !enrolmentPeriodInCurricularCourses.isValid()) continue;
            return true;
        }
        return false;
    }

    public EnrolmentPeriodInCurricularCoursesFlunkedSeason getActualEnrolmentPeriodInCurricularCoursesFlunkedSeason() {
        for (EnrolmentPeriod enrolmentPeriod : this.getEnrolmentPeriodsSet()) {
            if (!(enrolmentPeriod instanceof EnrolmentPeriodInCurricularCoursesFlunkedSeason) || !enrolmentPeriod.isValid()) continue;
            return (EnrolmentPeriodInCurricularCoursesFlunkedSeason)((Object)enrolmentPeriod);
        }
        return null;
    }

    public Optional<EnrolmentPeriod> getActiveEnrolmentPeriodInCurricularCoursesFlunkedSeason(ExecutionSemester executionSemester) {
        return this.getEnrolmentPeriodsSet().stream().filter(ep -> ep.getExecutionPeriod() == executionSemester && ep instanceof EnrolmentPeriodInCurricularCoursesFlunkedSeason && ep.isValid()).findAny();
    }

    public boolean hasOpenEnrolmentPeriodInCurricularCoursesFor(ExecutionSemester executionSemester) {
        for (EnrolmentPeriod enrolmentPeriod : this.getEnrolmentPeriodsSet()) {
            EnrolmentPeriodInCurricularCourses enrolmentPeriodInCurricularCourses;
            if (!(enrolmentPeriod instanceof EnrolmentPeriodInCurricularCourses) || !(enrolmentPeriodInCurricularCourses = (EnrolmentPeriodInCurricularCourses)((Object)enrolmentPeriod)).isFor(executionSemester) || !enrolmentPeriodInCurricularCourses.isValid()) continue;
            return true;
        }
        return false;
    }

    public EnrolmentPeriodInCurricularCourses getNextEnrolmentPeriod() {
        DateTime now = new DateTime();
        ArrayList<EnrolmentPeriodInCurricularCourses> result = new ArrayList<EnrolmentPeriodInCurricularCourses>();
        for (EnrolmentPeriod enrolmentPeriod : this.getEnrolmentPeriodsSet()) {
            if (!(enrolmentPeriod instanceof EnrolmentPeriodInCurricularCourses) || !enrolmentPeriod.getStartDateDateTime().isAfter((ReadableInstant)now)) continue;
            result.add((EnrolmentPeriodInCurricularCourses)((Object)enrolmentPeriod));
        }
        if (!result.isEmpty()) {
            Collections.sort(result, EnrolmentPeriodInCurricularCourses.COMPARATOR_BY_START);
            return (EnrolmentPeriodInCurricularCourses)((Object)result.iterator().next());
        }
        return null;
    }

    public EnrolmentPeriodInCurricularCoursesSpecialSeason getNextEnrolmentPeriodInCurricularCoursesSpecialSeason() {
        DateTime now = new DateTime();
        ArrayList<EnrolmentPeriodInCurricularCoursesSpecialSeason> result = new ArrayList<EnrolmentPeriodInCurricularCoursesSpecialSeason>();
        for (EnrolmentPeriod enrolmentPeriod : this.getEnrolmentPeriodsSet()) {
            if (!(enrolmentPeriod instanceof EnrolmentPeriodInCurricularCoursesSpecialSeason) || !enrolmentPeriod.getStartDateDateTime().isAfter((ReadableInstant)now)) continue;
            result.add((EnrolmentPeriodInCurricularCoursesSpecialSeason)((Object)enrolmentPeriod));
        }
        if (!result.isEmpty()) {
            Collections.sort(result, EnrolmentPeriodInCurricularCoursesSpecialSeason.COMPARATOR_BY_START);
            return (EnrolmentPeriodInCurricularCoursesSpecialSeason)((Object)result.iterator().next());
        }
        return null;
    }

    public EnrolmentPeriodInCurricularCoursesFlunkedSeason getNextEnrolmentPeriodInCurricularCoursesFlunkedSeason() {
        DateTime now = new DateTime();
        ArrayList<EnrolmentPeriodInCurricularCoursesFlunkedSeason> result = new ArrayList<EnrolmentPeriodInCurricularCoursesFlunkedSeason>();
        for (EnrolmentPeriod enrolmentPeriod : this.getEnrolmentPeriodsSet()) {
            if (!(enrolmentPeriod instanceof EnrolmentPeriodInCurricularCoursesFlunkedSeason) || !enrolmentPeriod.getStartDateDateTime().isAfter((ReadableInstant)now)) continue;
            result.add((EnrolmentPeriodInCurricularCoursesFlunkedSeason)((Object)enrolmentPeriod));
        }
        if (!result.isEmpty()) {
            Collections.sort(result, EnrolmentPeriodInCurricularCoursesFlunkedSeason.COMPARATOR_BY_START);
            return (EnrolmentPeriodInCurricularCoursesFlunkedSeason)((Object)result.iterator().next());
        }
        return null;
    }

    public EnrolmentPeriodInClasses getCurrentClassesEnrollmentPeriod() {
        for (EnrolmentPeriod enrolmentPeriod : this.getEnrolmentPeriodsSet()) {
            if (!(enrolmentPeriod instanceof EnrolmentPeriodInClasses) || !enrolmentPeriod.getExecutionPeriod().getState().equals(PeriodState.CURRENT)) continue;
            return (EnrolmentPeriodInClasses)((Object)enrolmentPeriod);
        }
        return null;
    }

    @Deprecated
    public Optional<EnrolmentPeriod> getClassesEnrollmentPeriod(ExecutionSemester executionSemester) {
        return this.getEnrolmentPeriodsSet().stream().filter(ep -> ep.isForClasses() && ep.getExecutionPeriod() == executionSemester).findAny();
    }

    public Optional<EnrolmentPeriod> getValidEnrolmentPeriod(java.util.function.Predicate<EnrolmentPeriod> predicate, ExecutionSemester executionSemester) {
        return this.getEnrolmentPeriodsSet().stream().filter(predicate.and(ep -> ep.getExecutionPeriod() == executionSemester && ep.isValid())).findAny();
    }

    public CandidacyPeriodInDegreeCurricularPlan getCurrentCandidacyPeriodInDCP() {
        for (EnrolmentPeriod enrolmentPeriod : this.getEnrolmentPeriodsSet()) {
            if (!(enrolmentPeriod instanceof CandidacyPeriodInDegreeCurricularPlan) || !enrolmentPeriod.getExecutionPeriod().getExecutionYear().isCurrent()) continue;
            return (CandidacyPeriodInDegreeCurricularPlan)((Object)enrolmentPeriod);
        }
        return null;
    }

    public CandidacyPeriodInDegreeCurricularPlan getCandidacyPeriod(ExecutionYear executionYear) {
        List<EnrolmentPeriod> enrolmentPeriods = this.getEnrolmentPeriodsBy(executionYear.getFirstExecutionPeriod(), CandidacyPeriodInDegreeCurricularPlan.class);
        return (CandidacyPeriodInDegreeCurricularPlan)((Object)(!enrolmentPeriods.isEmpty() ? enrolmentPeriods.iterator().next() : null));
    }

    public boolean hasCandidacyPeriodFor(ExecutionYear executionYear) {
        return this.hasEnrolmentPeriodFor(executionYear.getFirstExecutionPeriod(), CandidacyPeriodInDegreeCurricularPlan.class);
    }

    public RegistrationPeriodInDegreeCurricularPlan getRegistrationPeriod(ExecutionYear executionYear) {
        List<EnrolmentPeriod> enrolmentPeriods = this.getEnrolmentPeriodsBy(executionYear.getFirstExecutionPeriod(), RegistrationPeriodInDegreeCurricularPlan.class);
        return (RegistrationPeriodInDegreeCurricularPlan)((Object)(!enrolmentPeriods.isEmpty() ? enrolmentPeriods.iterator().next() : null));
    }

    public boolean hasRegistrationPeriodFor(ExecutionYear executionYear) {
        return this.hasEnrolmentPeriodFor(executionYear.getFirstExecutionPeriod(), RegistrationPeriodInDegreeCurricularPlan.class);
    }

    private List<EnrolmentPeriod> getEnrolmentPeriodsBy(ExecutionSemester executionSemester, Class clazz) {
        ArrayList<EnrolmentPeriod> result = new ArrayList<EnrolmentPeriod>();
        for (EnrolmentPeriod enrolmentPeriod : this.getEnrolmentPeriodsSet()) {
            if (!((Object)((Object)enrolmentPeriod)).getClass().equals(clazz) || enrolmentPeriod.getExecutionPeriod() != executionSemester) continue;
            result.add(enrolmentPeriod);
        }
        return result;
    }

    private boolean hasEnrolmentPeriodFor(ExecutionSemester executionSemester, Class clazz) {
        for (EnrolmentPeriod enrolmentPeriod : this.getEnrolmentPeriodsSet()) {
            if (!((Object)((Object)enrolmentPeriod)).getClass().equals(clazz) || enrolmentPeriod.getExecutionPeriod() != executionSemester) continue;
            return true;
        }
        return false;
    }

    public Collection<ExecutionYear> getCandidacyPeriodsExecutionYears() {
        return this.getEnrolmentPeriodsExecutionYears(CandidacyPeriodInDegreeCurricularPlan.class);
    }

    private Set<ExecutionYear> getEnrolmentPeriodsExecutionYears(Class clazz) {
        HashSet<ExecutionYear> result = new HashSet<ExecutionYear>();
        for (EnrolmentPeriod enrolmentPeriod : this.getEnrolmentPeriodsSet()) {
            if (clazz != null && !((Object)((Object)enrolmentPeriod)).getClass().equals(clazz)) continue;
            result.add(enrolmentPeriod.getExecutionPeriod().getExecutionYear());
        }
        return result;
    }

    public EnrolmentPeriodInCurricularCoursesSpecialSeason getEnrolmentPeriodInCurricularCoursesSpecialSeasonByExecutionPeriod(ExecutionSemester executionSemester) {
        for (EnrolmentPeriod enrolmentPeriod : this.getEnrolmentPeriodsSet()) {
            if (!(enrolmentPeriod instanceof EnrolmentPeriodInCurricularCoursesSpecialSeason) || !enrolmentPeriod.getExecutionPeriod().equals(executionSemester)) continue;
            return (EnrolmentPeriodInCurricularCoursesSpecialSeason)((Object)enrolmentPeriod);
        }
        return null;
    }

    public EnrolmentPeriodInCurricularCourses getEnrolmentPeriodInCurricularCoursesBy(ExecutionSemester executionSemester) {
        for (EnrolmentPeriod each : this.getEnrolmentPeriodsSet()) {
            if (!(each instanceof EnrolmentPeriodInCurricularCourses) || !each.getExecutionPeriod().equals(executionSemester)) continue;
            return (EnrolmentPeriodInCurricularCourses)((Object)each);
        }
        return null;
    }

    public ReingressionPeriod getReingressionPeriod(ExecutionSemester executionSemester) {
        for (EnrolmentPeriod period : this.getEnrolmentPeriodsSet()) {
            if (!(period instanceof ReingressionPeriod) || !period.isFor(executionSemester)) continue;
            return (ReingressionPeriod)((Object)period);
        }
        return null;
    }

    public boolean hasEnrolmentPeriodInCurricularCourses(ExecutionSemester executionSemester) {
        return this.getEnrolmentPeriodInCurricularCoursesBy(executionSemester) != null;
    }

    public CurricularCourse getCurricularCourseByCode(String code) {
        for (CurricularCourse curricularCourse : this.getCurricularCoursesSet()) {
            if (curricularCourse.getCode() == null || !curricularCourse.getCode().equals(code)) continue;
            return curricularCourse;
        }
        return null;
    }

    public CurricularCourse getCurricularCourseByAcronym(String acronym) {
        for (CurricularCourse curricularCourse : this.getCurricularCoursesSet()) {
            if (!curricularCourse.getAcronym().equals(acronym)) continue;
            return curricularCourse;
        }
        return null;
    }

    public Set<CurricularCourse> getCurricularCoursesSet() {
        return this.getCurricularCourses((ExecutionYear)null);
    }

    public void doForAllCurricularCourses(CurricularCourseFunctor curricularCourseFunctor) {
        this.getRoot().doForAllCurricularCourses(curricularCourseFunctor);
    }

    public Set<CurricularCourse> getCurricularCourses(ExecutionSemester executionSemester) {
        HashSet<CurricularCourse> curricularCourses = new HashSet<CurricularCourse>();
        for (CurricularCourse curricularCourse : super.getCurricularCoursesSet()) {
            if (!curricularCourse.hasScopeInGivenSemesterAndCurricularYearInDCP(null, null, executionSemester)) continue;
            curricularCourses.add(curricularCourse);
        }
        ExecutionYear executionYear = executionSemester.getExecutionYear();
        for (DegreeModule degreeModule : this.getDcpDegreeModules(CurricularCourse.class, executionYear)) {
            curricularCourses.add((CurricularCourse)((Object)degreeModule));
        }
        return curricularCourses;
    }

    private Set<CurricularCourse> getCurricularCourses(ExecutionYear executionYear) {
        HashSet<CurricularCourse> result = new HashSet<CurricularCourse>();
        for (DegreeModule degreeModule : this.getDcpDegreeModules(CurricularCourse.class, executionYear)) {
            result.add((CurricularCourse)((Object)degreeModule));
        }
        return result;
    }

    public void applyToCurricularCourses(ExecutionYear executionYear, Predicate predicate) {
        this.getRoot().applyToCurricularCourses(executionYear, predicate);
    }

    public List<CompetenceCourse> getCompetenceCourses() {
        if (this.isBolonhaDegree()) {
            return this.getCompetenceCourses(null);
        }
        return new ArrayList<CompetenceCourse>();
    }

    public List<CompetenceCourse> getCompetenceCourses(ExecutionYear executionYear) {
        TreeSet<CompetenceCourse> result = new TreeSet<CompetenceCourse>(CompetenceCourse.COMPETENCE_COURSE_COMPARATOR_BY_NAME);
        if (this.isBolonhaDegree()) {
            for (CurricularCourse curricularCourse : this.getCurricularCourses(executionYear)) {
                if (curricularCourse.isOptionalCurricularCourse()) continue;
                result.add(curricularCourse.getCompetenceCourse());
            }
            return new ArrayList<CompetenceCourse>(result);
        }
        return new ArrayList<CompetenceCourse>();
    }

    public List<Branch> getCommonAreas() {
        return (List)CollectionUtils.select((Collection)this.getAreasSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object obj) {
                Branch branch = (Branch)((Object)obj);
                if (branch.getBranchType() == null) {
                    return branch.getName().equals("") && branch.getCode().equals("");
                }
                return branch.getBranchType().equals((Object)BranchType.COMNBR);
            }
        });
    }

    public Set<CurricularCourse> getActiveCurricularCourses() {
        HashSet<CurricularCourse> result = new HashSet<CurricularCourse>();
        for (CurricularCourse curricularCourse : this.getCurricularCoursesSet()) {
            if (!curricularCourse.hasAnyActiveDegreModuleScope()) continue;
            result.add(curricularCourse);
        }
        return result;
    }

    public Set<CurricularCourse> getActiveCurricularCourses(ExecutionSemester executionSemester) {
        HashSet<CurricularCourse> result = new HashSet<CurricularCourse>();
        for (CurricularCourse curricularCourse : this.getCurricularCoursesSet()) {
            if (!curricularCourse.hasAnyActiveDegreModuleScope(executionSemester)) continue;
            result.add(curricularCourse);
        }
        return result;
    }

    public List<CurricularCourseScope> getActiveCurricularCourseScopes() {
        ArrayList<CurricularCourseScope> result = new ArrayList<CurricularCourseScope>();
        for (CurricularCourse course : this.getCurricularCoursesSet()) {
            result.addAll(course.getActiveScopes());
        }
        return result;
    }

    public CurricularCourse createCurricularCourse(String name, String code, String acronym, Boolean enrolmentAllowed, CurricularStage curricularStage) {
        return new CurricularCourse(this, name, code, acronym, enrolmentAllowed, curricularStage);
    }

    public CourseGroup createCourseGroup(CourseGroup parentCourseGroup, String name, String nameEn, ExecutionSemester begin, ExecutionSemester end) {
        return new CourseGroup(parentCourseGroup, name, nameEn, begin, end, null);
    }

    public CourseGroup createCourseGroup(CourseGroup parentCourseGroup, String name, String nameEn, ExecutionSemester begin, ExecutionSemester end, ProgramConclusion programConclusion) {
        return new CourseGroup(parentCourseGroup, name, nameEn, begin, end, programConclusion);
    }

    public BranchCourseGroup createBranchCourseGroup(CourseGroup parentCourseGroup, String name, String nameEn, org.fenixedu.academic.domain.degreeStructure.BranchType branchType, ExecutionSemester begin, ExecutionSemester end) {
        return new BranchCourseGroup(parentCourseGroup, name, nameEn, branchType, begin, end);
    }

    public CurricularCourse createCurricularCourse(Double weight, String prerequisites, String prerequisitesEn, CurricularStage curricularStage, CompetenceCourse competenceCourse, CourseGroup parentCourseGroup, CurricularPeriod curricularPeriod, ExecutionSemester beginExecutionPeriod, ExecutionSemester endExecutionPeriod) {
        if (competenceCourse.getCurricularCourse(this) != null) {
            throw new DomainException("competenceCourse.already.has.a.curricular.course.in.degree.curricular.plan", new String[0]);
        }
        this.checkIfAnualBeginsInFirstPeriod(competenceCourse, curricularPeriod);
        return new CurricularCourse(weight, prerequisites, prerequisitesEn, curricularStage, competenceCourse, parentCourseGroup, curricularPeriod, beginExecutionPeriod, endExecutionPeriod);
    }

    public CurricularCourse createOptionalCurricularCourse(CourseGroup parentCourseGroup, String name, String nameEn, CurricularStage curricularStage, CurricularPeriod curricularPeriod, ExecutionSemester beginExecutionPeriod, ExecutionSemester endExecutionPeriod) {
        return new OptionalCurricularCourse(parentCourseGroup, name, nameEn, curricularStage, curricularPeriod, beginExecutionPeriod, endExecutionPeriod);
    }

    private void checkIfAnualBeginsInFirstPeriod(CompetenceCourse competenceCourse, CurricularPeriod curricularPeriod) {
        if (competenceCourse.isAnual() && !curricularPeriod.hasChildOrderValue(1)) {
            throw new DomainException("competenceCourse.anual.but.trying.to.associate.curricular.course.not.to.first.period", new String[0]);
        }
    }

    public List<DegreeModule> getDcpDegreeModules(Class<? extends DegreeModule> clazz) {
        return this.getDcpDegreeModules(clazz, (ExecutionYear)null);
    }

    public List<DegreeModule> getDcpDegreeModules(Class<? extends DegreeModule> clazz, ExecutionYear executionYear) {
        return new ArrayList<DegreeModule>(this.getRoot().collectAllChildDegreeModules(clazz, executionYear));
    }

    public List<DegreeModule> getDcpDegreeModules(Class<? extends DegreeModule> clazz, ExecutionSemester executionSemester) {
        return new ArrayList<DegreeModule>(this.getRoot().collectAllChildDegreeModules(clazz, executionSemester));
    }

    public List<List<DegreeModule>> getDcpDegreeModulesIncludingFullPath(Class<? extends DegreeModule> clazz, ExecutionYear executionYear) {
        ArrayList<List<DegreeModule>> result = new ArrayList<List<DegreeModule>>();
        ArrayList<RootCourseGroup> path = new ArrayList<RootCourseGroup>();
        if (clazz.isAssignableFrom(CourseGroup.class)) {
            path.add(this.getRoot());
            result.add(path);
        }
        this.getRoot().collectChildDegreeModulesIncludingFullPath(clazz, result, path, executionYear);
        return result;
    }

    public Branch getBranchByName(String branchName) {
        if (branchName != null) {
            for (Branch branch : this.getAreasSet()) {
                if (!branchName.equals(branch.getName())) continue;
                return branch;
            }
        }
        return null;
    }

    public Boolean getUserCanBuild() {
        Person person = AccessControl.getPerson();
        return AcademicPredicates.MANAGE_DEGREE_CURRICULAR_PLANS.evaluate(this.getDegree()) || this.isBolonhaDegree() && this.getCurricularPlanMembersGroup().isMember(person.getUser());
    }

    public Boolean getCanModify() {
        if (this.isApproved()) {
            return false;
        }
        Set executionDegrees = this.getExecutionDegreesSet();
        return executionDegrees.size() > 1 ? false : executionDegrees.isEmpty() || ((ExecutionDegree)executionDegrees.iterator().next()).getExecutionYear().isCurrent();
    }

    public Group getCurricularPlanMembersGroup() {
        return this.getMembersGroup() != null ? this.getMembersGroup().toGroup() : NobodyGroup.get();
    }

    public void setCurricularPlanMembersGroup(Group group) {
        AccessControl.check(this, DegreeCurricularPlanPredicates.scientificCouncilWritePredicate);
        this.setMembersGroup(group.toPersistentGroup());
    }

    public void setCurricularStage(CurricularStage curricularStage) {
        AccessControl.check(this, DegreeCurricularPlanPredicates.scientificCouncilWritePredicate);
        super.setCurricularStage(curricularStage);
    }

    public void setDegree(Degree degree) {
        AccessControl.check(this, DegreeCurricularPlanPredicates.scientificCouncilWritePredicate);
        super.setDegree(degree);
    }

    public void setRoot(RootCourseGroup courseGroup) {
        AccessControl.check(this, DegreeCurricularPlanPredicates.scientificCouncilWritePredicate);
        super.setRoot(courseGroup);
    }

    public void editDuration(AcademicPeriod academicPeriod) {
        Object object = advice$editDuration.perform((Callable)new DegreeCurricularPlan$callable$editDuration(this, academicPeriod));
    }

    static /* synthetic */ void advised$editDuration(DegreeCurricularPlan this_, AcademicPeriod duration) {
        if (duration == null) {
            throw new DomainException("error.degreeCurricularPlan.duration.cannot.be.null", new String[0]);
        }
        if (!this_.getDegreeStructure().getAcademicPeriod().equals((Object)duration)) {
            this_.setDegreeStructure(new CurricularPeriod(duration));
        }
    }

    public void setDegreeStructure(CurricularPeriod degreeStructure) {
        AccessControl.check(this, DegreeCurricularPlanPredicates.scientificCouncilWritePredicate);
        if (degreeStructure == null || !(degreeStructure.getAcademicPeriod() instanceof AcademicYears)) {
            throw new DomainException("error.degreeCurricularPlan.degreeStructure.must.be.specified.in.years", new String[0]);
        }
        CurricularPeriod currentDegreeStructure = super.getDegreeStructure();
        if (currentDegreeStructure != degreeStructure) {
            if (!this.getAllCurricularCourses().isEmpty()) {
                throw new DomainException("error.degreeCurricularPlan.degreeStructure.cannot.be.changed.when.already.has.curricular.courses", new String[0]);
            }
            if (currentDegreeStructure != null) {
                currentDegreeStructure.delete();
            }
        }
        super.setDegreeStructure(degreeStructure);
    }

    public void setGradeScale(GradeScale gradeScale) {
        AccessControl.check(this, DegreeCurricularPlanPredicates.scientificCouncilWritePredicate);
        super.setGradeScale(gradeScale);
    }

    public void setName(String name) {
        AccessControl.check(this, DegreeCurricularPlanPredicates.scientificCouncilWritePredicate);
        super.setName(name);
    }

    public String getPresentationName() {
        return this.getPresentationName(ExecutionYear.readCurrentExecutionYear(), I18N.getLocale());
    }

    public String getPresentationName(ExecutionYear executionYear) {
        return this.getPresentationName(executionYear, I18N.getLocale());
    }

    public String getPresentationName(ExecutionYear executionYear, Locale locale) {
        return this.getDegree().getPresentationName(executionYear, locale) + " - " + this.getName();
    }

    public static List<DegreeCurricularPlan> readNotEmptyDegreeCurricularPlans() {
        ArrayList<DegreeCurricularPlan> result = new ArrayList<DegreeCurricularPlan>(Bennu.getInstance().getDegreeCurricularPlansSet());
        result.remove((Object)DegreeCurricularPlan.readEmptyDegreeCurricularPlan());
        return result;
    }

    public static DegreeCurricularPlan readEmptyDegreeCurricularPlan() {
        return EmptyDegreeCurricularPlan.getInstance();
    }

    public static Set<DegreeCurricularPlan> readBolonhaDegreeCurricularPlans() {
        HashSet<DegreeCurricularPlan> result = new HashSet<DegreeCurricularPlan>();
        for (Degree degree : Degree.readBolonhaDegrees()) {
            result.addAll(degree.getDegreeCurricularPlansSet());
        }
        return result;
    }

    public static Set<DegreeCurricularPlan> readPreBolonhaDegreeCurricularPlans() {
        HashSet<DegreeCurricularPlan> result = new HashSet<DegreeCurricularPlan>();
        for (Degree degree : Degree.readOldDegrees()) {
            result.addAll(degree.getDegreeCurricularPlansSet());
        }
        return result;
    }

    public static List<DegreeCurricularPlan> readByCurricularStage(CurricularStage curricularStage) {
        ArrayList<DegreeCurricularPlan> result = new ArrayList<DegreeCurricularPlan>();
        for (DegreeCurricularPlan degreeCurricularPlan : DegreeCurricularPlan.readNotEmptyDegreeCurricularPlans()) {
            if (!degreeCurricularPlan.getCurricularStage().equals((Object)curricularStage)) continue;
            result.add(degreeCurricularPlan);
        }
        return result;
    }

    public static List<DegreeCurricularPlan> readByDegreeTypeAndState(java.util.function.Predicate<DegreeType> degreeType, DegreeCurricularPlanState state) {
        ArrayList<DegreeCurricularPlan> result = new ArrayList<DegreeCurricularPlan>();
        for (DegreeCurricularPlan degreeCurricularPlan : DegreeCurricularPlan.readNotEmptyDegreeCurricularPlans()) {
            if (!degreeType.test(degreeCurricularPlan.getDegree().getDegreeType()) || state != null && degreeCurricularPlan.getState() != state) continue;
            result.add(degreeCurricularPlan);
        }
        return result;
    }

    public static List<DegreeCurricularPlan> readByDegreeTypesAndState(java.util.function.Predicate<DegreeType> predicate, DegreeCurricularPlanState state) {
        ArrayList<DegreeCurricularPlan> result = new ArrayList<DegreeCurricularPlan>();
        for (DegreeCurricularPlan degreeCurricularPlan : DegreeCurricularPlan.readNotEmptyDegreeCurricularPlans()) {
            if (!predicate.test(degreeCurricularPlan.getDegree().getDegreeType()) || state != null && degreeCurricularPlan.getState() != state) continue;
            result.add(degreeCurricularPlan);
        }
        return result;
    }

    public static DegreeCurricularPlan readByNameAndDegreeSigla(String name, String degreeSigla) {
        for (DegreeCurricularPlan degreeCurricularPlan : DegreeCurricularPlan.readNotEmptyDegreeCurricularPlans()) {
            if (!degreeCurricularPlan.getName().equalsIgnoreCase(name) || !degreeCurricularPlan.getDegree().getSigla().equalsIgnoreCase(degreeSigla)) continue;
            return degreeCurricularPlan;
        }
        return null;
    }

    public Set<CurricularCourseScope> findCurricularCourseScopesIntersectingPeriod(Date beginDate, Date endDate) {
        HashSet<CurricularCourseScope> curricularCourseScopes = new HashSet<CurricularCourseScope>();
        for (CurricularCourse curricularCourse : this.getCurricularCoursesSet()) {
            curricularCourseScopes.addAll(curricularCourse.findCurricularCourseScopesIntersectingPeriod(beginDate, endDate));
        }
        return curricularCourseScopes;
    }

    public ExecutionDegree createExecutionDegree(ExecutionYear executionYear, Space campus, Boolean publishedExamMap) {
        if (this.isBolonhaDegree() && this.isDraft()) {
            throw new DomainException("degree.curricular.plan.not.approved.cannot.create.execution.degree", this.getName());
        }
        if (this.hasAnyExecutionDegreeFor(executionYear)) {
            throw new DomainException("degree.curricular.plan.already.has.execution.degree.for.this.year", this.getName(), executionYear.getYear());
        }
        return new ExecutionDegree(this, executionYear, campus, publishedExamMap);
    }

    public CurricularPeriod getCurricularPeriodFor(int year, int semester) {
        CurricularPeriodInfoDTO[] curricularPeriodInfos = this.buildCurricularPeriodInfoDTOsFor(year, semester);
        return this.getDegreeStructure().getCurricularPeriod(curricularPeriodInfos);
    }

    private CurricularPeriodInfoDTO[] buildCurricularPeriodInfoDTOsFor(int year, int semester) {
        CurricularPeriodInfoDTO[] curricularPeriodInfos = this.getDurationInYears() > 1 ? new CurricularPeriodInfoDTO[]{new CurricularPeriodInfoDTO(year, AcademicPeriod.YEAR), new CurricularPeriodInfoDTO(semester, AcademicPeriod.SEMESTER)} : new CurricularPeriodInfoDTO[]{new CurricularPeriodInfoDTO(semester, AcademicPeriod.SEMESTER)};
        return curricularPeriodInfos;
    }

    public CurricularPeriod createCurricularPeriodFor(int year, int semester) {
        CurricularPeriodInfoDTO[] curricularPeriodInfos = this.buildCurricularPeriodInfoDTOsFor(year, semester);
        return this.getDegreeStructure().addCurricularPeriod(curricularPeriodInfos);
    }

    public YearMonthDay getInitialDateYearMonthDay() {
        if (this.isBolonhaDegree() && !this.getExecutionDegreesSet().isEmpty()) {
            ExecutionDegree firstExecutionDegree = this.getFirstExecutionDegree();
            return firstExecutionDegree.getExecutionYear().getBeginDateYearMonthDay();
        }
        return super.getInitialDateYearMonthDay();
    }

    public YearMonthDay getEndDateYearMonthDay() {
        if (this.isBolonhaDegree() && !this.getExecutionDegreesSet().isEmpty()) {
            ExecutionDegree mostRecentExecutionDegree = this.getMostRecentExecutionDegree();
            if (mostRecentExecutionDegree.getExecutionYear() == ExecutionYear.readCurrentExecutionYear()) {
                return null;
            }
            return mostRecentExecutionDegree.getExecutionYear().getBeginDateYearMonthDay();
        }
        return super.getEndDateYearMonthDay();
    }

    public Collection<StudentCurricularPlan> getActiveStudentCurricularPlans() {
        HashSet<StudentCurricularPlan> result = new HashSet<StudentCurricularPlan>();
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            if (!studentCurricularPlan.isActive()) continue;
            result.add(studentCurricularPlan);
        }
        return result;
    }

    public Set<Registration> getRegistrations() {
        HashSet<Registration> registrations = new HashSet<Registration>();
        for (StudentCurricularPlan studentCurricularPlan : this.getActiveStudentCurricularPlans()) {
            registrations.add(studentCurricularPlan.getRegistration());
        }
        return registrations;
    }

    public Collection<Registration> getActiveRegistrations() {
        HashSet<Registration> result = new HashSet<Registration>();
        for (StudentCurricularPlan studentCurricularPlan : this.getActiveStudentCurricularPlans()) {
            Registration registration = studentCurricularPlan.getRegistration();
            if (!registration.isActive()) continue;
            result.add(registration);
        }
        return result;
    }

    public boolean isPast() {
        return this.getState().equals((Object)DegreeCurricularPlanState.PAST);
    }

    public Space getCampus(ExecutionYear executionYear) {
        for (ExecutionDegree executionDegree : this.getExecutionDegreesSet()) {
            if (executionDegree.getExecutionYear() != executionYear) continue;
            return executionDegree.getCampus();
        }
        return null;
    }

    public Space getCurrentCampus() {
        for (ExecutionDegree executionDegree : this.getExecutionDegreesSet()) {
            ExecutionYear executionYear = executionDegree.getExecutionYear();
            if (!executionYear.isCurrent()) continue;
            return executionDegree.getCampus();
        }
        return null;
    }

    public Space getLastCampus() {
        if (!this.getExecutionDegreesSet().isEmpty()) {
            return this.getMostRecentExecutionDegree().getCampus();
        }
        return SpaceUtils.getDefaultCampus();
    }

    public Integer getDegreeDuration() {
        Integer degreeDuration = super.getDegreeDuration();
        return degreeDuration == null ? this.getDurationInYears() : degreeDuration.intValue();
    }

    public DegreeType getDegreeType() {
        return this.getDegree().getDegreeType();
    }

    public boolean isDegreeOrBolonhaDegreeOrBolonhaIntegratedMasterDegree() {
        return this.getDegreeType().isDegreeOrBolonhaDegreeOrBolonhaIntegratedMasterDegree();
    }

    public boolean isFirstCycle() {
        return this.getDegree().isFirstCycle();
    }

    public CycleCourseGroup getFirstCycleCourseGroup() {
        return this.isFirstCycle() ? this.getRoot().getFirstCycleCourseGroup() : null;
    }

    public boolean isSecondCycle() {
        return this.getDegree().isSecondCycle();
    }

    public CycleCourseGroup getSecondCycleCourseGroup() {
        return this.isSecondCycle() ? this.getRoot().getSecondCycleCourseGroup() : null;
    }

    public CycleCourseGroup getThirdCycleCourseGroup() {
        return this.isBolonhaDegree() ? this.getRoot().getThirdCycleCourseGroup() : null;
    }

    public CycleCourseGroup getCycleCourseGroup(CycleType cycleType) {
        return this.isBolonhaDegree() ? this.getRoot().getCycleCourseGroup(cycleType) : null;
    }

    public CycleCourseGroup getLastOrderedCycleCourseGroup() {
        return this.isBolonhaDegree() ? this.getCycleCourseGroup(this.getDegreeType().getLastOrderedCycleType()) : null;
    }

    public String getGraduateTitle(ExecutionYear executionYear, ProgramConclusion programConclusion, Locale locale) {
        return programConclusion.groupFor(this).map(cg -> cg.getGraduateTitle(executionYear, locale)).orElse(null);
    }

    public List<CurricularCourse> getDissertationCurricularCourses(ExecutionYear year) {
        ArrayList<CurricularCourse> result = new ArrayList<CurricularCourse>();
        ArrayList<ExecutionYear> years = new ArrayList<ExecutionYear>();
        if (year == null) {
            for (year = ExecutionYear.readCurrentExecutionYear(); year != null; year = year.getPreviousExecutionYear()) {
                years.add(year);
            }
        } else {
            years.add(year);
        }
        for (ExecutionYear executionYear : years) {
            for (CurricularCourse curricularCourse : this.getCurricularCourses(executionYear)) {
                if (!curricularCourse.isDissertation()) continue;
                result.add(curricularCourse);
            }
        }
        return result;
    }

    public Set<Thesis> getThesis(ExecutionYear executionYear) {
        HashSet<Thesis> thesis = new HashSet<Thesis>();
        for (CurricularCourse curricularCourse : this.getDissertationCurricularCourses(executionYear)) {
            for (Enrolment enrolment : curricularCourse.getEnrolmentsByExecutionYear(executionYear)) {
                StudentCurricularPlan studentCurricularPlan = enrolment.getStudentCurricularPlan();
                if (studentCurricularPlan.getDegreeCurricularPlan() != this) continue;
                thesis.addAll(enrolment.getThesesSet());
            }
        }
        return thesis;
    }

    public Set<Enrolment> getDissertationEnrolments(ExecutionYear executionYear) {
        HashSet<Enrolment> enrolments = new HashSet<Enrolment>();
        for (CurricularCourse curricularCourse : this.getDissertationCurricularCourses(executionYear)) {
            for (Enrolment enrolment : curricularCourse.getEnrolmentsByExecutionYear(executionYear)) {
                enrolments.add(enrolment);
            }
        }
        return enrolments;
    }

    public List<CurricularCourse> getDissertationCurricularCourses() {
        return this.getDissertationCurricularCourses(ExecutionYear.readCurrentExecutionYear());
    }

    public DegreeCurricularPlanEquivalencePlan createEquivalencePlan(DegreeCurricularPlan sourceDegreeCurricularPlan) {
        return new DegreeCurricularPlanEquivalencePlan(this, sourceDegreeCurricularPlan);
    }

    public boolean hasDegreeModule(DegreeModule degreeModule) {
        return this.getRoot().hasDegreeModule(degreeModule);
    }

    public final List<StudentCurricularPlan> getLastStudentCurricularPlan() {
        ArrayList<StudentCurricularPlan> studentCurricularPlans = new ArrayList<StudentCurricularPlan>();
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            studentCurricularPlans.add(studentCurricularPlan.getRegistration().getLastStudentCurricularPlan());
        }
        return studentCurricularPlans;
    }

    public Set<CourseGroup> getAllCoursesGroups() {
        TreeSet<DegreeModule> courseGroups = new TreeSet<DegreeModule>(DegreeModule.COMPARATOR_BY_NAME){

            @Override
            public boolean add(DegreeModule degreeModule) {
                return degreeModule instanceof CourseGroup && super.add(degreeModule);
            }
        };
        courseGroups.add((DegreeModule)((Object)this.getRoot()));
        this.getRoot().getAllDegreeModules(courseGroups);
        return courseGroups;
    }

    public Set<BranchCourseGroup> getAllBranches() {
        TreeSet<DegreeModule> branches = new TreeSet<DegreeModule>(DegreeModule.COMPARATOR_BY_NAME){

            @Override
            public boolean add(DegreeModule degreeModule) {
                return degreeModule instanceof BranchCourseGroup && super.add(degreeModule);
            }
        };
        branches.add((DegreeModule)((Object)this.getRoot()));
        this.getRoot().getAllDegreeModules(branches);
        return branches;
    }

    public Set<BranchCourseGroup> getBranchesByType(org.fenixedu.academic.domain.degreeStructure.BranchType branchType) {
        TreeSet<DegreeModule> branchesByType = new TreeSet<DegreeModule>(DegreeModule.COMPARATOR_BY_NAME);
        Set<BranchCourseGroup> branches = this.getAllBranches();
        if (branches == null) {
            return null;
        }
        for (BranchCourseGroup branch : branches) {
            if (branch.getBranchType() != branchType) continue;
            branchesByType.add((DegreeModule)((Object)branch));
        }
        return branchesByType;
    }

    public Set<BranchCourseGroup> getMajorBranches() {
        return this.getBranchesByType(org.fenixedu.academic.domain.degreeStructure.BranchType.MAJOR);
    }

    public Set<BranchCourseGroup> getMinorBranches() {
        return this.getBranchesByType(org.fenixedu.academic.domain.degreeStructure.BranchType.MINOR);
    }

    public boolean hasBranches() {
        return !this.getAllBranches().isEmpty();
    }

    public boolean hasBranchesByType(org.fenixedu.academic.domain.degreeStructure.BranchType branchType) {
        return !this.getBranchesByType(branchType).isEmpty();
    }

    public Set<DegreeModule> getAllDegreeModules() {
        TreeSet<DegreeModule> degreeModules = new TreeSet<DegreeModule>(DegreeModule.COMPARATOR_BY_NAME);
        RootCourseGroup rootCourseGroup = this.getRoot();
        rootCourseGroup.getAllDegreeModules(degreeModules);
        return degreeModules;
    }

    public static Set<DegreeCurricularPlan> getDegreeCurricularPlans(java.util.function.Predicate<DegreeType> predicate) {
        TreeSet<DegreeCurricularPlan> degreeCurricularPlans = new TreeSet<DegreeCurricularPlan>(COMPARATOR_BY_PRESENTATION_NAME);
        for (Degree degree : Degree.readNotEmptyDegrees()) {
            if (!predicate.test(degree.getDegreeType())) continue;
            for (DegreeCurricularPlan degreeCurricularPlan : degree.getDegreeCurricularPlansSet()) {
                if (!degreeCurricularPlan.isActive()) continue;
                degreeCurricularPlans.add(degreeCurricularPlan);
            }
        }
        return degreeCurricularPlans;
    }

    public List<StudentCurricularPlan> getStudentsCurricularPlanGivenEntryYear(ExecutionYear entryYear) {
        ArrayList<StudentCurricularPlan> studentsGivenEntryYear = new ArrayList<StudentCurricularPlan>();
        ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
        for (Registration registration : this.getActiveRegistrations()) {
            if (registration.getStartDate() == null || !registration.getStartExecutionYear().equals(entryYear) || !registration.isRegistered(currentExecutionYear) || registration.getRegistrationProtocol().isMobilityAgreement()) continue;
            studentsGivenEntryYear.add(registration.getActiveStudentCurricularPlan());
        }
        return studentsGivenEntryYear;
    }

    public Set<CurricularCourse> getCurricularCoursesByExecutionYearAndCurricularYear(ExecutionYear executionYear, Integer curricularYear) {
        HashSet<CurricularCourse> result = new HashSet<CurricularCourse>();
        for (CurricularCourse curricularCourse : this.getCurricularCoursesWithExecutionIn(executionYear)) {
            for (DegreeModuleScope degreeModuleScope : curricularCourse.getDegreeModuleScopes()) {
                if (!degreeModuleScope.getCurricularYear().equals(curricularYear)) continue;
                result.add(curricularCourse);
            }
        }
        return result;
    }

    public Set<Registration> getRegistrations(ExecutionYear executionYear, Set<Registration> registrations) {
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            if (!studentCurricularPlan.isActive(executionYear) || studentCurricularPlan.getRegistration() == null) continue;
            registrations.add(studentCurricularPlan.getRegistration());
        }
        return registrations;
    }

    public List<StudentCurricularPlan> getStudentsCurricularPlans(ExecutionYear executionYear, List<StudentCurricularPlan> result) {
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            if (!studentCurricularPlan.isActive(executionYear)) continue;
            result.add(studentCurricularPlan);
        }
        return result;
    }

    public void editApplyPreviousYearsEnrolment(Boolean bl) {
        Object object = advice$editApplyPreviousYearsEnrolment.perform((Callable)new DegreeCurricularPlan$callable$editApplyPreviousYearsEnrolment(this, bl));
    }

    static /* synthetic */ void advised$editApplyPreviousYearsEnrolment(DegreeCurricularPlan this_, Boolean input) {
        if (input != null) {
            this_.setApplyPreviousYearsEnrolmentRule(input);
        }
    }

    public boolean isToApplyPreviousYearsEnrolmentRule() {
        return this.getApplyPreviousYearsEnrolmentRule();
    }

    public ExecutionSemester getFirstExecutionPeriodEnrolments() {
        return ExecutionSemester.readFirstEnrolmentsExecutionPeriod();
    }

    public boolean hasTargetEquivalencePlanFor(DegreeCurricularPlan degreeCurricularPlan) {
        for (DegreeCurricularPlanEquivalencePlan equivalencePlan : this.getTargetEquivalencePlansSet()) {
            if (!equivalencePlan.getDegreeCurricularPlan().equals((Object)degreeCurricularPlan)) continue;
            return true;
        }
        return false;
    }

    public boolean canSubmitImprovementMarkSheets(ExecutionYear executionYear) {
        TreeSet<ExecutionDegree> sortedExecutionDegrees = new TreeSet<ExecutionDegree>(ExecutionDegree.EXECUTION_DEGREE_COMPARATORY_BY_YEAR);
        sortedExecutionDegrees.addAll(this.getExecutionDegreesSet());
        return ((ExecutionDegree)sortedExecutionDegrees.last()).getExecutionYear().equals(executionYear.getPreviousExecutionYear());
    }

    public ExecutionInterval getBegin() {
        Set<ExecutionYear> beginContextExecutionYears = this.getBeginContextExecutionYears();
        return beginContextExecutionYears.isEmpty() ? null : (ExecutionInterval)((Object)Collections.min(beginContextExecutionYears, ExecutionYear.COMPARATOR_BY_YEAR));
    }

    public Set<ExecutionYear> getBeginContextExecutionYears() {
        return this.getRoot().getBeginContextExecutionYears();
    }

    public ExecutionYear getOldestContextExecutionYear() {
        ArrayList<ExecutionYear> beginContextExecutionYears = new ArrayList<ExecutionYear>(this.getBeginContextExecutionYears());
        Collections.sort(beginContextExecutionYears, ExecutionYear.COMPARATOR_BY_YEAR);
        return beginContextExecutionYears.isEmpty() ? null : (ExecutionYear)beginContextExecutionYears.iterator().next();
    }

    public MultiLanguageString getDescriptionI18N() {
        MultiLanguageString result = new MultiLanguageString();
        if (!StringUtils.isEmpty((String)this.getDescription())) {
            result = result.with(MultiLanguageString.pt, this.getDescription());
        }
        if (!StringUtils.isEmpty((String)this.getDescriptionEn())) {
            result = result.with(MultiLanguageString.en, this.getDescriptionEn());
        }
        return result;
    }

    public Collection<CycleCourseGroup> getDestinationAffinities(CycleType sourceCycleType) {
        CycleCourseGroup cycleCourseGroup = this.getRoot().getCycleCourseGroup(sourceCycleType);
        if (cycleCourseGroup != null) {
            return cycleCourseGroup.getDestinationAffinitiesSet();
        }
        return Collections.EMPTY_LIST;
    }

    public Double getEctsCredits() {
        return this.getDegree().getEctsCredits();
    }

    public boolean isScientificCommissionMember(ExecutionYear executionYear) {
        ExecutionDegree executionDegree = this.getExecutionDegreeByYear(executionYear);
        return executionDegree != null && executionDegree.isScientificCommissionMember();
    }

    public boolean isScientificCommissionMember(ExecutionYear executionYear, Person person) {
        ExecutionDegree executionDegree = this.getExecutionDegreeByYear(executionYear);
        return executionDegree != null && executionDegree.isScientificCommissionMember(person);
    }

    public void checkUserIsScientificCommissionMember(ExecutionYear executionYear) {
        if (!this.isScientificCommissionMember(executionYear)) {
            throw new DomainException("degree.scientificCommission.notMember", new String[0]);
        }
    }

    public static List<DegreeCurricularPlan> readByDegreeTypesAndStateWithExecutionDegreeForYear(java.util.function.Predicate<DegreeType> degreeTypes, DegreeCurricularPlanState state, ExecutionYear executionYear) {
        ArrayList<DegreeCurricularPlan> result = new ArrayList<DegreeCurricularPlan>();
        for (DegreeCurricularPlan degreeCurricularPlan : DegreeCurricularPlan.readByDegreeTypesAndState(degreeTypes, state)) {
            if (!degreeCurricularPlan.hasExecutionDegreeFor(executionYear)) continue;
            result.add(degreeCurricularPlan);
        }
        return result;
    }

    public static Collection<DegreeCurricularPlan> readByAcademicInterval(AcademicInterval academicInterval) {
        ExecutionYear year = ExecutionYear.readByAcademicInterval(academicInterval);
        return year.getDegreeCurricularPlans();
    }

    public boolean isCurrentUserScientificCommissionMember(ExecutionYear executionYear) {
        Person person = AccessControl.getPerson();
        return person != null && this.getDegree().isMemberOfCurrentScientificCommission(person, executionYear);
    }

    public ExecutionYear getInauguralExecutionYear() {
        return this.getExecutionDegreesSet().stream().min(ExecutionDegree.EXECUTION_DEGREE_COMPARATORY_BY_YEAR).map(ExecutionDegree_Base::getExecutionYear).orElse(null);
    }

    public ExecutionYear getLastExecutionYear() {
        return this.getExecutionDegreesSet().stream().max(ExecutionDegree.EXECUTION_DEGREE_COMPARATORY_BY_YEAR).map(ExecutionDegree_Base::getExecutionYear).orElse(null);
    }

    @Deprecated
    public Date getEndDate() {
        YearMonthDay ymd = this.getEndDateYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public void setEndDate(Date date) {
        if (date == null) {
            this.setEndDateYearMonthDay(null);
        } else {
            this.setEndDateYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }

    @Deprecated
    public Date getInitialDate() {
        YearMonthDay ymd = this.getInitialDateYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public void setInitialDate(Date date) {
        if (date == null) {
            this.setInitialDateYearMonthDay(null);
        } else {
            this.setInitialDateYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }

    public Set<CurricularCourse> getCurricularCoursesWithoutExecutionCourseFor(ExecutionSemester semester) {
        Set<CurricularCourse> curricularCourses = this.getCurricularCourses(semester);
        HashSet<CurricularCourse> result = new HashSet<CurricularCourse>();
        for (CurricularCourse curricularCourse : curricularCourses) {
            if (!curricularCourse.getExecutionCoursesByExecutionPeriod(semester).isEmpty()) continue;
            result.add(curricularCourse);
        }
        return result;
    }

    @Deprecated
    public Set<DegreeCurricularPlanEquivalencePlan> getTargetEquivalencePlans() {
        return this.getTargetEquivalencePlansSet();
    }

    public int getDurationInYears() {
        if (this.getDegreeStructure() != null) {
            return Float.valueOf(this.getDegreeStructure().getAcademicPeriod().getWeight()).intValue();
        }
        return 0;
    }

    public int getDurationInSemesters() {
        return Float.valueOf((float)this.getDurationInYears() / AcademicPeriod.SEMESTER.getWeight()).intValue();
    }

    public int getDurationInYears(CycleType cycleType) {
        if (cycleType == null || this.getDegreeType().hasExactlyOneCycleType()) {
            return this.getDurationInYears();
        }
        if (!this.getDegreeType().hasAnyCycleTypes()) {
            return 0;
        }
        return this.calculateCycleDuration(cycleType, ctx -> ctx.getCurricularPeriod().getParent(), cp -> cp.getAcademicPeriod().equals((Object)AcademicPeriod.YEAR));
    }

    public int getDurationInSemesters(CycleType cycleType) {
        return Float.valueOf((float)this.getDurationInYears(cycleType) / AcademicPeriod.SEMESTER.getWeight()).intValue();
    }

    private int calculateCycleDuration(CycleType cycleType, Function<Context, CurricularPeriod> curricularPeriodCollector, java.util.function.Predicate<CurricularPeriod> curricularPeriodFilter) {
        CycleCourseGroup cycleCourseGroup = this.getRoot().getCycleCourseGroup(cycleType);
        if (cycleCourseGroup == null) {
            throw new DomainException("error.degreeCurricularPlan.unable.to.find.cycle.in.structure.to.calculate.duration", cycleType.getDescription());
        }
        return this.getAllCoursesGroups().stream().filter(cg -> cg.getParentCycleCourseGroups().contains((Object)cycleCourseGroup)).flatMap(cg -> cg.getChildContextsSet().stream()).filter(ctx -> ctx.getChildDegreeModule().isLeaf()).map(curricularPeriodCollector).filter(curricularPeriodFilter).collect(Collectors.toSet()).size();
    }

    static {
        advice$editDuration = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$editApplyPreviousYearsEnrolment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_NAME = new Comparator<DegreeCurricularPlan>(){

            @Override
            public int compare(DegreeCurricularPlan o1, DegreeCurricularPlan o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        COMPARATOR_BY_PRESENTATION_NAME = new Comparator<DegreeCurricularPlan>(){

            @Override
            public int compare(DegreeCurricularPlan o1, DegreeCurricularPlan o2) {
                int c = o1.getPresentationName().compareTo(o2.getPresentationName());
                return c == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)o1, (DomainObject)o2) : c;
            }
        };
        DEGREE_CURRICULAR_PLAN_COMPARATOR_BY_DEGREE_TYPE_AND_EXECUTION_DEGREE_AND_DEGREE_CODE = new Comparator<DegreeCurricularPlan>(){

            @Override
            public int compare(DegreeCurricularPlan o1, DegreeCurricularPlan o2) {
                int degreeTypeCompare = o1.getDegreeType().getName().compareTo(o2.getDegreeType().getName());
                if (degreeTypeCompare != 0) {
                    return degreeTypeCompare;
                }
                int finalCompare = o1.getDegree().getSigla().compareTo(o2.getDegree().getSigla());
                if (finalCompare == 0) {
                    finalCompare = o2.getName().compareTo(o1.getName());
                }
                if (finalCompare == 0) {
                    finalCompare = o1.getExternalId().compareTo(o2.getExternalId());
                }
                return finalCompare;
            }
        };
    }
}

