/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.student.enrollment;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.fenixedu.academic.domain.student.Registration;
import pt.ist.fenixWebFramework.servlets.filters.contentRewrite.GenericChecksumRewriter;

public abstract class EnrolmentContextHandler {
    private static EnrolmentContextHandler enrolmentContextHandler;

    public static EnrolmentContextHandler getRegisteredEnrolmentContextHandler() {
        if (enrolmentContextHandler != null) {
            return enrolmentContextHandler;
        }
        return new DefaultEnrolmentContextHandler();
    }

    public static void registerEnrolmentContextHandler(EnrolmentContextHandler newEnrolmentContextHandler) {
        if (enrolmentContextHandler != null) {
            throw new RuntimeException("Another enrolment context handler is registered. The registered handler is of type: " + enrolmentContextHandler.getClass().getName());
        }
        enrolmentContextHandler = newEnrolmentContextHandler;
    }

    public abstract Optional<String> getReturnURLForStudentInCurricularCourses(HttpServletRequest var1, Registration var2);

    public abstract Optional<String> getReturnURLForStudentInClasses(HttpServletRequest var1, Registration var2);

    public abstract Optional<String> getReturnURLForStudentInFullClasses(HttpServletRequest var1, Registration var2);

    public static class DefaultEnrolmentContextHandler
    extends EnrolmentContextHandler {
        @Override
        public Optional<String> getReturnURLForStudentInCurricularCourses(HttpServletRequest request, Registration registration) {
            return Optional.empty();
        }

        @Override
        public Optional<String> getReturnURLForStudentInClasses(HttpServletRequest request, Registration registration) {
            String link = request.getContextPath() + "/student/showStudentPortal.do";
            String injectedLink = GenericChecksumRewriter.injectChecksumInUrl((String)request.getContextPath(), (String)link, (HttpSession)request.getSession());
            return Optional.of(injectedLink);
        }

        @Override
        public Optional<String> getReturnURLForStudentInFullClasses(HttpServletRequest request, Registration registration) {
            return Optional.empty();
        }
    }
}

