/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.gep.ects;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degreeStructure.CurricularStage;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.EctsComparabilityPercentages;
import org.fenixedu.academic.domain.degreeStructure.EctsComparabilityTable;
import org.fenixedu.academic.domain.degreeStructure.EctsCompetenceCourseConversionTable;
import org.fenixedu.academic.domain.degreeStructure.EctsCycleGraduationGradeConversionTable;
import org.fenixedu.academic.domain.degreeStructure.EctsDegreeByCurricularYearConversionTable;
import org.fenixedu.academic.domain.degreeStructure.EctsDegreeGraduationGradeConversionTable;
import org.fenixedu.academic.domain.degreeStructure.EctsInstitutionByCurricularYearConversionTable;
import org.fenixedu.academic.domain.degreeStructure.EctsInstitutionConversionTable;
import org.fenixedu.academic.domain.degreeStructure.EctsTableIndex;
import org.fenixedu.academic.domain.degreeStructure.IEctsConversionTable;
import org.fenixedu.academic.domain.degreeStructure.NullEctsConversionTable;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitUtils;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.commons.ects.EctsTableFilter;
import org.fenixedu.academic.ui.struts.action.commons.ects.EctsTableLevel;
import org.fenixedu.academic.ui.struts.action.commons.ects.EctsTableType;
import org.fenixedu.academic.ui.struts.action.gep.GepApplication;
import org.fenixedu.academic.ui.struts.action.gep.ects.ManageEctsComparabilityTablesDispatchAction$callable$importEnrolmentByCompetenceCourseTables;
import org.fenixedu.academic.ui.struts.action.gep.ects.ManageEctsComparabilityTablesDispatchAction$callable$importEnrolmentByCurricularYearTables;
import org.fenixedu.academic.ui.struts.action.gep.ects.ManageEctsComparabilityTablesDispatchAction$callable$importEnrolmentByDegreeTables;
import org.fenixedu.academic.ui.struts.action.gep.ects.ManageEctsComparabilityTablesDispatchAction$callable$importEnrolmentByInstitutionTables;
import org.fenixedu.academic.ui.struts.action.gep.ects.ManageEctsComparabilityTablesDispatchAction$callable$importGraduationByCycleTables;
import org.fenixedu.academic.ui.struts.action.gep.ects.ManageEctsComparabilityTablesDispatchAction$callable$importGraduationByDegreeTables;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.SheetData;
import org.fenixedu.commons.spreadsheet.SpreadsheetBuilder;
import org.fenixedu.commons.spreadsheet.WorkbookExportFormat;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@StrutsFunctionality(app=GepApplication.GepPortalApp.class, path="ects-tables", titleKey="link.ects.management")
@Mapping(path="/manageEctsComparabilityTables", module="gep")
@Forwards(value={@Forward(name="index", path="/gep/ects/comparabilityTableIndex.jsp")})
public class ManageEctsComparabilityTablesDispatchAction
extends FenixDispatchAction {
    private static final String SEPARATOR = "\\t";
    public static final Advice advice$importEnrolmentByCompetenceCourseTables = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$importEnrolmentByDegreeTables = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$importEnrolmentByCurricularYearTables = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$importEnrolmentByInstitutionTables = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$importGraduationByDegreeTables = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$importGraduationByCycleTables = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @EntryPoint
    public ActionForward index(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        EctsTableFilter filter = this.readFilter(request);
        request.setAttribute("filter", (Object)filter);
        return mapping.findForward("index");
    }

    public ActionForward filterPostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        EctsTableFilter filter = this.readFilter(request);
        filter.setLevel(null);
        request.setAttribute("filter", (Object)filter);
        return mapping.findForward("index");
    }

    public ActionForward viewStatus(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        EctsTableFilter filter = this.readFilter(request);
        this.processStatus(request, filter);
        request.setAttribute("filter", (Object)filter);
        return mapping.findForward("index");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward exportTemplate(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForward;
        EctsTableFilter filter = this.readFilter(request);
        try {
            SheetData<?> builder = this.exportTemplate(request, filter);
            response.setContentType("text/csv");
            response.setHeader("Content-disposition", "attachment; filename=template.tsv");
            new SpreadsheetBuilder().addSheet("template", builder).build(WorkbookExportFormat.TSV, (OutputStream)response.getOutputStream());
            actionForward = null;
        }
        catch (Throwable throwable) {
            try {
                response.flushBuffer();
                throw throwable;
            }
            catch (IOException e) {
                this.addActionMessage(request, "error.ects.comparabilityTables.ioException");
                this.processStatus(request, filter);
                request.setAttribute("filter", (Object)filter);
                return mapping.findForward("index");
            }
        }
        response.flushBuffer();
        return actionForward;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward importTables(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        EctsTableFilter filter = this.readFilter(request);
        try {
            try {
                this.importTables(filter.getExecutionInterval(), filter.getType(), filter.getLevel(), filter.getContent());
            }
            catch (DomainException e) {
                this.addActionMessage(request, e.getKey(), e.getArgs());
            }
            catch (IOException e) {
                this.addActionMessage(request, "error.ects.table.unableToReadTablesFile");
            }
            this.processStatus(request, filter);
        }
        finally {
            filter.clearFileContent();
        }
        RenderUtils.invalidateViewState();
        request.setAttribute("filter", (Object)filter);
        return mapping.findForward("index");
    }

    private EctsTableFilter readFilter(HttpServletRequest request) {
        EctsTableFilter filter = (EctsTableFilter)this.getRenderedObject("filter");
        RenderUtils.invalidateViewState();
        if (filter == null) {
            filter = new EctsTableFilter();
            if (request.getParameter("interval") != null) {
                filter.setExecutionInterval(AcademicInterval.getAcademicIntervalFromResumedString(request.getParameter("interval")));
            }
            if (request.getParameter("type") != null) {
                filter.setType(EctsTableType.valueOf(request.getParameter("type")));
            }
            if (request.getParameter("level") != null) {
                filter.setLevel(EctsTableLevel.valueOf(request.getParameter("level")));
            }
        }
        return filter;
    }

    private void processStatus(HttpServletRequest request, EctsTableFilter filter) {
        switch (filter.getType()) {
            case ENROLMENT: {
                request.setAttribute("status", this.processEnrolmentStatus(filter));
                break;
            }
            case GRADUATION: {
                request.setAttribute("status", this.processGraduationStatus(filter));
            }
        }
    }

    private SheetData<?> exportTemplate(HttpServletRequest request, EctsTableFilter filter) {
        switch (filter.getType()) {
            case ENROLMENT: {
                return this.exportEnrolmentTemplate(filter);
            }
            case GRADUATION: {
                return this.exportGraduationTemplate(filter);
            }
        }
        throw new Error();
    }

    private void importTables(AcademicInterval executionInterval, EctsTableType type, EctsTableLevel level, String file) {
        try {
            switch (type) {
                case ENROLMENT: {
                    this.importEnrolmentTables(executionInterval, level, file);
                    break;
                }
                case GRADUATION: {
                    this.importGraduationTables(executionInterval, level, file);
                }
            }
        }
        catch (IOException e) {
            throw new DomainException("error.ects.table.unableToReadTablesFile", new String[0]);
        }
    }

    private Set<IEctsConversionTable> processEnrolmentStatus(EctsTableFilter filter) {
        switch (filter.getLevel()) {
            case COMPETENCE_COURSE: {
                return this.processEnrolmentByCompetenceCourseStatus(filter);
            }
            case DEGREE: {
                return this.processEnrolmentByDegreeStatus(filter);
            }
            case CURRICULAR_YEAR: {
                return this.processEnrolmentByCurricularYearStatus(filter);
            }
            case SCHOOL: {
                return this.processEnrolmentByInstitutionStatus(filter);
            }
        }
        return Collections.emptySet();
    }

    private SheetData<?> exportEnrolmentTemplate(EctsTableFilter filter) {
        switch (filter.getLevel()) {
            case COMPETENCE_COURSE: {
                return this.exportEnrolmentByCompetenceCourseTemplate(filter);
            }
            case DEGREE: {
                return this.exportEnrolmentByDegreeTemplate(filter);
            }
            case CURRICULAR_YEAR: {
                return this.exportEnrolmentByCurricularYearTemplate(filter);
            }
            case SCHOOL: {
                return this.exportEnrolmentByInstitutionTemplate(filter);
            }
        }
        throw new Error();
    }

    private void importEnrolmentTables(AcademicInterval executionInterval, EctsTableLevel level, String file) {
        switch (level) {
            case COMPETENCE_COURSE: {
                this.importEnrolmentByCompetenceCourseTables(executionInterval, file);
                break;
            }
            case DEGREE: {
                this.importEnrolmentByDegreeTables(executionInterval, file);
                break;
            }
            case CURRICULAR_YEAR: {
                this.importEnrolmentByCurricularYearTables(executionInterval, file);
                break;
            }
            case SCHOOL: {
                this.importEnrolmentByInstitutionTables(executionInterval, file);
            }
        }
    }

    private Set<IEctsConversionTable> processGraduationStatus(EctsTableFilter filter) {
        switch (filter.getLevel()) {
            case DEGREE: {
                return this.processGraduationByDegreeStatus(filter);
            }
            case CYCLE: {
                return this.processGraduationByCycleStatus(filter);
            }
        }
        return Collections.emptySet();
    }

    private SheetData<IEctsConversionTable> exportGraduationTemplate(EctsTableFilter filter) {
        switch (filter.getLevel()) {
            case DEGREE: {
                return this.exportGraduationByDegreeTemplate(filter);
            }
            case CYCLE: {
                return this.exportGraduationByCycleTemplate(filter);
            }
        }
        throw new Error();
    }

    private void importGraduationTables(AcademicInterval executionInterval, EctsTableLevel level, String file) throws IOException {
        switch (level) {
            case DEGREE: {
                this.importGraduationByDegreeTables(executionInterval, file);
                break;
            }
            case CYCLE: {
                this.importGraduationByCycleTables(executionInterval, file);
            }
        }
    }

    private Set<IEctsConversionTable> processEnrolmentByCompetenceCourseStatus(EctsTableFilter filter) {
        ExecutionYear year = (ExecutionYear)((Object)ExecutionYear.getExecutionInterval((AcademicInterval)filter.getExecutionInterval()));
        HashSet<IEctsConversionTable> tables = new HashSet<IEctsConversionTable>();
        for (CompetenceCourse competenceCourse : rootDomainObject.getCompetenceCoursesSet()) {
            if (competenceCourse.getCurricularStage() != CurricularStage.PUBLISHED && competenceCourse.getCurricularStage() != CurricularStage.APPROVED || !competenceCourse.hasActiveScopesInExecutionYear(year).booleanValue()) continue;
            EctsCompetenceCourseConversionTable table = EctsTableIndex.readOrCreateByYear(filter.getExecutionInterval()).getEnrolmentTableBy(competenceCourse);
            if (table != null) {
                tables.add((IEctsConversionTable)((Object)table));
                continue;
            }
            tables.add(new NullEctsConversionTable((DomainObject)competenceCourse));
        }
        return tables;
    }

    private SheetData<IEctsConversionTable> exportEnrolmentByCompetenceCourseTemplate(EctsTableFilter filter) {
        final ExecutionYear year = (ExecutionYear)((Object)ExecutionYear.getExecutionInterval((AcademicInterval)filter.getExecutionInterval()));
        final ExecutionSemester querySemester = year.getFirstExecutionPeriod();
        SheetData<IEctsConversionTable> builder = new SheetData<IEctsConversionTable>(this.processEnrolmentByCompetenceCourseStatus(filter)){

            protected void makeLine(IEctsConversionTable table) {
                CompetenceCourse competence = (CompetenceCourse)table.getTargetEntity();
                this.addCell(BundleUtil.getString((String)"resources.GEPResources", (String)"label.externalId", (String[])new String[0]), competence.getExternalId());
                this.addCell(BundleUtil.getString((String)"resources.GEPResources", (String)"label.departmentUnit.name", (String[])new String[0]), competence.getDepartmentUnit().getName());
                this.addCell(BundleUtil.getString((String)"resources.GEPResources", (String)"label.competenceCourse.name", (String[])new String[0]), competence.getName(querySemester));
                this.addCell(BundleUtil.getString((String)"resources.GEPResources", (String)"label.acronym", (String[])new String[0]), competence.getAcronym(querySemester));
                this.addCell(BundleUtil.getString((String)"resources.GEPResources", (String)"label.externalId", (String[])new String[0]), competence.getExternalId());
                HashSet<String> ids = new HashSet<String>();
                for (CurricularCourse course : competence.getAssociatedCurricularCoursesSet()) {
                    List<ExecutionCourse> executions = course.getExecutionCoursesByExecutionYear(year);
                    for (ExecutionCourse executionCourse : executions) {
                        if (ids.contains(executionCourse.getExternalId().toString())) continue;
                        ids.add(executionCourse.getExternalId().toString());
                    }
                }
                this.addCell(BundleUtil.getString((String)"resources.GEPResources", (String)"label.competenceCourse.executionCodes", (String[])new String[0]), StringUtils.join(ids, (String)", "));
                EctsComparabilityTable ects = table.getEctsTable();
                for (int i = 10; i <= 20; ++i) {
                    this.addCell(i + "", !ects.convert(i).equals("NA") ? ects.convert(i) : null);
                }
            }
        };
        return builder;
    }

    private void importEnrolmentByCompetenceCourseTables(AcademicInterval academicInterval, String string) {
        Object object = advice$importEnrolmentByCompetenceCourseTables.perform((Callable)new ManageEctsComparabilityTablesDispatchAction$callable$importEnrolmentByCompetenceCourseTables(this, academicInterval, string));
    }

    static /* synthetic */ void advised$importEnrolmentByCompetenceCourseTables(ManageEctsComparabilityTablesDispatchAction this_, AcademicInterval executionInterval, String file) {
        ExecutionSemester querySemester = ExecutionYear.readByAcademicInterval(executionInterval).getFirstExecutionPeriod();
        for (String line : file.split("\n")) {
            if (line.startsWith(BundleUtil.getString((String)"resources.GEPResources", (String)"label.externalId", (String[])new String[0]))) continue;
            String[] parts = this_.fillArray(line.split(SEPARATOR), 17);
            CompetenceCourse competence = (CompetenceCourse)FenixFramework.getDomainObject((String)parts[0]);
            EctsCompetenceCourseConversionTable.createConversionTable(competence, executionInterval, Arrays.copyOfRange(parts, 6, 17));
        }
    }

    private Set<IEctsConversionTable> processEnrolmentByDegreeStatus(EctsTableFilter filter) {
        ExecutionYear year = (ExecutionYear)((Object)ExecutionYear.getExecutionInterval((AcademicInterval)filter.getExecutionInterval()));
        HashSet<IEctsConversionTable> tables = new HashSet<IEctsConversionTable>();
        for (Degree degree : rootDomainObject.getDegreesSet()) {
            if (!degree.getDegreeCurricularPlansExecutionYears().contains(year) || !degree.getDegreeType().isBolonhaDegree() && !degree.getDegreeType().isBolonhaMasterDegree() && !degree.getDegreeType().isIntegratedMasterDegree() && !degree.getDegreeType().isAdvancedSpecializationDiploma()) continue;
            for (int i = 1; i <= degree.getMostRecentDegreeCurricularPlan().getDurationInYears(); ++i) {
                EctsDegreeByCurricularYearConversionTable table = EctsTableIndex.readOrCreateByYear(filter.getExecutionInterval()).getEnrolmentTableBy(degree, CurricularYear.readByYear(i));
                if (table != null) {
                    tables.add((IEctsConversionTable)((Object)table));
                    continue;
                }
                tables.add(new NullEctsConversionTable((DomainObject)degree, CurricularYear.readByYear(i)));
            }
        }
        return tables;
    }

    private SheetData<IEctsConversionTable> exportEnrolmentByDegreeTemplate(EctsTableFilter filter) {
        SheetData<IEctsConversionTable> builder = new SheetData<IEctsConversionTable>(this.processEnrolmentByDegreeStatus(filter)){

            protected void makeLine(IEctsConversionTable table) {
                Degree degree = (Degree)table.getTargetEntity();
                this.addCell(BundleUtil.getString((String)"resources.GEPResources", (String)"label.externalId", (String[])new String[0]), degree.getExternalId());
                this.addCell(BundleUtil.getString((String)"resources.GEPResources", (String)"label.degreeType", (String[])new String[0]), degree.getDegreeType().getName().getContent());
                this.addCell(BundleUtil.getString((String)"resources.GEPResources", (String)"label.name", (String[])new String[0]), degree.getName());
                this.addCell(BundleUtil.getString((String)"resources.GEPResources", (String)"label.curricularYear", (String[])new String[0]), table.getCurricularYear().getYear());
                EctsComparabilityTable ects = table.getEctsTable();
                for (int i = 10; i <= 20; ++i) {
                    this.addCell(i + "", !ects.convert(i).equals("NA") ? ects.convert(i) : null);
                }
            }
        };
        return builder;
    }

    private void importEnrolmentByDegreeTables(AcademicInterval academicInterval, String string) {
        Object object = advice$importEnrolmentByDegreeTables.perform((Callable)new ManageEctsComparabilityTablesDispatchAction$callable$importEnrolmentByDegreeTables(this, academicInterval, string));
    }

    static /* synthetic */ void advised$importEnrolmentByDegreeTables(ManageEctsComparabilityTablesDispatchAction this_, AcademicInterval executionInterval, String file) {
        for (String line : file.split("\n")) {
            if (line.startsWith(BundleUtil.getString((String)"resources.GEPResources", (String)"label.externalId", (String[])new String[0]))) continue;
            String[] parts = this_.fillArray(line.split(SEPARATOR), 15);
            Degree degree = (Degree)FenixFramework.getDomainObject((String)parts[0]);
            if (!degree.getDegreeType().getName().getContent().equals(parts[1])) {
                throw new DomainException("error.ects.invalidLine.nonMatchingCourse", parts[0], parts[1], degree.getDegreeType().getName().getContent());
            }
            if (!degree.getName().equals(parts[2])) {
                throw new DomainException("error.ects.invalidLine.nonMatchingCourse", parts[0], parts[2], degree.getName());
            }
            CurricularYear year = CurricularYear.readByYear(Integer.parseInt(parts[3]));
            EctsDegreeByCurricularYearConversionTable.createConversionTable(degree, executionInterval, year, Arrays.copyOfRange(parts, 4, 15));
        }
    }

    private Set<IEctsConversionTable> processEnrolmentByCurricularYearStatus(EctsTableFilter filter) {
        Unit ist = UnitUtils.readInstitutionUnit();
        HashSet<IEctsConversionTable> tables = new HashSet<IEctsConversionTable>();
        for (CycleType cycle : CycleType.getSortedValues()) {
            List<Object> years = null;
            switch (cycle) {
                case FIRST_CYCLE: {
                    years = Arrays.asList(1, 2, 3);
                    break;
                }
                case SECOND_CYCLE: {
                    years = Arrays.asList(1, 2, 4, 5);
                    break;
                }
                case THIRD_CYCLE: {
                    years = Arrays.asList(1, 2);
                    break;
                }
                default: {
                    years = Collections.emptyList();
                }
            }
            for (Integer year : years) {
                EctsInstitutionByCurricularYearConversionTable table = EctsTableIndex.readOrCreateByYear(filter.getExecutionInterval()).getEnrolmentTableBy(ist, CurricularYear.readByYear(year), cycle);
                if (table != null) {
                    tables.add((IEctsConversionTable)((Object)table));
                    continue;
                }
                tables.add(new NullEctsConversionTable((DomainObject)ist, cycle, CurricularYear.readByYear(year)));
            }
        }
        return tables;
    }

    private SheetData<IEctsConversionTable> exportEnrolmentByCurricularYearTemplate(EctsTableFilter filter) {
        SheetData<IEctsConversionTable> builder = new SheetData<IEctsConversionTable>(this.processEnrolmentByCurricularYearStatus(filter)){

            protected void makeLine(IEctsConversionTable table) {
                this.addCell(BundleUtil.getString((String)"resources.GEPResources", (String)"label.cycle", (String[])new String[0]), table.getCycle().ordinal() + 1);
                this.addCell(BundleUtil.getString((String)"resources.GEPResources", (String)"label.curricularYear", (String[])new String[0]), table.getCurricularYear().getYear());
                EctsComparabilityTable ects = table.getEctsTable();
                for (int i = 10; i <= 20; ++i) {
                    this.addCell(i + "", !ects.convert(i).equals("NA") ? ects.convert(i) : null);
                }
            }
        };
        return builder;
    }

    private void importEnrolmentByCurricularYearTables(AcademicInterval academicInterval, String string) {
        Object object = advice$importEnrolmentByCurricularYearTables.perform((Callable)new ManageEctsComparabilityTablesDispatchAction$callable$importEnrolmentByCurricularYearTables(this, academicInterval, string));
    }

    static /* synthetic */ void advised$importEnrolmentByCurricularYearTables(ManageEctsComparabilityTablesDispatchAction this_, AcademicInterval executionInterval, String file) {
        for (String line : file.split("\n")) {
            CycleType cycle;
            if (line.startsWith(BundleUtil.getString((String)"resources.GEPResources", (String)"label.cycle", (String[])new String[0]))) continue;
            String[] parts = this_.fillArray(line.split(SEPARATOR), 13);
            Unit ist = UnitUtils.readInstitutionUnit();
            try {
                cycle = CycleType.getSortedValues().toArray(new CycleType[0])[Integer.parseInt(parts[0]) - 1];
            }
            catch (NumberFormatException e) {
                cycle = null;
            }
            CurricularYear year = CurricularYear.readByYear(Integer.parseInt(parts[1]));
            EctsInstitutionByCurricularYearConversionTable.createConversionTable(ist, executionInterval, cycle, year, Arrays.copyOfRange(parts, 2, 13));
        }
    }

    private Set<IEctsConversionTable> processEnrolmentByInstitutionStatus(EctsTableFilter filter) {
        Unit ist = UnitUtils.readInstitutionUnit();
        HashSet<IEctsConversionTable> tables = new HashSet<IEctsConversionTable>();
        EctsInstitutionConversionTable table = EctsTableIndex.readOrCreateByYear(filter.getExecutionInterval()).getEnrolmentTableBy(ist);
        if (table != null) {
            tables.add((IEctsConversionTable)((Object)table));
        } else {
            tables.add(new NullEctsConversionTable((DomainObject)ist));
        }
        return tables;
    }

    private SheetData<IEctsConversionTable> exportEnrolmentByInstitutionTemplate(EctsTableFilter filter) {
        SheetData<IEctsConversionTable> builder = new SheetData<IEctsConversionTable>(this.processEnrolmentByInstitutionStatus(filter)){

            protected void makeLine(IEctsConversionTable table) {
                EctsComparabilityTable ects = table.getEctsTable();
                for (int i = 10; i <= 20; ++i) {
                    this.addCell(i + "", !ects.convert(i).equals("NA") ? ects.convert(i) : null);
                }
            }
        };
        return builder;
    }

    private void importEnrolmentByInstitutionTables(AcademicInterval academicInterval, String string) {
        Object object = advice$importEnrolmentByInstitutionTables.perform((Callable)new ManageEctsComparabilityTablesDispatchAction$callable$importEnrolmentByInstitutionTables(this, academicInterval, string));
    }

    static /* synthetic */ void advised$importEnrolmentByInstitutionTables(ManageEctsComparabilityTablesDispatchAction this_, AcademicInterval executionInterval, String file) {
        for (String line : file.split("\n")) {
            if (line.startsWith("10")) continue;
            String[] table = this_.fillArray(line.split(SEPARATOR), 11);
            Unit ist = UnitUtils.readInstitutionUnit();
            EctsInstitutionConversionTable.createConversionTable(ist, executionInterval, table);
        }
    }

    private Set<IEctsConversionTable> processGraduationByDegreeStatus(EctsTableFilter filter) {
        ExecutionYear year = (ExecutionYear)((Object)ExecutionYear.getExecutionInterval((AcademicInterval)filter.getExecutionInterval()));
        HashSet<IEctsConversionTable> tables = new HashSet<IEctsConversionTable>();
        for (Degree degree : rootDomainObject.getDegreesSet()) {
            if (!degree.getDegreeCurricularPlansExecutionYears().contains(year) || !degree.getDegreeType().isBolonhaDegree() && !degree.getDegreeType().isBolonhaMasterDegree() && !degree.getDegreeType().isIntegratedMasterDegree() && !degree.getDegreeType().isAdvancedSpecializationDiploma()) continue;
            for (CycleType cycle : degree.getDegreeType().getCycleTypes()) {
                EctsDegreeGraduationGradeConversionTable table = EctsTableIndex.readOrCreateByYear(filter.getExecutionInterval()).getGraduationTableBy(degree, cycle);
                if (table != null) {
                    tables.add((IEctsConversionTable)((Object)table));
                    continue;
                }
                if (degree.getDegreeType().isComposite()) {
                    tables.add(new NullEctsConversionTable((DomainObject)degree, cycle));
                    continue;
                }
                tables.add(new NullEctsConversionTable((DomainObject)degree));
            }
        }
        return tables;
    }

    private SheetData<IEctsConversionTable> exportGraduationByDegreeTemplate(EctsTableFilter filter) {
        SheetData<IEctsConversionTable> builder = new SheetData<IEctsConversionTable>(this.processGraduationByDegreeStatus(filter)){

            protected void makeLine(IEctsConversionTable table) {
                Degree degree = (Degree)table.getTargetEntity();
                this.addCell(BundleUtil.getString((String)"resources.GEPResources", (String)"label.externalId", (String[])new String[0]), degree.getExternalId());
                this.addCell(BundleUtil.getString((String)"resources.GEPResources", (String)"label.degreeType", (String[])new String[0]), degree.getDegreeType().getName().getContent());
                this.addCell(BundleUtil.getString((String)"resources.GEPResources", (String)"label.name", (String[])new String[0]), degree.getName());
                this.addCell(BundleUtil.getString((String)"resources.GEPResources", (String)"label.cycle", (String[])new String[0]), table.getCycle() != null ? Integer.valueOf(table.getCycle().ordinal() + 1) : null);
                EctsComparabilityTable ects = table.getEctsTable();
                for (int i = 10; i <= 20; ++i) {
                    this.addCell(i + "", !ects.convert(i).equals("NA") ? ects.convert(i) : null);
                }
                EctsComparabilityPercentages percentages = table.getPercentages();
                for (int i = 10; i <= 20; ++i) {
                    this.addCell(i + "", percentages.getPercentage(i) != -1.0 ? Double.valueOf(percentages.getPercentage(i)) : null);
                }
            }
        };
        return builder;
    }

    private void importGraduationByDegreeTables(AcademicInterval academicInterval, String string) {
        Object object = advice$importGraduationByDegreeTables.perform((Callable)new ManageEctsComparabilityTablesDispatchAction$callable$importGraduationByDegreeTables(this, academicInterval, string));
    }

    static /* synthetic */ void advised$importGraduationByDegreeTables(ManageEctsComparabilityTablesDispatchAction this_, AcademicInterval executionInterval, String file) {
        for (String line : file.split("\n")) {
            CycleType cycle;
            if (line.startsWith(BundleUtil.getString((String)"resources.GEPResources", (String)"label.externalId", (String[])new String[0]))) continue;
            String[] parts = this_.fillArray(line.split(SEPARATOR), 26);
            Degree degree = (Degree)FenixFramework.getDomainObject((String)parts[0]);
            if (!degree.getDegreeType().getName().getContent().equals(parts[1])) {
                throw new DomainException("error.ects.invalidLine.nonMatchingCourse", parts[0], parts[1], degree.getDegreeType().getName().getContent());
            }
            if (!degree.getName().equals(parts[2])) {
                throw new DomainException("error.ects.invalidLine.nonMatchingCourse", parts[0], parts[2], degree.getName());
            }
            try {
                cycle = CycleType.getSortedValues().toArray(new CycleType[0])[Integer.parseInt(parts[3]) - 1];
            }
            catch (NumberFormatException e) {
                cycle = null;
            }
            EctsDegreeGraduationGradeConversionTable.createConversionTable(degree, executionInterval, cycle, Arrays.copyOfRange(parts, 4, 15), Arrays.copyOfRange(parts, 15, 26));
        }
    }

    private Set<IEctsConversionTable> processGraduationByCycleStatus(EctsTableFilter filter) {
        Unit ist = UnitUtils.readInstitutionUnit();
        HashSet<IEctsConversionTable> tables = new HashSet<IEctsConversionTable>();
        for (CycleType cycle : CycleType.getSortedValues()) {
            EctsCycleGraduationGradeConversionTable table = EctsTableIndex.readOrCreateByYear(filter.getExecutionInterval()).getGraduationTableBy(cycle);
            if (table != null) {
                tables.add((IEctsConversionTable)((Object)table));
                continue;
            }
            tables.add(new NullEctsConversionTable((DomainObject)ist, cycle));
        }
        return tables;
    }

    private SheetData<IEctsConversionTable> exportGraduationByCycleTemplate(EctsTableFilter filter) {
        SheetData<IEctsConversionTable> builder = new SheetData<IEctsConversionTable>(this.processGraduationByCycleStatus(filter)){

            protected void makeLine(IEctsConversionTable table) {
                this.addCell(BundleUtil.getString((String)"resources.GEPResources", (String)"label.cycle", (String[])new String[0]), table.getCycle().ordinal() + 1);
                EctsComparabilityTable ects = table.getEctsTable();
                for (int i = 10; i <= 20; ++i) {
                    this.addCell(i + "", !ects.convert(i).equals("NA") ? ects.convert(i) : null);
                }
                EctsComparabilityPercentages percentages = table.getPercentages();
                for (int i = 10; i <= 20; ++i) {
                    this.addCell(i + "", percentages.getPercentage(i) != -1.0 ? Double.valueOf(percentages.getPercentage(i)) : null);
                }
            }
        };
        return builder;
    }

    private void importGraduationByCycleTables(AcademicInterval academicInterval, String string) {
        Object object = advice$importGraduationByCycleTables.perform((Callable)new ManageEctsComparabilityTablesDispatchAction$callable$importGraduationByCycleTables(this, academicInterval, string));
    }

    static /* synthetic */ void advised$importGraduationByCycleTables(ManageEctsComparabilityTablesDispatchAction this_, AcademicInterval executionInterval, String file) {
        for (String line : file.split("\n")) {
            if (line.startsWith(BundleUtil.getString((String)"resources.GEPResources", (String)"label.cycle", (String[])new String[0]))) continue;
            String[] parts = this_.fillArray(line.split(SEPARATOR), 23);
            CycleType cycle = CycleType.getSortedValues().toArray(new CycleType[0])[Integer.parseInt(parts[0]) - 1];
            Unit ist = UnitUtils.readInstitutionUnit();
            EctsCycleGraduationGradeConversionTable.createConversionTable(ist, executionInterval, cycle, Arrays.copyOfRange(parts, 1, 12), Arrays.copyOfRange(parts, 12, 23));
        }
    }

    private String[] fillArray(String[] array, int length) {
        String[] filled = new String[length];
        for (int i = 0; i < array.length; ++i) {
            filled[i] = array[i];
        }
        return filled;
    }
}

