/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.commons.transition;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;

public abstract class AbstractBolonhaTransitionManagementDA
extends FenixDispatchAction {
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        List<Registration> registrations = this.getRegistrations(request);
        if (registrations.size() == 1) {
            Registration registration = registrations.iterator().next();
            this.setParametersToShowStudentCurricularPlan(form, request, registration);
            return mapping.findForward("showStudentCurricularPlan");
        }
        request.setAttribute("registrations", registrations);
        return mapping.findForward("chooseRegistration");
    }

    private void setParametersToShowStudentCurricularPlan(ActionForm form, HttpServletRequest request, Registration registration) {
        this.setRegistration(request, registration);
        DynaActionForm dynaActionForm = (DynaActionForm)form;
        dynaActionForm.set("registrationId", (Object)registration.getExternalId());
    }

    private void setRegistration(HttpServletRequest request, Registration registration) {
        request.setAttribute("registration", (Object)registration);
    }

    public ActionForward showStudentCurricularPlan(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.setParametersToShowStudentCurricularPlan(form, request, this.getRegistration(request, form));
        return mapping.findForward("showStudentCurricularPlan");
    }

    private Registration getRegistration(HttpServletRequest request, ActionForm form) {
        return this.getRegistration(request, (String)((DynaActionForm)form).get("registrationId"));
    }

    private Registration getRegistration(HttpServletRequest request, String registrationId) {
        for (Registration registration : this.getRegistrations(request)) {
            if (!registration.getExternalId().equals(registrationId)) continue;
            return registration;
        }
        return null;
    }

    protected abstract List<Registration> getRegistrations(HttpServletRequest var1);
}

