/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.providers;

import java.util.ArrayList;
import java.util.Collections;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.interfaces.HasExecutionDegree;
import org.fenixedu.academic.domain.interfaces.HasExecutionSemester;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class ExecutionCourseForExecutionDegreeAndExecutionPeriodProvider
implements DataProvider {
    public Object provide(Object source, Object currentValue) {
        ArrayList<ExecutionCourse> executionCourses = new ArrayList<ExecutionCourse>();
        HasExecutionSemester hasExecutionSemester = (HasExecutionSemester)source;
        ExecutionSemester executionPeriod = hasExecutionSemester.getExecutionPeriod();
        HasExecutionDegree hasExecutionDegree = (HasExecutionDegree)source;
        ExecutionDegree executionDegree = hasExecutionDegree.getExecutionDegree();
        DegreeCurricularPlan degreeCurricularPlan = executionDegree.getDegreeCurricularPlan();
        if (executionPeriod != null && executionDegree != null) {
            for (ExecutionCourse executionCourse : executionPeriod.getAssociatedExecutionCoursesSet()) {
                if (!this.matches(executionCourse, degreeCurricularPlan)) continue;
                executionCourses.add(executionCourse);
            }
        }
        Collections.sort(executionCourses, ExecutionCourse.EXECUTION_COURSE_NAME_COMPARATOR);
        return executionCourses;
    }

    private boolean matches(ExecutionCourse executionCourse, DegreeCurricularPlan degreeCurricularPlan) {
        for (CurricularCourse curricularCourse : executionCourse.getAssociatedCurricularCoursesSet()) {
            if (curricularCourse.getDegreeCurricularPlan() != degreeCurricularPlan) continue;
            return true;
        }
        return false;
    }

    public Converter getConverter() {
        return new DomainObjectKeyConverter();
    }
}

