/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.manager;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.academic.service.services.manager.TransferEnrollments$callable$run;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class TransferEnrollments {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static void run(String string, String[] stringArray, String string2) {
        Object object = advice$run.perform((Callable)new TransferEnrollments$callable$run(string, stringArray, string2));
    }

    static /* synthetic */ void advised$run(String destinationStudentCurricularPlanId, String[] enrollmentIDsToTransfer, String destinationCurriculumGroupID) {
        AccessControl.check(RolePredicates.MANAGER_OR_OPERATOR_PREDICATE);
        if (!StringUtils.isEmpty((String)destinationCurriculumGroupID)) {
            CurriculumGroup curriculumGroup = (CurriculumGroup)FenixFramework.getDomainObject((String)destinationCurriculumGroupID);
            StudentCurricularPlan studentCurricularPlan = curriculumGroup.getStudentCurricularPlan();
            for (String enrollmentIDToTransfer : enrollmentIDsToTransfer) {
                Enrolment enrolment = (Enrolment)FenixFramework.getDomainObject((String)enrollmentIDToTransfer);
                TransferEnrollments.fixEnrolmentCurricularCourse(studentCurricularPlan, enrolment);
                enrolment.setCurriculumGroup(curriculumGroup);
                enrolment.setStudentCurricularPlan(null);
            }
        } else {
            StudentCurricularPlan studentCurricularPlan = (StudentCurricularPlan)FenixFramework.getDomainObject((String)destinationStudentCurricularPlanId);
            for (String enrollmentIDToTransfer : enrollmentIDsToTransfer) {
                Enrolment enrollment = (Enrolment)FenixFramework.getDomainObject((String)enrollmentIDToTransfer);
                TransferEnrollments.fixEnrolmentCurricularCourse(studentCurricularPlan, enrollment);
                if (enrollment.getStudentCurricularPlan() == studentCurricularPlan) continue;
                enrollment.setStudentCurricularPlan(studentCurricularPlan);
                enrollment.setCurriculumGroup(null);
            }
        }
    }

    private static void fixEnrolmentCurricularCourse(StudentCurricularPlan studentCurricularPlan, Enrolment enrollment) {
        CurricularCourse curricularCourse;
        if (enrollment.getCurricularCourse().getDegreeCurricularPlan() != studentCurricularPlan.getDegreeCurricularPlan() && (curricularCourse = studentCurricularPlan.getDegreeCurricularPlan().getCurricularCourseByCode(enrollment.getCurricularCourse().getCode())) != null) {
            enrollment.setCurricularCourse(curricularCourse);
        }
    }
}

