/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.phd.notification;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.postingRules.FixedAmountPR;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdParticipant;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcess;
import org.fenixedu.academic.domain.phd.notification.PhdNotification;
import org.fenixedu.academic.report.FenixReport;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class PhdNotificationDocument
extends FenixReport {
    private static final String DATE_FORMAT_PT = "dd/MM/yyyy";
    private static final String DATE_FORMAT_EN = "yyyy/MM/dd";
    private PhdNotification notification;
    private Locale language;

    public PhdNotificationDocument(PhdNotification notification, Locale language) {
        this.setNotification(notification);
        this.setLanguage(language);
        this.fillReport();
    }

    private PhdNotification getNotification() {
        return this.notification;
    }

    private void setNotification(PhdNotification notification) {
        this.notification = notification;
    }

    @Override
    public Locale getLanguage() {
        return this.language;
    }

    public void setLanguage(Locale language) {
        this.language = language;
    }

    @Override
    protected void fillReport() {
        PhdProgramCandidacyProcess candidacyProcess = this.getNotification().getCandidacyProcess();
        Person person = candidacyProcess.getPerson();
        PhdIndividualProgramProcess individualProgramProcess = candidacyProcess.getIndividualProgramProcess();
        this.addParameter("administrativeOfficeCoordinator", individualProgramProcess.getPhdProgram().getAdministrativeOffice().getCoordinator().getProfile().getDisplayName());
        this.addParameter("name", person.getName());
        this.addParameter("address", person.getAddress());
        this.addParameter("areaCode", person.getAreaCode());
        this.addParameter("areaOfAreaCode", person.getAreaOfAreaCode());
        this.addParameter("programName", individualProgramProcess.getPhdProgram().getName().getContent(this.getLanguage()));
        this.addParameter("processNumber", individualProgramProcess.getProcessNumber());
        LocalDate whenRatified = candidacyProcess.getWhenRatified();
        this.addParameter("ratificationDate", whenRatified != null ? whenRatified.toString(this.getDateFormat()) : "");
        this.addParameter("insuranceFee", this.getInsuranceFee(individualProgramProcess));
        this.addParameter("registrationFee", this.getRegistrationFee(individualProgramProcess, whenRatified));
        this.addParameter("date", new LocalDate().toString(this.getDateFormat()));
        this.addParameter("notificationNumber", this.getNotification().getNotificationNumber());
        this.addGuidingsParameter(individualProgramProcess);
    }

    private void addGuidingsParameter(PhdIndividualProgramProcess individualProgramProcess) {
        if (!individualProgramProcess.getGuidingsSet().isEmpty() && !individualProgramProcess.getAssistantGuidingsSet().isEmpty()) {
            this.addParameter("guidingsInformation", MessageFormat.format(this.getMessageFromResource(this.getClass().getName() + ".full.guidings.template"), this.buildGuidingsInformation(individualProgramProcess.getGuidingsSet()), this.buildGuidingsInformation(individualProgramProcess.getAssistantGuidingsSet())));
        } else if (!individualProgramProcess.getGuidingsSet().isEmpty()) {
            this.addParameter("guidingsInformation", MessageFormat.format(this.getMessageFromResource(this.getClass().getName() + ".guidings.only.template"), this.buildGuidingsInformation(individualProgramProcess.getGuidingsSet())));
        } else {
            this.addParameter("guidingsInformation", "");
        }
    }

    private String buildGuidingsInformation(Collection<PhdParticipant> guidings) {
        StringBuilder result = new StringBuilder();
        ArrayList<PhdParticipant> guidingsList = new ArrayList<PhdParticipant>(guidings);
        for (int i = 0; i < guidingsList.size(); ++i) {
            PhdParticipant guiding = (PhdParticipant)((Object)guidingsList.get(i));
            result.append(guiding.getNameWithTitle());
            if (i == guidings.size() - 2) {
                result.append(" ").append(this.getMessageFromResource("label.and")).append(" ");
                continue;
            }
            result.append(", ");
        }
        if (result.length() > 0) {
            if (result.toString().endsWith(this.getMessageFromResource("label.and"))) {
                return result.substring(0, result.length() - this.getMessageFromResource("label.and").length());
            }
            if (result.toString().endsWith(", ")) {
                return result.substring(0, result.length() - 2);
            }
        }
        return result.toString();
    }

    private String getMessageFromResource(String key) {
        return BundleUtil.getString((String)"resources.PhdResources", (Locale)this.getLanguage(), (String)key, (String[])new String[0]);
    }

    private String getDateFormat() {
        return this.getLanguage() == MultiLanguageString.pt ? DATE_FORMAT_PT : DATE_FORMAT_EN;
    }

    private String getRegistrationFee(PhdIndividualProgramProcess individualProgramProcess, LocalDate whenRatified) {
        return whenRatified != null ? ((FixedAmountPR)((Object)individualProgramProcess.getPhdProgram().getServiceAgreementTemplate().findPostingRuleByEventTypeAndDate(EventType.PHD_REGISTRATION_FEE, whenRatified.toDateTimeAtMidnight()))).getFixedAmount().toPlainString() : "";
    }

    private String getInsuranceFee(PhdIndividualProgramProcess individualProgramProcess) {
        return ((FixedAmountPR)((Object)Bennu.getInstance().getInstitutionUnit().getUnitServiceAgreementTemplate().findPostingRuleBy(EventType.INSURANCE, individualProgramProcess.getExecutionYear().getBeginDateYearMonthDay().toDateTimeAtMidnight(), individualProgramProcess.getExecutionYear().getEndDateYearMonthDay().toDateTimeAtMidnight()))).getFixedAmount().toPlainString();
    }

    @Override
    public String getReportFileName() {
        return "Notification-" + this.getNotification().getNotificationNumber().replace("/", "-") + "-" + new DateTime().toString("yyyyMMddHHmmss");
    }

    @Override
    public String getReportTemplateKey() {
        return this.getClass().getName() + "." + this.getNotification().getType().name() + "." + this.getLanguage();
    }
}

