/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.enrolment;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularRules.CurricularRule;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;

public class EnroledCurriculumModuleWrapper
implements Serializable,
IDegreeModuleToEvaluate {
    private static final long serialVersionUID = 8730987603988026373L;
    private CurriculumModule curriculumModule;
    protected Context context;
    private ExecutionSemester executionSemester;

    public EnroledCurriculumModuleWrapper(CurriculumModule curriculumModule, ExecutionSemester executionSemester) {
        this.setCurriculumModule(curriculumModule);
        this.setExecutionPeriod(executionSemester);
    }

    public CurriculumModule getCurriculumModule() {
        return this.curriculumModule;
    }

    public void setCurriculumModule(CurriculumModule curriculumModule) {
        this.curriculumModule = curriculumModule;
    }

    @Override
    public Context getContext() {
        if (this.context == null && !this.getCurriculumModule().isRoot()) {
            this.findContext();
        }
        return this.context;
    }

    private void findContext() {
        Context result = null;
        CurriculumGroup parent = this.getCurriculumModule().getCurriculumGroup();
        if (parent.getDegreeModule() != null) {
            for (Context context : parent.getDegreeModule().getValidChildContexts(this.getExecutionPeriod())) {
                if (context.getChildDegreeModule() != this.getDegreeModule() || result != null && context.getCurricularYear() >= result.getCurricularYear()) continue;
                result = context;
            }
        }
        this.setContext(result);
    }

    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public ExecutionSemester getExecutionPeriod() {
        return this.executionSemester;
    }

    public void setExecutionPeriod(ExecutionSemester executionSemester) {
        this.executionSemester = executionSemester;
    }

    @Override
    public CurriculumGroup getCurriculumGroup() {
        return this.getCurriculumModule().getCurriculumGroup();
    }

    @Override
    public DegreeModule getDegreeModule() {
        return this.getCurriculumModule().getDegreeModule();
    }

    public boolean hasDegreeModule() {
        return this.getDegreeModule() != null;
    }

    @Override
    public boolean isLeaf() {
        if (!this.getCurriculumModule().isLeaf()) {
            return false;
        }
        CurriculumLine curriculumLine = (CurriculumLine)((Object)this.getCurriculumModule());
        return curriculumLine.isEnrolment();
    }

    @Override
    public final boolean isEnroled() {
        return true;
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    @Override
    public boolean isDissertation() {
        return false;
    }

    @Override
    public boolean canCollectRules() {
        if (this.getCurriculumModule().isLeaf()) {
            return true;
        }
        CurriculumGroup curriculumGroup = (CurriculumGroup)((Object)this.getCurriculumModule());
        return curriculumGroup.getCurriculumModulesSet().isEmpty();
    }

    @Override
    public Double getEctsCredits(ExecutionSemester executionSemester) {
        return this.getCurriculumModule().getEctsCredits();
    }

    public boolean equals(Object obj) {
        if (obj instanceof EnroledCurriculumModuleWrapper) {
            EnroledCurriculumModuleWrapper moduleEnroledWrapper = (EnroledCurriculumModuleWrapper)obj;
            return this.getCurriculumModule() == moduleEnroledWrapper.getCurriculumModule();
        }
        return false;
    }

    public int hashCode() {
        return this.getCurriculumModule().hashCode();
    }

    @Override
    public List<CurricularRule> getCurricularRulesFromDegreeModule(ExecutionSemester executionSemester) {
        return this.hasDegreeModule() ? this.getDegreeModule().getCurricularRules(this.getContext(), executionSemester) : Collections.EMPTY_LIST;
    }

    @Override
    public Set<ICurricularRule> getCurricularRulesFromCurriculumGroup(ExecutionSemester executionSemester) {
        return this.getCurriculumModule().isRoot() ? Collections.EMPTY_SET : this.getCurriculumGroup().getCurricularRules(executionSemester);
    }

    @Override
    public double getAccumulatedEctsCredits(ExecutionSemester executionSemester) {
        if (this.getCurriculumModule().isEnrolment()) {
            return ((Enrolment)((Object)this.getCurriculumModule())).getAccumulatedEctsCredits(executionSemester);
        }
        return 0.0;
    }

    @Override
    public String getName() {
        return this.getCurriculumModule().getName().getContent();
    }

    @Override
    public String getYearFullLabel() {
        if (this.getExecutionPeriod() != null) {
            return this.getExecutionPeriod().getQualifiedName();
        }
        return "";
    }

    @Override
    public boolean isOptionalCurricularCourse() {
        return false;
    }

    @Override
    public Double getEctsCredits() {
        return this.getCurriculumModule().getEctsCredits();
    }

    @Override
    public String getKey() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(((Object)((Object)this.getCurriculumModule())).getClass().getName()).append(":").append(this.getCurriculumModule().getExternalId()).append(",").append(this.getExecutionPeriod().getClass().getName()).append(":").append(this.getExecutionPeriod().getExternalId());
        return stringBuilder.toString();
    }

    @Override
    public final boolean isEnroling() {
        return false;
    }

    @Override
    public boolean isFor(DegreeModule degreeModule) {
        return this.getDegreeModule() == degreeModule;
    }

    @Override
    public boolean isAnnualCurricularCourse(ExecutionYear executionYear) {
        if (this.getDegreeModule().isLeaf()) {
            return ((CurricularCourse)((Object)this.getDegreeModule())).isAnual(executionYear);
        }
        return false;
    }
}

