/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularPeriod;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod_Base;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.dto.CurricularPeriodInfoDTO;
import org.fenixedu.academic.util.CurricularPeriodLabelFormatter;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class CurricularPeriod
extends CurricularPeriod_Base
implements Comparable<CurricularPeriod> {
    public CurricularPeriod(AcademicPeriod academicPeriod) {
        this.setRootDomainObject(Bennu.getInstance());
        this.setAcademicPeriod(academicPeriod);
    }

    public CurricularPeriod(AcademicPeriod academicPeriod, Integer order, CurricularPeriod parent) {
        this(academicPeriod);
        this.setChildOrder(order);
        this.setParent(parent);
    }

    public List<CurricularPeriod> getSortedChilds() {
        ArrayList<CurricularPeriod> sortedChilds = new ArrayList<CurricularPeriod>();
        sortedChilds.addAll(this.getChildsSet());
        Collections.sort(sortedChilds);
        return sortedChilds;
    }

    public CurricularPeriod getChildByOrder(Integer order) {
        for (CurricularPeriod curricularPeriod : this.getChildsSet()) {
            if (!curricularPeriod.getChildOrder().equals(order)) continue;
            return curricularPeriod;
        }
        return null;
    }

    private CurricularPeriod findChild(AcademicPeriod academicPeriod, Integer order) {
        for (CurricularPeriod curricularPeriod : this.getChildsSet()) {
            if (!curricularPeriod.getChildOrder().equals(order) || !curricularPeriod.getAcademicPeriod().equals((Object)academicPeriod)) continue;
            return curricularPeriod;
        }
        return null;
    }

    public CurricularPeriod getCurricularPeriod(CurricularPeriodInfoDTO ... curricularPeriodsPaths) {
        this.validatePath(curricularPeriodsPaths);
        CurricularPeriod curricularPeriod = this;
        for (CurricularPeriodInfoDTO path : curricularPeriodsPaths) {
            if ((curricularPeriod = curricularPeriod.findChild(path.getPeriodType(), path.getOrder())) != null) continue;
            return null;
        }
        return curricularPeriod;
    }

    public CurricularPeriod addCurricularPeriod(CurricularPeriodInfoDTO ... curricularPeriodsPaths) {
        this.validatePath(curricularPeriodsPaths);
        CurricularPeriod curricularPeriod = null;
        CurricularPeriod curricularPeriodParent = this;
        for (CurricularPeriodInfoDTO path : curricularPeriodsPaths) {
            curricularPeriod = curricularPeriodParent.findChild(path.getPeriodType(), path.getOrder());
            if (curricularPeriod == null) {
                curricularPeriod = new CurricularPeriod(path.getPeriodType(), path.getOrder(), curricularPeriodParent);
            }
            curricularPeriodParent = curricularPeriod;
        }
        return curricularPeriod;
    }

    public Integer getOrderByType(AcademicPeriod academicPeriod) {
        Integer resultOrder = null;
        if (this.getAcademicPeriod().equals((Object)academicPeriod)) {
            resultOrder = this.getChildOrder();
        } else if (this.getParent() != null && this.getParent().getAcademicPeriod().getWeight() > this.getAcademicPeriod().getWeight()) {
            resultOrder = this.getParent().getOrderByType(academicPeriod);
        }
        return resultOrder;
    }

    private void validatePath(CurricularPeriodInfoDTO ... curricularPeriodsPaths) {
        Arrays.sort(curricularPeriodsPaths, new Comparator<CurricularPeriodInfoDTO>(){

            @Override
            public int compare(CurricularPeriodInfoDTO c1, CurricularPeriodInfoDTO c2) {
                if (c1.getPeriodType().getWeight() > c2.getPeriodType().getWeight()) {
                    return -1;
                }
                if (c1.getPeriodType().getWeight() < c2.getPeriodType().getWeight()) {
                    return 1;
                }
                throw new DomainException("error.pathShouldNotHaveSameTypePeriods", new String[0]);
            }
        });
    }

    public void delete() {
        this.getContextsSet().clear();
        this.setDegreeCurricularPlan(null);
        this.setParent(null);
        for (CurricularPeriod child : this.getChildsSet()) {
            child.delete();
        }
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public String getLabel() {
        return CurricularPeriodLabelFormatter.getLabel(this, false);
    }

    public String getFullLabel() {
        return CurricularPeriodLabelFormatter.getFullLabel(this, false);
    }

    public String getFullLabel(Locale locale) {
        return CurricularPeriodLabelFormatter.getFullLabelI18N(this, false, locale);
    }

    @Override
    public int compareTo(CurricularPeriod o) {
        return this.getFullWeight().compareTo(o.getFullWeight());
    }

    private Float getWeight() {
        float periodTypeWeight = this.getAcademicPeriod() == null ? 0.0f : this.getAcademicPeriod().getWeight();
        float periodOrder = this.getChildOrder() == null ? 0.0f : (float)this.getChildOrder().intValue();
        return Float.valueOf(periodTypeWeight * periodOrder);
    }

    private Float getFullWeight() {
        return Float.valueOf(this.getWeight().floatValue() + this.collectParentsWeight(this).floatValue());
    }

    private Float collectParentsWeight(CurricularPeriod period) {
        Float result = Float.valueOf(0.0f);
        if (period.getParent() != null) {
            result = Float.valueOf(period.getParent().getWeight().floatValue() + this.collectParentsWeight(period.getParent()).floatValue());
        }
        return result;
    }

    public Integer getParentOrder() {
        if (this.getParent() != null) {
            return this.getParent().getChildOrder();
        }
        return null;
    }

    public CurricularPeriod getNext() {
        List<CurricularPeriod> brothers = this.getParent().getSortedChilds();
        Iterator<CurricularPeriod> iterator = brothers.iterator();
        while (iterator.hasNext()) {
            CurricularPeriod brother = iterator.next();
            if (!brother.getChildOrder().equals(this.getChildOrder()) || !iterator.hasNext()) continue;
            return iterator.next();
        }
        return null;
    }

    public CurricularPeriod contains(AcademicPeriod academicPeriod, Integer order) {
        if (this.getAcademicPeriod().equals((Object)academicPeriod) && this.getChildOrder().equals(order)) {
            return this;
        }
        for (CurricularPeriod curricularPeriod : this.getChildsSet()) {
            CurricularPeriod period = curricularPeriod.contains(academicPeriod, order);
            if (period == null) continue;
            return period;
        }
        return null;
    }

    public boolean hasCurricularPeriod(AcademicPeriod academicPeriod, Integer order) {
        if (this.getAcademicPeriod().equals((Object)academicPeriod) && this.getChildOrder().equals(order)) {
            return true;
        }
        if (this.getParent() != null) {
            return this.getParent().hasCurricularPeriod(academicPeriod, order);
        }
        return false;
    }

    @Deprecated
    public Integer getOrder() {
        return super.getChildOrder();
    }

    @Deprecated
    public void setOrder(Integer order) {
        super.setChildOrder(order);
    }

    public int getAbsoluteOrderOfChild() {
        if (this.getChildOrder() == null) {
            return 1;
        }
        CurricularPeriod parentCurricularPeriod = this.getParent();
        int absoluteOrderOfParent = parentCurricularPeriod.getAbsoluteOrderOfChild();
        int numberOfBrothersAndSisters = parentCurricularPeriod.getChildsSet().size();
        return (absoluteOrderOfParent - 1) * numberOfBrothersAndSisters + this.getChildOrder();
    }

    public List<Context> getContextsWithCurricularCourses() {
        return this.getContextsWithCurricularCourses(null);
    }

    public List<Context> getContextsWithCurricularCourses(ExecutionSemester executionSemester) {
        return this.getChildContexts(CurricularCourse.class, executionSemester);
    }

    public List<Context> getChildContexts(Class<? extends DegreeModule> clazz, ExecutionSemester executionSemester) {
        ArrayList<Context> result = new ArrayList<Context>();
        for (Context context : super.getContextsSet()) {
            if (clazz != null && !clazz.isAssignableFrom(((Object)((Object)context.getChildDegreeModule())).getClass()) || executionSemester != null && !context.isValid(executionSemester)) continue;
            result.add(context);
        }
        return result;
    }

    public boolean hasChildOrder() {
        return this.getChildOrder() != null;
    }

    public boolean hasChildOrderValue(Integer order) {
        return this.hasChildOrder() && this.getChildOrder().equals(order);
    }

    static {
        CurricularPeriod.getRelationCurricularPeriodParentChilds().addListener((RelationListener)new CurricularPeriodParentChildsListener());
    }

    private static class CurricularPeriodParentChildsListener
    extends RelationAdapter<CurricularPeriod, CurricularPeriod> {
        private CurricularPeriodParentChildsListener() {
        }

        public void beforeAdd(CurricularPeriod parent, CurricularPeriod child) {
            if (parent == null) {
                return;
            }
            if (child.getAcademicPeriod().getWeight() >= parent.getAcademicPeriod().getWeight()) {
                throw new DomainException("error.childTypeGreaterThanParentType", new String[0]);
            }
            float childsWeight = child.getAcademicPeriod().getWeight();
            for (CurricularPeriod period : parent.getChildsSet()) {
                childsWeight += period.getAcademicPeriod().getWeight();
            }
            if (childsWeight > parent.getAcademicPeriod().getWeight()) {
                throw new DomainException("error.childWeightOutOfLimit", new String[0]);
            }
            Integer order = child.getChildOrder();
            if (order == null) {
                child.setChildOrder(parent.getChildsSet().size() + 1);
            } else if (parent.getChildByOrder(order) != null) {
                throw new DomainException("error.childAlreadyExists", new String[0]);
            }
        }
    }
}

