/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accessControl.FenixGroup;
import org.fenixedu.academic.domain.accessControl.PersistentUnitGroup;
import org.fenixedu.academic.domain.organizationalStructure.Accountability;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.bennu.core.annotation.GroupArgument;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.YearMonthDay;

@GroupOperator(value="unit")
public class UnitGroup
extends FenixGroup {
    private static final long serialVersionUID = 3393643895062911436L;
    @GroupArgument
    private Unit unit;
    @GroupArgument
    private AccountabilityTypeEnum relationType;
    @GroupArgument
    private Boolean includeSubUnits;

    private UnitGroup() {
    }

    private UnitGroup(Unit unit, AccountabilityTypeEnum relationType, Boolean includeSubUnits) {
        this();
        this.unit = unit;
        this.relationType = relationType;
        this.includeSubUnits = includeSubUnits;
    }

    public static UnitGroup recursiveWorkers(Unit unit) {
        return new UnitGroup(unit, AccountabilityTypeEnum.WORKING_CONTRACT, true);
    }

    public static UnitGroup workers(Unit unit) {
        return new UnitGroup(unit, AccountabilityTypeEnum.WORKING_CONTRACT, false);
    }

    public static UnitGroup get(Unit unit, AccountabilityTypeEnum relationType, Boolean includeSubUnits) {
        return new UnitGroup(unit, relationType, includeSubUnits);
    }

    public Unit getUnit() {
        return this.unit;
    }

    @Override
    public String[] getPresentationNameKeyArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.unit.getNameI18n().getContent());
        String type = "";
        if (this.relationType != null) {
            type = BundleUtil.getString((String)"resources.GroupNameResources", (String)"label.name.unit.connector.relation", (String[])new String[0]) + this.relationType.getLocalizedName();
        }
        args.add(type);
        String subunits = "";
        if (this.includeSubUnits.booleanValue()) {
            subunits = BundleUtil.getString((String)"resources.GroupNameResources", (String)"label.name.unit.subunits", (String[])new String[0]);
        }
        args.add(subunits);
        return args.toArray(new String[3]);
    }

    public Set<User> getMembers() {
        return this.getMembers(new DateTime());
    }

    public Set<User> getMembers(DateTime when) {
        HashSet<User> users = new HashSet<User>();
        this.collect(users, this.unit, when);
        return users;
    }

    private void collect(Set<User> users, Unit unit, DateTime when) {
        Collection accs = this.relationType != null ? unit.getChildAccountabilities(this.relationType) : unit.getChildsSet();
        for (Accountability accountability : accs) {
            User user;
            Party party;
            if (!accountability.isActive(when.toYearMonthDay()) || !((party = accountability.getChildParty()) instanceof Person) || (user = ((Person)((Object)party)).getUser()) == null) continue;
            users.add(user);
        }
        if (this.includeSubUnits.booleanValue()) {
            for (Unit subUnit : unit.getSubUnits()) {
                this.collect(users, subUnit, when);
            }
        }
    }

    public boolean isMember(User user) {
        return this.isMember(user, new DateTime());
    }

    public boolean isMember(User user, DateTime when) {
        if (user == null) {
            return false;
        }
        YearMonthDay whenYMD = when.toYearMonthDay();
        for (Accountability accountability : user.getPerson().getParentsSet()) {
            if (accountability.getAccountabilityType().getType() != this.relationType || !accountability.isActive(whenYMD)) continue;
            if (accountability.getParentParty().equals((Object)this.unit)) {
                return true;
            }
            if (!this.includeSubUnits.booleanValue() || !this.isAncestor((Party)((Object)this.unit), accountability.getParentParty(), this.relationType, whenYMD)) continue;
            return true;
        }
        return false;
    }

    private boolean isAncestor(Party possibleAncestor, Party possibleChild, AccountabilityTypeEnum subUnitRecursionType, YearMonthDay when) {
        if (possibleChild == null) {
            return false;
        }
        if (possibleChild.equals(possibleAncestor)) {
            return true;
        }
        for (Accountability acc : possibleChild.getParentsSet()) {
            if (!(acc.getParentParty() instanceof Unit) || !acc.isActive(when) || !this.isAncestor(possibleAncestor, acc.getParentParty(), subUnitRecursionType, when)) continue;
            return true;
        }
        return false;
    }

    public PersistentGroup toPersistentGroup() {
        return PersistentUnitGroup.getInstance(this.unit, this.relationType, this.includeSubUnits);
    }

    public boolean equals(Object object) {
        if (object instanceof UnitGroup) {
            UnitGroup other = (UnitGroup)((Object)object);
            return Objects.equal((Object)((Object)this.unit), (Object)((Object)other.unit)) && Objects.equal((Object)((Object)this.relationType), (Object)((Object)other.relationType)) && Objects.equal((Object)this.includeSubUnits, (Object)other.includeSubUnits);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.unit, this.relationType, this.includeSubUnits});
    }
}

