/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class FenixStringTools {
    private static String rightPad(String field, int LINE_LENGTH, char fillPaddingWith) {
        if (!StringUtils.isEmpty((String)field) && !field.endsWith(" ")) {
            field = field + " ";
        }
        return StringUtils.rightPad((String)field, (int)LINE_LENGTH, (char)fillPaddingWith);
    }

    public static String multipleLineRightPad(String field, int LINE_LENGTH, char fillPaddingWith) {
        if (!StringUtils.isEmpty((String)field) && !field.endsWith(" ")) {
            field = field + " ";
        }
        if (field.length() < LINE_LENGTH) {
            return StringUtils.rightPad((String)field, (int)LINE_LENGTH, (char)fillPaddingWith);
        }
        List<String> words = Arrays.asList(field.split(" "));
        int currentLineLength = 0;
        String result = "";
        for (String word : words) {
            String toAdd = word + " ";
            if (currentLineLength + toAdd.length() > LINE_LENGTH) {
                result = StringUtils.rightPad((String)result, (int)LINE_LENGTH, (char)fillPaddingWith) + '\n';
                currentLineLength = toAdd.length();
            } else {
                currentLineLength += toAdd.length();
            }
            result = result + toAdd;
        }
        if (currentLineLength < LINE_LENGTH) {
            return StringUtils.rightPad((String)result, (int)(result.length() + (LINE_LENGTH - currentLineLength)), (char)fillPaddingWith);
        }
        return result;
    }

    public static String multipleLineRightPadWithSuffix(String field, int LINE_LENGTH, char fillPaddingWith, String suffix) {
        if (!StringUtils.isEmpty((String)field) && !field.endsWith(" ")) {
            field = field + " ";
        }
        if (StringUtils.isEmpty((String)suffix)) {
            return FenixStringTools.multipleLineRightPad(field, LINE_LENGTH, fillPaddingWith);
        }
        if (!suffix.startsWith(" ")) {
            suffix = " " + suffix;
        }
        int LINE_LENGTH_WITH_SUFFIX = LINE_LENGTH - suffix.length();
        if (field.length() < LINE_LENGTH_WITH_SUFFIX) {
            return FenixStringTools.rightPad(field, LINE_LENGTH_WITH_SUFFIX, fillPaddingWith) + suffix;
        }
        List<String> words = Arrays.asList(field.split(" "));
        int currentLineLength = 0;
        String result = "";
        for (String word : words) {
            String toAdd = word + " ";
            if (currentLineLength + toAdd.length() > LINE_LENGTH) {
                result = StringUtils.rightPad((String)result, (int)LINE_LENGTH, (char)' ') + '\n';
                currentLineLength = toAdd.length();
            } else {
                currentLineLength += toAdd.length();
            }
            result = result + toAdd;
        }
        if (currentLineLength < LINE_LENGTH_WITH_SUFFIX) {
            return FenixStringTools.rightPad(result, result.length() + (LINE_LENGTH_WITH_SUFFIX - currentLineLength), fillPaddingWith) + suffix;
        }
        return FenixStringTools.rightPad(result, result.length() + (LINE_LENGTH - currentLineLength), fillPaddingWith) + "\n" + StringUtils.leftPad((String)suffix, (int)LINE_LENGTH, (char)fillPaddingWith);
    }
}

