/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.serviceRequests.documentRequests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jvstm.cps.ConsistencyException;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.Exam;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.documents.GeneratedDocument;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.serviceRequest.documentRequest.certificates.ExamDateCertificateExamSelectionBean;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestCreateBean;
import org.fenixedu.academic.service.factoryExecutors.DocumentRequestCreator;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.serviceRequests.AcademicServiceRequestsManagementDispatchAction;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@Mapping(path="/documentRequestsManagement", module="academicAdministration", formBeanClass=AcademicServiceRequestsManagementDispatchAction.AcademicServiceRequestsManagementForm.class, functionality=AcademicServiceRequestsManagementDispatchAction.class)
@Forwards(value={@Forward(name="printDocument", path="/academicAdminOffice/serviceRequests/documentRequests/printDocument.jsp"), @Forward(name="createDocumentRequests", path="/academicAdminOffice/serviceRequests/documentRequests/createDocumentRequests.jsp"), @Forward(name="viewDocumentRequestsToCreate", path="/academicAdminOffice/serviceRequests/documentRequests/viewDocumentRequestsToCreate.jsp"), @Forward(name="chooseExamsToCreateExamDateCertificateRequest", path="/academicAdminOffice/serviceRequests/documentRequests/chooseExamsToCreateExamDateCertificateRequest.jsp"), @Forward(name="viewRegistrationDetails", path="/academicAdminOffice/student/registration/viewRegistrationDetails.jsp"), @Forward(name="processNewAcademicServiceRequest", path="/academicAdministration/academicServiceRequestsManagement.do?method=processNewAcademicServiceRequest")})
public class DocumentRequestsManagementDispatchAction
extends FenixDispatchAction {
    protected IDocumentRequest getDocumentRequest(HttpServletRequest request) {
        return (IDocumentRequest)this.getDomainObject(request, "documentRequestId");
    }

    private AcademicServiceRequest getAndSetAcademicServiceRequest(HttpServletRequest request) {
        AcademicServiceRequest academicServiceRequest = (AcademicServiceRequest)this.getDomainObject(request, "academicServiceRequestId");
        request.setAttribute("academicServiceRequest", (Object)academicServiceRequest);
        return academicServiceRequest;
    }

    public ActionForward downloadDocument(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException, FenixServiceException {
        AcademicServiceRequest academicServiceRequest = (AcademicServiceRequest)((Object)this.getDocumentRequest(request));
        if (academicServiceRequest.isConcluded() || academicServiceRequest.isDelivered()) {
            return this.printLastGeneratedDocument(mapping, actionForm, request, response);
        }
        return this.printDocument(mapping, actionForm, request, response);
    }

    public ActionForward printLastGeneratedDocument(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException, FenixServiceException {
        GeneratedDocument doc = this.getDocumentRequest(request).getLastGeneratedDocument();
        if (doc != null) {
            this.writeFile(response, doc.getFilename(), "application/pdf", doc.getContent());
        }
        return null;
    }

    public ActionForward printDocument(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException, FenixServiceException {
        IDocumentRequest documentRequest = this.getDocumentRequest(request);
        byte[] content = documentRequest.generateDocument();
        String fileName = documentRequest.getReportFileName() + ".pdf";
        this.writeFile(response, fileName, "application/pdf", content);
        return null;
    }

    public ActionForward prepareConcludeDocumentRequest(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        if (request.getAttribute("academicServiceRequest") == null) {
            request.setAttribute("academicServiceRequest", (Object)this.getAndSetAcademicServiceRequest(request));
        }
        return mapping.findForward("printDocument");
    }

    private Registration getRegistration(HttpServletRequest request) {
        Registration registration = (Registration)((Object)this.getDomainObject(request, "registrationId"));
        request.setAttribute("registration", (Object)registration);
        return registration;
    }

    public ActionForward prepareCreateDocumentRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String schema = "DocumentRequestCreateBean.chooseDocumentRequestType";
        if (!this.getRegistration(request).isBolonha()) {
            schema = schema + "_preBolonha";
        }
        return this.prepareCreateDocumentRequest(mapping, form, request, response, schema);
    }

    public ActionForward prepareCreateDocumentRequestQuick(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.prepareCreateDocumentRequest(mapping, form, request, response, "DocumentRequestCreateBean.chooseDocumentRequestQuickType");
    }

    private ActionForward prepareCreateDocumentRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String schema) {
        DocumentRequestCreator creator = new DocumentRequestCreator(this.getRegistration(request));
        creator.setSchema(schema);
        request.setAttribute("documentRequestCreateBean", (Object)creator);
        return mapping.findForward("createDocumentRequests");
    }

    public ActionForward documentRequestTypeInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DocumentRequestCreateBean requestCreateBean = (DocumentRequestCreateBean)this.getRenderedObject();
        if (requestCreateBean.getChosenServiceRequestType() != null) {
            this.getAndSetSpecialEnrolments(request, requestCreateBean);
        }
        this.setAdditionalInformationSchemaName(request, requestCreateBean);
        request.setAttribute("documentRequestCreateBean", (Object)requestCreateBean);
        return mapping.findForward("createDocumentRequests");
    }

    public ActionForward documentRequestTypeChosenPostBack(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.createDocumentRequestPostback(mapping, request);
    }

    private ActionForward createDocumentRequestPostback(ActionMapping mapping, HttpServletRequest request) {
        DocumentRequestCreateBean requestCreateBean = (DocumentRequestCreateBean)RenderUtils.getViewState().getMetaObject().getObject();
        RenderUtils.invalidateViewState();
        if (requestCreateBean.getChosenServiceRequestType() != null) {
            this.getAndSetSpecialEnrolments(request, requestCreateBean);
        }
        this.setAdditionalInformationSchemaName(request, requestCreateBean);
        request.setAttribute("documentRequestCreateBean", (Object)requestCreateBean);
        return mapping.findForward("createDocumentRequests");
    }

    private void getAndSetSpecialEnrolments(HttpServletRequest request, DocumentRequestCreateBean requestCreateBean) {
        List<Enrolment> enrolments;
        StudentCurricularPlan curricularPlan = requestCreateBean.getRegistration().getLastStudentCurricularPlan();
        DocumentRequestType requestType = requestCreateBean.getChosenServiceRequestType().getDocumentRequestType();
        if (requestType != null && requestType.equals((Object)DocumentRequestType.EXTRA_CURRICULAR_CERTIFICATE)) {
            enrolments = curricularPlan.getExtraCurricularApprovedEnrolmentsNotInDismissal();
            if (enrolments.size() == 0) {
                this.addActionMessage("warning", request, "warning.ExtraCurricularCertificateRequest.no.enrolments.available");
            }
            requestCreateBean.setEnrolments(enrolments);
        }
        if (requestType != null && requestType.equals((Object)DocumentRequestType.STANDALONE_ENROLMENT_CERTIFICATE)) {
            enrolments = curricularPlan.getStandaloneApprovedEnrolmentsNotInDismissal();
            if (enrolments.size() == 0) {
                this.addActionMessage("warning", request, "warning.StandaloneEnrolmentCertificateRequest.no.enrolments.available");
            }
            requestCreateBean.setEnrolments(enrolments);
        }
    }

    private void setAdditionalInformationSchemaName(HttpServletRequest request, DocumentRequestCreateBean requestCreateBean) {
        if (!requestCreateBean.getHasAdditionalInformation()) {
            return;
        }
        ServiceRequestType serviceRequestType = requestCreateBean.getChosenServiceRequestType();
        StringBuilder schemaName = new StringBuilder();
        schemaName.append("DocumentRequestCreateBean.");
        schemaName.append(serviceRequestType.getCode());
        DocumentRequestType requestType = serviceRequestType.getDocumentRequestType();
        if (requestType != null) {
            if (requestType.equals((Object)DocumentRequestType.APPROVEMENT_MOBILITY_CERTIFICATE) && !requestCreateBean.getRegistrationProtocol().isEnrolmentByStudentAllowed()) {
                schemaName.append("_mobility");
            }
            if (!requestCreateBean.getRegistration().isBolonha() && requestType.withBranch()) {
                schemaName.append("_WithBranch");
            }
        }
        schemaName.append(".AdditionalInformation");
        request.setAttribute("additionalInformationSchemaName", (Object)schemaName.toString());
    }

    public ActionForward executionYearToCreateDocumentChangedPostBack(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.createDocumentRequestPostback(mapping, request);
    }

    public ActionForward executionPeriodToCreateDocumentChangedPostBack(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.createDocumentRequestPostback(mapping, request);
    }

    public ActionForward viewDocumentRequestToCreate(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        DocumentRequestCreateBean requestCreateBean = (DocumentRequestCreateBean)RenderUtils.getViewState().getMetaObject().getObject();
        DocumentRequestType documentRequestType = requestCreateBean.getChosenServiceRequestType().getDocumentRequestType();
        if (documentRequestType == DocumentRequestType.EXAM_DATE_CERTIFICATE) {
            return this.prepareChooseExamsToCreateExamDateCertificateRequest(mapping, actionForm, request, response, requestCreateBean);
        }
        this.setAdditionalInformationSchemaName(request, requestCreateBean);
        request.setAttribute("documentRequestCreateBean", (Object)requestCreateBean);
        return mapping.findForward("viewDocumentRequestsToCreate");
    }

    public ActionForward prepareChooseExamsToCreateExamDateCertificateRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, DocumentRequestCreateBean requestCreateBean) {
        request.setAttribute("documentRequestCreateBean", (Object)requestCreateBean);
        ExamDateCertificateExamSelectionBean examSelectionBean = ExamDateCertificateExamSelectionBean.buildFor(requestCreateBean.getEnrolments(), requestCreateBean.getExecutionPeriod());
        request.setAttribute("examSelectionBean", (Object)examSelectionBean);
        request.setAttribute("enrolmentsWithoutExam", examSelectionBean.getEnrolmentsWithoutExam(requestCreateBean.getEnrolments()));
        return mapping.findForward("chooseExamsToCreateExamDateCertificateRequest");
    }

    public ActionForward chooseExamsToCreateExamDateCertificateRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DocumentRequestCreateBean requestCreateBean = (DocumentRequestCreateBean)this.getRenderedObject("documentRequestCreateBean");
        requestCreateBean.setExams(this.getSelectedExams(request));
        this.setAdditionalInformationSchemaName(request, requestCreateBean);
        request.setAttribute("documentRequestCreateBean", (Object)requestCreateBean);
        return mapping.findForward("viewDocumentRequestsToCreate");
    }

    private List<Exam> getSelectedExams(HttpServletRequest request) {
        String[] examIds = request.getParameterValues("selectedExams");
        if (examIds == null) {
            return Collections.emptyList();
        }
        ArrayList<Exam> result = new ArrayList<Exam>();
        for (String examId : examIds) {
            result.add((Exam)FenixFramework.getDomainObject((String)examId));
        }
        return result;
    }

    public ActionForward create(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        DocumentRequestCreateBean documentRequestCreateBean = (DocumentRequestCreateBean)this.getRenderedObject();
        Registration registration = documentRequestCreateBean.getRegistration();
        request.setAttribute("registration", (Object)registration);
        AcademicServiceRequest documentRequest = null;
        try {
            documentRequest = (AcademicServiceRequest)this.executeFactoryMethod();
        }
        catch (DomainException ex) {
            this.addActionMessage(request, ex.getKey(), ex.getArgs());
            return mapping.findForward("viewRegistrationDetails");
        }
        catch (ConsistencyException ce) {
            this.addActionMessage(request, "error." + ce.getMethodFullname());
            return mapping.findForward("viewRegistrationDetails");
        }
        this.addActionMessage(request, "document.request.created.with.success");
        return mapping.findForward("viewRegistrationDetails");
    }

    public ActionForward useAllPostBack(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        DocumentRequestCreateBean documentRequestCreateBean = (DocumentRequestCreateBean)this.getRenderedObject();
        if (documentRequestCreateBean.isToUseAll()) {
            Set degrees = AcademicAccessRule.getDegreesAccessibleToFunction(AcademicOperationType.SERVICE_REQUESTS, Authenticate.getUser()).collect(Collectors.toSet());
            HashSet<Enrolment> aprovedEnrolments = new HashSet<Enrolment>();
            for (Degree degree : degrees) {
                for (Registration registration : documentRequestCreateBean.getStudent().getRegistrationsFor(degree)) {
                    aprovedEnrolments.addAll(registration.getApprovedEnrolments());
                }
            }
            documentRequestCreateBean.setEnrolments(new ArrayList<Enrolment>(aprovedEnrolments));
        } else {
            documentRequestCreateBean.setEnrolments(new ArrayList<Enrolment>());
        }
        RenderUtils.invalidateViewState();
        request.setAttribute("documentRequestCreateBean", (Object)documentRequestCreateBean);
        this.setAdditionalInformationSchemaName(request, documentRequestCreateBean);
        return mapping.findForward("createDocumentRequests");
    }
}

