/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.validators;

import java.text.ParseException;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.util.DateFormatUtil;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixWebFramework.renderers.validators.DateValidator;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;

public class DateInExecutionPeriodValidator
extends DateValidator {
    private static final Logger logger = LoggerFactory.getLogger(DateInExecutionPeriodValidator.class);

    public DateInExecutionPeriodValidator() {
    }

    public DateInExecutionPeriodValidator(HtmlChainValidator htmlChainValidator) {
        super(htmlChainValidator);
    }

    public DateInExecutionPeriodValidator(HtmlChainValidator htmlChainValidator, String dateFormat) {
        super(htmlChainValidator, dateFormat);
    }

    public void performValidation() {
        super.performValidation();
        if (this.isValid()) {
            try {
                DateTime dateTime = new DateTime(DateFormatUtil.parse(this.getDateFormat(), this.getComponent().getValue()).getTime());
                this.setValid(ExecutionSemester.readByDateTime(dateTime) != null);
                if (!this.isValid()) {
                    this.setMessage("renderers.validator.dateInExecutionPeriod.notInExecutionPeriod");
                }
            }
            catch (ParseException e) {
                this.setValid(false);
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

