/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.commons;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.dto.academicAdministration.DegreeByExecutionYearBean;
import org.fenixedu.academic.dto.commons.CurricularCourseByExecutionSemesterBean;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.BiDirectionalConverter;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixframework.FenixFramework;

public class SearchCurricularCourseByDegree
implements Serializable {
    private ExecutionSemester executionSemester;
    private DegreeByExecutionYearBean degreeBean;
    private DegreeCurricularPlan degreeCurricularPlan;
    private CurricularCourseByExecutionSemesterBean curricularCourseBean;

    public SearchCurricularCourseByDegree(ExecutionSemester executionSemester) {
        this.setExecutionSemester(executionSemester);
    }

    public ExecutionSemester getExecutionSemester() {
        return this.executionSemester;
    }

    public void setExecutionSemester(ExecutionSemester executionSemester) {
        this.executionSemester = executionSemester;
    }

    public DegreeByExecutionYearBean getDegreeBean() {
        return this.degreeBean;
    }

    public void setDegreeBean(DegreeByExecutionYearBean degreeBean) {
        this.degreeBean = degreeBean;
        this.setDegreeCurricularPlan(null);
        this.setCurricularCourseBean(null);
    }

    public boolean hasDegreeBean() {
        return this.getDegreeBean() != null;
    }

    public DegreeCurricularPlan getDegreeCurricularPlan() {
        return this.degreeCurricularPlan;
    }

    public void setDegreeCurricularPlan(DegreeCurricularPlan degreeCurricularPlan) {
        this.degreeCurricularPlan = this.hasDegreeBean() && this.getDegreeBean().getDegree().getDegreeCurricularPlansSet().contains((Object)degreeCurricularPlan) ? degreeCurricularPlan : null;
        this.setCurricularCourseBean(null);
    }

    public void removeDegreeCurricularPlan() {
        this.degreeCurricularPlan = null;
    }

    public boolean hasDegreeCurricularPlan() {
        return this.getDegreeCurricularPlan() != null;
    }

    public CurricularCourseByExecutionSemesterBean getCurricularCourseBean() {
        return this.curricularCourseBean;
    }

    public void setCurricularCourseBean(CurricularCourseByExecutionSemesterBean curricularCourseBean) {
        this.curricularCourseBean = curricularCourseBean;
    }

    public void removeCurricularCourseBean() {
        this.curricularCourseBean = null;
    }

    public boolean hasCurricularCourseBean() {
        return this.curricularCourseBean != null;
    }

    public static class SearchCurricularCourseCurricularCoursesProvider
    implements DataProvider {
        public Object provide(Object source, Object currentValue) {
            SearchCurricularCourseByDegree bean = (SearchCurricularCourseByDegree)source;
            if (bean.hasDegreeBean() && bean.hasDegreeCurricularPlan()) {
                return this.getSortedCurricularCourses(bean);
            }
            return Collections.emptyList();
        }

        private List<CurricularCourseByExecutionSemesterBean> getSortedCurricularCourses(SearchCurricularCourseByDegree bean) {
            DegreeCurricularPlan dcp = bean.getDegreeCurricularPlan();
            ArrayList<CurricularCourseByExecutionSemesterBean> result = new ArrayList<CurricularCourseByExecutionSemesterBean>();
            for (DegreeModule degreeModule : dcp.getDcpDegreeModules(CurricularCourse.class, bean.getExecutionSemester())) {
                result.add(new CurricularCourseByExecutionSemesterBean((CurricularCourse)((Object)degreeModule), bean.getExecutionSemester()));
            }
            Collections.sort(result);
            return result;
        }

        public Converter getConverter() {
            return new BiDirectionalConverter(){

                public Object convert(Class type, Object value) {
                    return CurricularCourseByExecutionSemesterBean.buildFrom((String)value);
                }

                public String deserialize(Object object) {
                    return object == null ? "" : ((CurricularCourseByExecutionSemesterBean)object).getKey();
                }
            };
        }
    }

    public static class SearchCurricularCourseDegreeCurricularPlansProvider
    implements DataProvider {
        public Object provide(Object source, Object currentValue) {
            SearchCurricularCourseByDegree bean = (SearchCurricularCourseByDegree)source;
            if (bean.hasDegreeBean()) {
                List<DegreeCurricularPlan> result = this.getDegreeCurricularPlans(bean);
                Collections.sort(result, DegreeCurricularPlan.COMPARATOR_BY_NAME);
                return result;
            }
            return Collections.emptyList();
        }

        private List<DegreeCurricularPlan> getDegreeCurricularPlans(SearchCurricularCourseByDegree bean) {
            return new ArrayList<DegreeCurricularPlan>(bean.getDegreeBean().getDegreeCurricularPlans());
        }

        public Converter getConverter() {
            return new DomainObjectKeyConverter();
        }
    }

    public static class SearchCurricularCourseBolonhaDegreesProvider
    implements DataProvider {
        public Object provide(Object source, Object currentValue) {
            Set programs = AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.MANAGE_INDIVIDUAL_CANDIDACIES, Authenticate.getUser()).collect(Collectors.toSet());
            SearchCurricularCourseByDegree bean = (SearchCurricularCourseByDegree)source;
            ArrayList<DegreeByExecutionYearBean> result = new ArrayList<DegreeByExecutionYearBean>();
            for (Degree degree : Degree.readBolonhaDegrees()) {
                if (!programs.contains(degree)) continue;
                result.add(new DegreeByExecutionYearBean(degree, bean.getExecutionSemester().getExecutionYear()));
            }
            Collections.sort(result);
            return result;
        }

        public Converter getConverter() {
            return new BiDirectionalConverter(){

                public Object convert(Class type, Object value) {
                    String key = (String)value;
                    if (key == null || key.isEmpty()) {
                        return null;
                    }
                    String[] values = key.split(":");
                    Degree degree = (Degree)FenixFramework.getDomainObject((String)values[0]);
                    ExecutionYear year = (ExecutionYear)FenixFramework.getDomainObject((String)values[1]);
                    return new DegreeByExecutionYearBean(degree, year);
                }

                public String deserialize(Object object) {
                    return object == null ? "" : ((DegreeByExecutionYearBean)object).getKey();
                }
            };
        }
    }
}

