/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import org.fenixedu.academic.domain.space.SpaceUtils;
import org.fenixedu.academic.dto.InfoObject;
import org.fenixedu.spaces.domain.Space;
import org.fenixedu.spaces.domain.SpaceClassification;

public class InfoRoom
extends InfoObject
implements Comparable {
    private final Space room;

    public InfoRoom(Space room) {
        this.room = room;
    }

    public String getNome() {
        return this.getRoom().getName();
    }

    public Space getSpaceBuilding() {
        Space building = SpaceUtils.getSpaceBuilding(this.getRoom());
        return building != null ? building : null;
    }

    public String getEdificio() {
        Space building = this.getSpaceBuilding();
        return building != null ? building.getName() : "";
    }

    public Integer getPiso() {
        Space spaceFloor = SpaceUtils.getSpaceFloor(this.getRoom());
        return spaceFloor != null ? (Integer)spaceFloor.getMetadata("level").orElse(null) : null;
    }

    public String getTipo() {
        return this.getRoom().getClassification().getName().getContent();
    }

    public SpaceClassification getClassification() {
        return this.getRoom().getClassification();
    }

    public Integer getCapacidadeNormal() {
        return this.getRoom().getAllocatableCapacity();
    }

    public Integer getCapacidadeExame() {
        return this.getRoom().getMetadata("examCapacity").orElse(0);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof InfoRoom && this.getRoom() == ((InfoRoom)obj).getRoom();
    }

    public String toString() {
        return this.getRoom().toString();
    }

    public int compareTo(Object obj) {
        return this.getNome().compareToIgnoreCase(((InfoRoom)obj).getNome());
    }

    public static InfoRoom newInfoFromDomain(Space room) {
        return room == null ? null : new InfoRoom(room);
    }

    @Override
    public String getExternalId() {
        return this.getRoom().getExternalId();
    }

    @Override
    public void setExternalId(String integer) {
        throw new Error("Method should not be called!");
    }

    public Space getRoom() {
        return this.room;
    }

    public String getName() {
        return this.getNome();
    }
}

