/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleNotPersistent;
import org.fenixedu.academic.domain.curricularRules.EnrolmentInSpecialSeasonEvaluation;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.MaximumNumberOfECTSInSpecialSeasonEvaluation;
import org.fenixedu.academic.domain.curricularRules.SeniorStatuteSpecialSeasonEnrolmentScope;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleLevel;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.EnrolmentResultType;
import org.fenixedu.academic.domain.enrolment.EnroledCurriculumModuleWrapper;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.SeniorStatute;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.StudentStatute;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.StudentCurricularPlanEnrolment;
import org.fenixedu.academic.domain.studentCurriculum.StudentCurricularPlanEnrolmentPreConditions;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class StudentCurricularPlanEnrolmentInSpecialSeasonEvaluationManager
extends StudentCurricularPlanEnrolment {
    public StudentCurricularPlanEnrolmentInSpecialSeasonEvaluationManager(EnrolmentContext enrolmentContext) {
        super(enrolmentContext);
    }

    @Override
    protected void assertEnrolmentPreConditions() {
        if (this.isResponsiblePersonManager()) {
            return;
        }
        if (!this.hasRegistrationInValidState()) {
            throw new DomainException("error.StudentCurricularPlan.cannot.enrol.with.registration.inactive", new String[0]);
        }
        super.assertEnrolmentPreConditions();
    }

    private boolean hasRegistrationInValidState() {
        return this.getRegistration().hasStateType(this.getExecutionYear(), RegistrationStateType.REGISTERED);
    }

    @Override
    protected void checkDebts() {
        boolean isAcademicalActsBlocked = TreasuryBridgeAPIFactory.implementation().isAcademicalActsBlocked(this.getPerson(), this.getExecutionYear().getEndLocalDate().isBefore((ReadablePartial)new LocalDate()) ? this.getExecutionYear().getEndLocalDate() : new LocalDate());
        if (isAcademicalActsBlocked) {
            throw new DomainException("error.StudentCurricularPlan.cannot.enrol.with.debts.for.previous.execution.years", new String[0]);
        }
    }

    @Override
    protected void assertAcademicAdminOfficePreConditions() {
        this.checkEnrolmentWithoutRules();
        if (this.updateRegistrationAfterConclusionProcessPermissionEvaluated()) {
            return;
        }
    }

    @Override
    protected void assertStudentEnrolmentPreConditions() {
        if (!this.getRegistrationsToEnrolByStudent(this.getResponsiblePerson().getStudent()).contains((Object)this.getRegistration())) {
            throw new DomainException("error.StudentCurricularPlan.student.is.not.allowed.to.perform.enrol", new String[0]);
        }
        if (this.getCurricularRuleLevel() != CurricularRuleLevel.SPECIAL_SEASON_ENROLMENT) {
            throw new DomainException("error.StudentCurricularPlan.invalid.curricular.rule.level", new String[0]);
        }
        StudentCurricularPlanEnrolmentPreConditions.EnrolmentPreConditionResult result = StudentCurricularPlanEnrolmentPreConditions.checkEnrolmentPeriodsForSpecialSeason(this.getStudentCurricularPlan(), this.getExecutionSemester());
        if (!result.isValid()) {
            throw new DomainException(result.message(), result.args());
        }
    }

    private Collection<Registration> getRegistrationsToEnrolByStudent(Student student) {
        HashSet<Registration> registrations = new HashSet<Registration>();
        for (Registration registration : student.getRegistrationsSet()) {
            if (!StudentCurricularPlanEnrolmentInSpecialSeasonEvaluationManager.isRegistrationEnrolmentByStudentAllowed(registration) || !registration.isActive() && !this.isRegistrationAvailableToEnrol(registration)) continue;
            registrations.add(registration);
        }
        return registrations;
    }

    private static boolean isRegistrationEnrolmentByStudentAllowed(Registration registration) {
        return registration.getRegistrationProtocol().isEnrolmentByStudentAllowed();
    }

    private boolean isRegistrationAvailableToEnrol(Registration registration) {
        return registration.hasAnyEnrolmentsIn(this.getExecutionYear()) && registration.getLastStudentCurricularPlan().hasExternalCycleCurriculumGroups();
    }

    @Override
    protected void unEnrol() {
        for (CurriculumModule curriculumModule : this.enrolmentContext.getToRemove()) {
            if (curriculumModule instanceof Enrolment) {
                Enrolment enrolment = (Enrolment)((Object)curriculumModule);
                enrolment.deleteTemporaryEvaluationForSpecialSeason(this.getEvaluationSeason());
                continue;
            }
            throw new DomainException("StudentCurricularPlanEnrolmentInSpecialSeasonEvaluationManager.can.only.manage.enrolment.evaluations.of.enrolments", new String[0]);
        }
    }

    @Override
    protected void addEnroled() {
    }

    @Override
    protected Map<IDegreeModuleToEvaluate, Set<ICurricularRule>> getRulesToEvaluate() {
        HashMap<IDegreeModuleToEvaluate, Set<ICurricularRule>> result = new HashMap<IDegreeModuleToEvaluate, Set<ICurricularRule>>();
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : this.enrolmentContext.getDegreeModulesToEvaluate()) {
            if (!degreeModuleToEvaluate.isEnroled() || !degreeModuleToEvaluate.canCollectRules()) continue;
            EnroledCurriculumModuleWrapper moduleEnroledWrapper = (EnroledCurriculumModuleWrapper)degreeModuleToEvaluate;
            if (moduleEnroledWrapper.getCurriculumModule() instanceof Enrolment) {
                Enrolment enrolment = (Enrolment)((Object)moduleEnroledWrapper.getCurriculumModule());
                HashSet<CurricularRuleNotPersistent> curricularRules = new HashSet<CurricularRuleNotPersistent>();
                if (!enrolment.hasSpecialSeason()) {
                    curricularRules.add(new EnrolmentInSpecialSeasonEvaluation(enrolment, this.getEvaluationSeason()));
                }
                curricularRules.add(new MaximumNumberOfECTSInSpecialSeasonEvaluation());
                if (this.isEnrolingAsSenior(enrolment)) {
                    curricularRules.add(new SeniorStatuteSpecialSeasonEnrolmentScope(enrolment, this.getRegistrationFromSeniorStatute(enrolment)));
                }
                result.put(degreeModuleToEvaluate, curricularRules);
                continue;
            }
            throw new DomainException("StudentCurricularPlanEnrolmentInSpecialSeasonEvaluationManager.can.only.manage.enrolment.evaluations.of.enrolments", new String[0]);
        }
        return result;
    }

    @Override
    protected void performEnrolments(Map<EnrolmentResultType, List<IDegreeModuleToEvaluate>> degreeModulesToEvaluate) {
        HashSet<Enrolment> toCreate = new HashSet<Enrolment>();
        for (Map.Entry<EnrolmentResultType, List<IDegreeModuleToEvaluate>> entry : degreeModulesToEvaluate.entrySet()) {
            for (IDegreeModuleToEvaluate degreeModuleToEvaluate : entry.getValue()) {
                if (!degreeModuleToEvaluate.isEnroled()) continue;
                EnroledCurriculumModuleWrapper moduleEnroledWrapper = (EnroledCurriculumModuleWrapper)degreeModuleToEvaluate;
                if (moduleEnroledWrapper.getCurriculumModule() instanceof Enrolment) {
                    Enrolment enrolment = (Enrolment)((Object)moduleEnroledWrapper.getCurriculumModule());
                    toCreate.add(enrolment);
                    continue;
                }
                throw new DomainException("StudentCurricularPlanEnrolmentInSpecialSeasonEvaluationManager.can.only.manage.enrolment.evaluations.of.enrolments", new String[0]);
            }
        }
        if (!toCreate.isEmpty()) {
            this.getStudentCurricularPlan().createEnrolmentEvaluationForSpecialSeason(toCreate, this.getResponsiblePerson(), this.getEvaluationSeason());
        }
    }

    public EnrolmentContext getEnrolmentContext() {
        return this.enrolmentContext;
    }

    public EvaluationSeason getEvaluationSeason() {
        return this.getEnrolmentContext().getEvaluationSeason();
    }

    private boolean isEnrolingAsSenior(Enrolment enrolment) {
        if (this.isResponsiblePersonAllowedToEnrolStudents()) {
            return false;
        }
        ArrayList statutesReader = new ArrayList(enrolment.getStudent().getStudentStatutesSet());
        ArrayList<StudentStatute> validSeniorStatutes = new ArrayList<StudentStatute>();
        ArrayList<StudentStatute> validOtherStatutes = new ArrayList<StudentStatute>();
        for (StudentStatute statute : statutesReader) {
            if (statute instanceof SeniorStatute && statute.isValidInExecutionPeriod(this.getExecutionSemester())) {
                validSeniorStatutes.add(statute);
                continue;
            }
            if (!statute.getType().isSpecialSeasonGranted() || !statute.isValidInExecutionPeriod(this.getExecutionSemester())) continue;
            validOtherStatutes.add(statute);
        }
        if (validOtherStatutes.size() > 0) {
            return false;
        }
        if (validSeniorStatutes.size() == 1 && validOtherStatutes.size() == 0) {
            return true;
        }
        throw new DomainException("StudentCurricularPlanEnrolmentInSpecialSeasonEvaluationManager.inconsistent.student.statutes.states", new String[0]);
    }

    private Registration getRegistrationFromSeniorStatute(Enrolment enrolment) {
        ArrayList statutesReader = new ArrayList(enrolment.getStudent().getStudentStatutesSet());
        ArrayList<StudentStatute> statutesWriter = new ArrayList<StudentStatute>();
        for (StudentStatute statute : statutesReader) {
            if (!(statute instanceof SeniorStatute) || !statute.isValidInExecutionPeriod(this.getExecutionSemester())) continue;
            statutesWriter.add(statute);
        }
        if (statutesWriter.size() == 1) {
            SeniorStatute senior = (SeniorStatute)((Object)statutesWriter.iterator().next());
            return senior.getRegistration();
        }
        throw new DomainException("StudentCurricularPlanEnrolmentInSpecialSeasonEvaluationManager.student.has.more.than.one.senior.statute.for.same.period", new String[0]);
    }
}

