/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.serviceRequests;

import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgramProcessState;
import org.fenixedu.academic.domain.phd.exceptions.PhdDomainOperationException;
import org.fenixedu.academic.domain.phd.serviceRequests.PhdAcademicServiceRequest;
import org.fenixedu.academic.domain.phd.serviceRequests.PhdAcademicServiceRequestCreateBean;
import org.fenixedu.academic.domain.phd.serviceRequests.PhdStudentReingressionRequest_Base;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.AcademicServiceRequestType;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

public class PhdStudentReingressionRequest
extends PhdStudentReingressionRequest_Base {
    private PhdStudentReingressionRequest() {
    }

    private PhdStudentReingressionRequest(PhdAcademicServiceRequestCreateBean academicServiceRequestCreateBean) {
        this.init(academicServiceRequestCreateBean);
    }

    protected void init(PhdAcademicServiceRequestCreateBean bean) {
        if (!bean.getRequestType().equals((Object)this.getAcademicServiceRequestType())) {
            throw new DomainException("error.PhdStudentReingressionRequest.type.not.supported", new String[0]);
        }
        if (!PhdStudentReingressionRequest.isValidRequest(bean)) {
            throw new PhdDomainOperationException("error.PhdStudentReingressionRequest.phd.individual.program.process.must.be.flunked.or.suspended", new String[0]);
        }
        super.init(bean);
    }

    private static boolean isValidRequest(PhdAcademicServiceRequestCreateBean bean) {
        return bean.getPhdIndividualProgramProcess().isFlunked() || bean.getPhdIndividualProgramProcess().isSuspended();
    }

    public AcademicServiceRequestType getAcademicServiceRequestType() {
        return AcademicServiceRequestType.PHD_STUDENT_REINGRESSION;
    }

    public EventType getEventType() {
        return null;
    }

    public boolean hasPersonalInfo() {
        return false;
    }

    public boolean isPayedUponCreation() {
        return false;
    }

    public boolean isPossibleToSendToOtherEntity() {
        return false;
    }

    public boolean isManagedWithRectorateSubmissionBatch() {
        return false;
    }

    public boolean isToPrint() {
        return false;
    }

    public Boolean getFreeProcessed() {
        return true;
    }

    public static PhdAcademicServiceRequest createRequest(PhdAcademicServiceRequestCreateBean academicServiceRequestCreateBean) {
        return new PhdStudentReingressionRequest(academicServiceRequestCreateBean);
    }

    protected void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        super.internalChangeState(academicServiceRequestBean);
        if (academicServiceRequestBean.isToConclude()) {
            PhdIndividualProgramProcess process2 = this.getPhdIndividualProgramProcess();
            PhdProgramProcessState lastActiveState = process2.getLastActiveState();
            String remarks = String.format(BundleUtil.getString((String)"resources.PhdResources", (String)"message.org.fenixedu.academic.domain.phd.serviceRequests.PhdStudentReingressionRequest.conclusion.remark", (String[])new String[0]), this.getServiceRequestNumberYear());
            process2.createState(lastActiveState.getType(), AccessControl.getPerson(), remarks);
            if (process2.getRegistration() != null && !process2.getRegistration().isActive()) {
                RegistrationState registrationLastActiveState = process2.getRegistration().getLastActiveState();
                RegistrationState.createRegistrationState(process2.getRegistration(), AccessControl.getPerson(), new DateTime(), registrationLastActiveState.getStateType());
            }
        }
    }
}

