/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.email;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdParticipant;
import org.fenixedu.academic.domain.phd.alert.AlertService;
import org.fenixedu.academic.domain.phd.email.PhdEmailBean;
import org.fenixedu.academic.domain.phd.email.PhdIndividualProgramProcessEmail;
import org.fenixedu.academic.domain.phd.thesis.ThesisJuryElement;
import org.fenixedu.academic.util.MultiLanguageString;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class PhdIndividualProgramProcessEmailBean
extends PhdEmailBean
implements Serializable {
    private static final long serialVersionUID = -820152568474219538L;
    private PhdIndividualProgramProcess process;
    private PhdEmailTemplate template;
    private Set<PhdEmailParticipantsGroup> participantsGroup;
    private Set<PhdParticipant> selectedParticipants;
    public static final Comparator<PhdEmailParticipantsGroup> COMPARATOR_BY_NAME = new Comparator<PhdEmailParticipantsGroup>(){

        @Override
        public int compare(PhdEmailParticipantsGroup g1, PhdEmailParticipantsGroup g2) {
            return g1.getGroupLabel().compareTo(g2.getGroupLabel());
        }
    };

    public PhdIndividualProgramProcessEmailBean() {
    }

    public PhdIndividualProgramProcessEmailBean(PhdIndividualProgramProcessEmail email) {
        this.subject = email.getFormattedSubject().getContent(MultiLanguageString.pt);
        this.message = email.getFormattedBody().getContent(MultiLanguageString.pt);
        this.bccs = email.getBccs();
        this.creationDate = email.getWhenCreated();
        this.creator = email.getPerson();
        this.process = email.getPhdIndividualProgramProcess();
    }

    public String getBccsWithSelectedParticipants() {
        String bccs;
        String string = bccs = this.getBccs() == null ? null : this.getBccs().replace(" ", "");
        if (!StringUtils.isEmpty(bccs)) {
            bccs = bccs + ",";
        }
        for (PhdParticipant participant : this.getSelectedParticipants()) {
            bccs = bccs + participant.getEmail();
            bccs = bccs + ",";
        }
        if (bccs.endsWith(",")) {
            bccs = bccs.substring(0, bccs.length() - 1);
        }
        return bccs;
    }

    public PhdIndividualProgramProcess getProcess() {
        return this.process;
    }

    public void setProcess(PhdIndividualProgramProcess process2) {
        this.process = process2;
    }

    public PhdEmailTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(PhdEmailTemplate template) {
        this.template = template;
    }

    @Override
    public Person getCreator() {
        return this.creator;
    }

    @Override
    public void setCreator(Person creator) {
        this.creator = creator;
    }

    public Set<PhdEmailParticipantsGroup> getParticipantsGroup() {
        TreeSet<PhdEmailParticipantsGroup> result = new TreeSet<PhdEmailParticipantsGroup>(COMPARATOR_BY_NAME);
        if (this.participantsGroup != null) {
            for (PhdEmailParticipantsGroup participantGroup : this.participantsGroup) {
                result.add(participantGroup);
            }
        }
        return result;
    }

    public void setParticipantsGroup(List<PhdEmailParticipantsGroup> participantsGroup) {
        if (participantsGroup == null) {
            this.participantsGroup = null;
        } else {
            this.participantsGroup = new HashSet<PhdEmailParticipantsGroup>();
            for (PhdEmailParticipantsGroup participantGroup : participantsGroup) {
                this.participantsGroup.add(participantGroup);
            }
        }
    }

    public Set<PhdEmailParticipantsGroup> getPossibleParticipantsGroups() {
        TreeSet<PhdEmailParticipantsGroup> groups = new TreeSet<PhdEmailParticipantsGroup>(COMPARATOR_BY_NAME);
        groups.add(new PhdEmailParticipantsCoordinatorsGroup());
        if (!this.getProcess().getGuidingsSet().isEmpty()) {
            groups.add(new PhdEmailParticipantsGuidersGroup());
        }
        groups.add(new PhdEmailParticipantsAllGroup());
        if (this.getProcess().getThesisProcess() != null) {
            groups.add(new PhdEmailParticipantsJuryMembersGroup());
        }
        return groups;
    }

    public List<PhdEmailParticipantsGroup> getPossibleParticipantsGroupsList() {
        ArrayList<PhdEmailParticipantsGroup> groups = new ArrayList<PhdEmailParticipantsGroup>();
        groups.add(new PhdEmailParticipantsCoordinatorsGroup());
        groups.add(new PhdEmailParticipantsGuidersGroup());
        groups.add(new PhdEmailParticipantsAllGroup());
        if (this.getProcess().getThesisProcess() != null) {
            groups.add(new PhdEmailParticipantsJuryMembersGroup());
        }
        return groups;
    }

    public List<PhdParticipant> getSelectedParticipants() {
        ArrayList<PhdParticipant> result = new ArrayList<PhdParticipant>();
        if (this.selectedParticipants != null) {
            for (PhdParticipant participant : this.selectedParticipants) {
                result.add(participant);
            }
        }
        return result;
    }

    public void setSelectedParticipants(List<PhdParticipant> selectedParticipants) {
        if (selectedParticipants == null) {
            this.selectedParticipants = null;
        } else {
            this.selectedParticipants = new HashSet<PhdParticipant>();
            for (PhdParticipant participant : selectedParticipants) {
                this.selectedParticipants.add(participant);
            }
        }
    }

    public void refreshTemplateInUse() {
        if (this.getTemplate() != null) {
            this.setSubject(this.getTemplate().getTemplateSubject());
            this.setMessage(this.getTemplate().getTemplateBody());
        } else {
            this.setSubject("");
            this.setMessage("");
        }
    }

    public static class PhdEmailParticipantsJuryMembersGroup
    extends PhdEmailParticipantsGroup {
        private static final long serialVersionUID = 3417426578342610353L;

        public PhdEmailParticipantsJuryMembersGroup() {
            this.label = "label.phd.email.group.jury.members";
        }

        public List<PhdParticipant> getGroupParticipants(PhdIndividualProgramProcess process2) {
            ArrayList<PhdParticipant> participants = new ArrayList<PhdParticipant>();
            if (process2.getThesisProcess() == null) {
                throw new DomainException("phd.individualProcess.does.not.have.thesisProcess", new String[0]);
            }
            if (process2.getThesisProcess().getPresidentJuryElement() != null) {
                participants.add(process2.getThesisProcess().getPresidentJuryElement().getParticipant());
            }
            for (ThesisJuryElement element : process2.getThesisProcess().getThesisJuryElementsSet()) {
                participants.add(element.getParticipant());
            }
            return participants;
        }
    }

    public static class PhdEmailParticipantsAllGroup
    extends PhdEmailParticipantsGroup {
        private static final long serialVersionUID = -6806003598437992476L;

        public PhdEmailParticipantsAllGroup() {
            this.label = "label.phd.email.group.all.participants";
        }

        @Override
        public Collection<PhdParticipant> getGroupParticipants(PhdIndividualProgramProcess process2) {
            return process2.getParticipantsSet();
        }
    }

    public static class PhdEmailParticipantsGuidersGroup
    extends PhdEmailParticipantsGroup {
        private static final long serialVersionUID = -3022014810736464210L;

        public PhdEmailParticipantsGuidersGroup() {
            this.label = "label.phd.email.group.guiders";
        }

        public List<PhdParticipant> getGroupParticipants(PhdIndividualProgramProcess process2) {
            ArrayList<PhdParticipant> participants = new ArrayList<PhdParticipant>();
            participants.addAll(process2.getGuidingsAndAssistantGuidings());
            return participants;
        }
    }

    public static class PhdEmailParticipantsCoordinatorsGroup
    extends PhdEmailParticipantsGroup {
        private static final long serialVersionUID = 4961478244113914645L;

        public PhdEmailParticipantsCoordinatorsGroup() {
            this.label = "label.phd.email.group.coordinators";
        }

        public List<PhdParticipant> getGroupParticipants(PhdIndividualProgramProcess process2) {
            ArrayList<PhdParticipant> participants = new ArrayList<PhdParticipant>();
            for (Person person : process2.getCoordinatorsFor(ExecutionYear.readCurrentExecutionYear())) {
                participants.add(process2.getParticipant(person));
            }
            return participants;
        }
    }

    public static abstract class PhdEmailParticipantsGroup
    implements Serializable,
    DataProvider {
        private static final long serialVersionUID = -8990666659412753954L;
        protected String label;

        public String getGroupLabel() {
            return AlertService.AlertMessage.get(this.label, new Object[0]);
        }

        public String getName() {
            return this.getClass().getSimpleName();
        }

        public abstract Collection<PhdParticipant> getGroupParticipants(PhdIndividualProgramProcess var1);

        public String getEmailsAsBccs(PhdIndividualProgramProcess process2) {
            StringBuilder bccs = new StringBuilder();
            Boolean hasParticipantsEmails = false;
            for (PhdParticipant participant : this.getGroupParticipants(process2)) {
                String email = participant.getEmail();
                if (email == null) continue;
                hasParticipantsEmails = true;
                bccs.append(email);
                bccs.append(",");
            }
            if (hasParticipantsEmails.booleanValue()) {
                bccs.deleteCharAt(bccs.length() - 1);
            }
            return bccs.toString();
        }

        public Converter getConverter() {
            return null;
        }

        public Object provide(Object source, Object currentValue) {
            PhdIndividualProgramProcessEmailBean emailBean = (PhdIndividualProgramProcessEmailBean)source;
            return this.getGroupParticipants(emailBean.getProcess());
        }
    }

    public static enum PhdEmailTemplate {
        FINAL_THESIS_DELIVERY("message.phd.template.final.thesis.delivery"),
        FINAL_THESIS_DELIVERY_WITH_CHANGES("message.phd.template.final.thesis.delivery.changes"),
        FINAL_THESIS_DELIVERY_AFTER_DISCUSSION("message.phd.template.final.thesis.delivery.after.discussion");

        private String label;

        private PhdEmailTemplate(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public String getLabelForSubject() {
            return this.label + ".subject";
        }

        public String getLabelForBody() {
            return this.label + ".body";
        }

        public String getTemplateSubject() {
            return AlertService.AlertMessage.get(this.getLabelForSubject(), new Object[0]);
        }

        public String getTemplateBody() {
            return AlertService.AlertMessage.get(this.getLabelForBody(), new Object[0]);
        }

        public String toString() {
            return AlertService.AlertMessage.get(this.getLabel() + ".label", new Object[0]);
        }
    }
}

