/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.organizationalStructure;

import org.fenixedu.academic.FenixEduAcademicConfiguration;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.organizationalStructure.PartySocialSecurityNumber_Base;
import org.fenixedu.bennu.core.domain.Bennu;

public class PartySocialSecurityNumber
extends PartySocialSecurityNumber_Base {
    private PartySocialSecurityNumber() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public PartySocialSecurityNumber(Party party, String socialSecurityNumber) {
        this();
        this.checkParameters(party, socialSecurityNumber);
        super.setParty(party);
        super.setSocialSecurityNumber(socialSecurityNumber);
    }

    private void checkParameters(Party party, String socialSecurityNumber) {
        if (party == null) {
            throw new DomainException("error.PartySocialSecurityNumber.invalid.party", new String[0]);
        }
        if (socialSecurityNumber == null || socialSecurityNumber.length() == 0) {
            throw new DomainException("error.PartySocialSecurityNumber.invalid.socialSecurityNumber", new String[0]);
        }
        String defaultSocialSecurityNumber = FenixEduAcademicConfiguration.getConfiguration().getDefaultSocialSecurityNumber();
        if (defaultSocialSecurityNumber == null || !defaultSocialSecurityNumber.equals(socialSecurityNumber)) {
            for (PartySocialSecurityNumber securityNumber : Bennu.getInstance().getPartySocialSecurityNumbersSet()) {
                if (securityNumber == this || !securityNumber.hasSocialSecurityNumber(socialSecurityNumber)) continue;
                throw new DomainException("error.PartySocialSecurityNumber.number.already.exists", new String[0]);
            }
        }
    }

    public boolean hasSocialSecurityNumber(String socialSecurityNumber) {
        return this.getSocialSecurityNumber().equals(socialSecurityNumber);
    }

    public void delete() {
        this.setParty(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public static Party readPartyBySocialSecurityNumber(String socialSecurityNumber) {
        if (socialSecurityNumber == null || socialSecurityNumber.length() == 0) {
            return null;
        }
        for (PartySocialSecurityNumber securityNumber : Bennu.getInstance().getPartySocialSecurityNumbersSet()) {
            if (!securityNumber.hasSocialSecurityNumber(socialSecurityNumber)) continue;
            return securityNumber.getParty();
        }
        return null;
    }
}

