/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors;

import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.curricularRules.Exclusiveness;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;

public class ExclusivenessVerifier
extends VerifyRuleExecutor {
    @Override
    protected RuleResult verifyEnrolmentWithRules(ICurricularRule curricularRule, EnrolmentContext enrolmentContext, DegreeModule degreeModuleToVerify, CourseGroup rootOrCycleCourseGroup) {
        Exclusiveness exclusiveness = (Exclusiveness)((Object)curricularRule);
        DegreeModule exclusiveDegreeModule = exclusiveness.getExclusiveDegreeModule();
        if (exclusiveDegreeModule.isLeaf() && enrolmentContext.getStudentCurricularPlan().isApproved((CurricularCourse)((Object)exclusiveDegreeModule))) {
            return RuleResult.createFalse(degreeModuleToVerify);
        }
        IDegreeModuleToEvaluate degreeModuleToEvaluate = this.getDegreeModuleToEvaluate(enrolmentContext, exclusiveDegreeModule, rootOrCycleCourseGroup);
        if (degreeModuleToEvaluate != null) {
            if (!degreeModuleToEvaluate.isLeaf()) {
                return RuleResult.createFalse(degreeModuleToVerify);
            }
            CurricularCourse curricularCourse = (CurricularCourse)((Object)exclusiveDegreeModule);
            if (this.isApproved(enrolmentContext, curricularCourse, rootOrCycleCourseGroup) || degreeModuleToEvaluate.isEnroled() || degreeModuleToEvaluate.isEnroling()) {
                return RuleResult.createFalse(degreeModuleToVerify);
            }
        }
        return RuleResult.createTrue(degreeModuleToVerify);
    }

    @Override
    protected RuleResult verifyEnrolmentWithTemporaryEnrolment(ICurricularRule curricularRule, EnrolmentContext enrolmentContext, DegreeModule degreeModuleToVerify, CourseGroup rootOrCycleCourseGroup) {
        Exclusiveness exclusiveness = (Exclusiveness)((Object)curricularRule);
        DegreeModule exclusiveDegreeModule = exclusiveness.getExclusiveDegreeModule();
        IDegreeModuleToEvaluate degreeModuleToEvaluate = this.getDegreeModuleToEvaluate(enrolmentContext, exclusiveDegreeModule, rootOrCycleCourseGroup);
        if (degreeModuleToEvaluate != null) {
            if (!degreeModuleToEvaluate.isLeaf()) {
                return RuleResult.createFalse(degreeModuleToVerify);
            }
            CurricularCourse curricularCourse = (CurricularCourse)((Object)exclusiveDegreeModule);
            if (this.isApproved(enrolmentContext, curricularCourse, rootOrCycleCourseGroup) || this.hasEnrolmentWithEnroledState(enrolmentContext, curricularCourse, enrolmentContext.getExecutionPeriod().getPreviousExecutionPeriod())) {
                return RuleResult.createFalse(degreeModuleToVerify);
            }
        }
        return RuleResult.createTrue(degreeModuleToVerify);
    }

    private IDegreeModuleToEvaluate getDegreeModuleToEvaluate(EnrolmentContext enrolmentContext, DegreeModule degreeModule, CourseGroup rootOrCycleCourseGroup) {
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : enrolmentContext.getAllChildDegreeModulesToEvaluateFor((DegreeModule)((Object)rootOrCycleCourseGroup))) {
            if (!degreeModuleToEvaluate.isFor(degreeModule)) continue;
            return degreeModuleToEvaluate;
        }
        return null;
    }

    @Override
    protected RuleResult verifyDegreeConclusionWithRules(ICurricularRule curricularRule, EnrolmentContext enrolmentContext, DegreeModule degreeModuleToVerify, CourseGroup rootOrCycleCourseGroup) {
        Exclusiveness exclusiveness = (Exclusiveness)((Object)curricularRule);
        DegreeModule exclusiveDegreeModule = exclusiveness.getExclusiveDegreeModule();
        if (exclusiveDegreeModule.isCourseGroup()) {
            if (this.isEnrolledIn(enrolmentContext, (CourseGroup)((Object)exclusiveDegreeModule))) {
                return RuleResult.createFalse(degreeModuleToVerify);
            }
        } else if (exclusiveDegreeModule.isCurricularCourse()) {
            if (this.isApproved(enrolmentContext, (CurricularCourse)((Object)exclusiveDegreeModule), rootOrCycleCourseGroup)) {
                return RuleResult.createFalse(degreeModuleToVerify);
            }
        } else {
            throw new DomainException("error.org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.invalid.degree.module.to.verify", new String[0]);
        }
        return RuleResult.createTrue(degreeModuleToVerify);
    }
}

