/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors;

public enum RuleResultType {
    FALSE(0),
    TRUE(1),
    NA(2),
    WARNING(3);

    private static final RuleResultType[][] AND_TABLE;
    private static final RuleResultType[][] OR_TABLE;
    private int order;

    private RuleResultType(int order) {
        this.order = order;
    }

    public int order() {
        return this.order;
    }

    public String value() {
        return this.name();
    }

    public RuleResultType and(RuleResultType ruleResultType) {
        return AND_TABLE[this.order][ruleResultType.order()];
    }

    public RuleResultType or(RuleResultType ruleResultType) {
        return OR_TABLE[this.order][ruleResultType.order()];
    }

    static {
        AND_TABLE = new RuleResultType[][]{{FALSE, FALSE, FALSE, FALSE}, {FALSE, TRUE, TRUE, WARNING}, {FALSE, TRUE, NA, WARNING}, {FALSE, WARNING, WARNING, WARNING}};
        OR_TABLE = new RuleResultType[][]{{FALSE, TRUE, FALSE, WARNING}, {TRUE, TRUE, TRUE, TRUE}, {FALSE, TRUE, NA, WARNING}, {WARNING, TRUE, WARNING, WARNING}};
    }
}

