/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess;

import java.util.Comparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacy;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyExternalPersonDetails;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyInternalPersonDetails;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyPersonalDetails_Base;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.person.Gender;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.academic.domain.person.MaritalStatus;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.YearMonthDay;

public abstract class IndividualCandidacyPersonalDetails
extends IndividualCandidacyPersonalDetails_Base {
    public static final Comparator<IndividualCandidacyPersonalDetails> COMPARATOR_BY_NAME = new Comparator<IndividualCandidacyPersonalDetails>(){

        @Override
        public int compare(IndividualCandidacyPersonalDetails o1, IndividualCandidacyPersonalDetails o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    public static final Comparator<IndividualCandidacyPersonalDetails> COMPARATOR_BY_NAME_AND_ID = new Comparator<IndividualCandidacyPersonalDetails>(){

        @Override
        public int compare(IndividualCandidacyPersonalDetails o1, IndividualCandidacyPersonalDetails o2) {
            ComparatorChain comparatorChain = new ComparatorChain();
            comparatorChain.addComparator(COMPARATOR_BY_NAME);
            comparatorChain.addComparator(DomainObjectUtil.COMPARATOR_BY_ID);
            return comparatorChain.compare((Object)o1, (Object)o2);
        }
    };

    protected Bennu getRootDomainObject() {
        return this.getCandidacy().getRootDomainObject();
    }

    public abstract boolean isInternal();

    public abstract void edit(PersonBean var1);

    public abstract void editPublic(PersonBean var1);

    public abstract void ensurePersonInternalization();

    public static void createDetails(IndividualCandidacy candidacy, IndividualCandidacyProcessBean bean) {
        if (bean.getInternalPersonCandidacy().booleanValue()) {
            Person person = bean.getPersonBean().getPerson();
            bean.getPersonBean().setPerson(person);
            new IndividualCandidacyInternalPersonDetails(candidacy, person);
        } else {
            new IndividualCandidacyExternalPersonDetails(candidacy, bean);
        }
    }

    public boolean hasStudent() {
        return this.getStudent() != null;
    }

    public abstract Student getStudent();

    public abstract String getName();

    public abstract String getGivenNames();

    public abstract String getFamilyNames();

    public abstract Gender getGender();

    public abstract void setGender(Gender var1);

    public abstract String getProfession();

    public abstract void setProfession(String var1);

    public abstract MaritalStatus getMaritalStatus();

    public abstract void setMaritalStatus(MaritalStatus var1);

    public abstract YearMonthDay getDateOfBirthYearMonthDay();

    public abstract void setDateOfBirthYearMonthDay(YearMonthDay var1);

    public abstract Country getCountry();

    public abstract void setCountry(Country var1);

    public abstract String getSocialSecurityNumber();

    public abstract void setSocialSecurityNumber(String var1);

    @Deprecated
    public abstract String getFiscalCode();

    @Deprecated
    public abstract void setFiscalCode(String var1);

    public abstract String getDocumentIdNumber();

    public abstract void setDocumentIdNumber(String var1);

    public abstract IDDocumentType getIdDocumentType();

    public abstract void setIdDocumentType(IDDocumentType var1);

    public abstract YearMonthDay getEmissionDateOfDocumentIdYearMonthDay();

    public abstract void setEmissionDateOfDocumentIdYearMonthDay(YearMonthDay var1);

    public abstract YearMonthDay getExpirationDateOfDocumentIdYearMonthDay();

    public abstract void setExpirationDateOfDocumentIdYearMonthDay(YearMonthDay var1);

    public abstract String getEmissionLocationOfDocumentId();

    public abstract void setEmissionLocationOfDocumentId(String var1);

    public abstract String getTelephoneContact();

    public abstract void setTelephoneContact(String var1);

    public abstract String getEmail();

    public abstract void setEmail(String var1);

    public abstract Country getCountryOfResidence();

    public abstract void setCountryOfResidence(Country var1);

    public abstract String getAddress();

    public abstract void setAddress(String var1);

    public abstract String getArea();

    public abstract void setArea(String var1);

    public abstract String getAreaCode();

    public abstract void setAreaCode(String var1);

    public abstract String getAreaOfAreaCode();

    public abstract void setAreaOfAreaCode(String var1);

    @Deprecated
    public abstract PhysicalAddress getDefaultPhysicalAddress();

    public abstract Boolean hasAnyRole();

    public abstract String getEidentifier();
}

