/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.serviceRequests;

import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.DegreeFinalizationCertificateRequestEvent;
import org.fenixedu.academic.domain.accounting.postingRules.serviceRequests.DegreeFinalizationCertificateRequestPR_Base;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;

public class DegreeFinalizationCertificateRequestPR
extends DegreeFinalizationCertificateRequestPR_Base {
    protected DegreeFinalizationCertificateRequestPR() {
    }

    public DegreeFinalizationCertificateRequestPR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money baseAmount, Money amountPerUnit, Money amountPerPage, Money maximumAmount) {
        this();
        this.init(EntryType.DEGREE_FINALIZATION_CERTIFICATE_REQUEST_FEE, EventType.DEGREE_FINALIZATION_CERTIFICATE_REQUEST, startDate, endDate, serviceAgreementTemplate, baseAmount, amountPerUnit, amountPerPage, maximumAmount);
    }

    public DegreeFinalizationCertificateRequestPR edit(Money baseAmount, Money amountPerUnit, Money amountPerPage, Money maximumAmount) {
        this.deactivate();
        return new DegreeFinalizationCertificateRequestPR(new DateTime().minus(1000L), null, this.getServiceAgreementTemplate(), baseAmount, amountPerUnit, amountPerPage, maximumAmount);
    }

    protected Money subtractFromExemptions(Event event, DateTime when, boolean applyDiscount, Money amountToPay) {
        DegreeFinalizationCertificateRequestEvent requestEvent = (DegreeFinalizationCertificateRequestEvent)((Object)event);
        if (requestEvent.hasAcademicEventExemption()) {
            return amountToPay.subtract(requestEvent.getAcademicEventExemption().getValue());
        }
        if (amountToPay.isNegative()) {
            return Money.ZERO;
        }
        return amountToPay;
    }
}

