/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.gratuity;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.Exemption;
import org.fenixedu.academic.domain.accounting.events.ExemptionJustification;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEvent;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityExemptionJustification;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityExemptionJustificationFactory;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityExemptionJustificationType;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityExemption_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;
import org.joda.time.YearMonthDay;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public abstract class GratuityExemption
extends GratuityExemption_Base {
    protected GratuityExemption() {
    }

    protected void init(Person responsible, GratuityEvent gratuityEvent, GratuityExemptionJustificationType exemptionType, String reason, YearMonthDay dispatchDate) {
        super.init(responsible, (Event)((Object)gratuityEvent), (ExemptionJustification)((Object)GratuityExemptionJustificationFactory.create(this, exemptionType, reason, dispatchDate)));
        gratuityEvent.recalculateState(new DateTime());
    }

    public GratuityEvent getGratuityEvent() {
        return (GratuityEvent)((Object)this.getEvent());
    }

    public GratuityExemptionJustificationType getJustificationType() {
        return this.getExemptionJustification().getGratuityExemptionJustificationType();
    }

    public GratuityExemptionJustification getExemptionJustification() {
        return (GratuityExemptionJustification)((Object)super.getExemptionJustification());
    }

    public boolean isValueExemption() {
        return false;
    }

    public boolean isPercentageExemption() {
        return false;
    }

    public abstract BigDecimal calculateDiscountPercentage(Money var1);

    public boolean isGratuityExemption() {
        return true;
    }

    static {
        GratuityExemption.getRelationExemptionEvent().addListener((RelationListener)new RelationAdapter<Exemption, Event>(){

            public void beforeAdd(Exemption exemption, Event event) {
                if (event instanceof GratuityEvent && exemption instanceof GratuityExemption) {
                    GratuityEvent gratuityEvent = (GratuityEvent)((Object)event);
                    if (gratuityEvent.hasGratuityExemption()) {
                        throw new DomainException("error.org.fenixedu.academic.domain.accounting.events.gratuity.GratuityExemption.event.already.has.gratuity.exemption", new String[0]);
                    }
                    GratuityExemption gratuityExemption = (GratuityExemption)((Object)exemption);
                    if (!gratuityEvent.canApplyExemption(gratuityExemption.getJustificationType())) {
                        throw new DomainException("error.accounting.events.gratuity.GratuityExemption.gratuity.exemption.type.cannot.applied.to.gratuity.event", new String[0]);
                    }
                }
            }
        });
    }
}

