/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.TeacherAuthorization;
import org.fenixedu.academic.domain.TeacherCategory;
import org.fenixedu.academic.domain.Teacher_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.messaging.ExecutionCourseForum;
import org.fenixedu.academic.domain.messaging.Forum;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.util.PeriodState;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class Teacher
extends Teacher_Base {
    public static final Comparator<Teacher> TEACHER_COMPARATOR_BY_CATEGORY_AND_NUMBER = new Comparator<Teacher>(){

        @Override
        public int compare(Teacher teacher1, Teacher teacher2) {
            int teacherIdCompare = teacher1.getPerson().getUsername().compareTo(teacher2.getPerson().getUsername());
            if (teacher1.getLastCategory() == null && teacher2.getLastCategory() == null) {
                return teacherIdCompare;
            }
            if (teacher1.getLastCategory() == null) {
                return 1;
            }
            if (teacher2.getLastCategory() == null) {
                return -1;
            }
            int categoryCompare = teacher1.getLastCategory().compareTo(teacher2.getLastCategory());
            return categoryCompare == 0 ? teacherIdCompare : categoryCompare;
        }
    };

    public Teacher(Person person) {
        this.setPerson(person);
        this.setRootDomainObject(Bennu.getInstance());
    }

    public String getTeacherId() {
        return this.getPerson().getUsername();
    }

    public static Teacher readByIstId(String istId) {
        User user = User.findByUsername((String)istId);
        if (user != null) {
            return user.getPerson().getTeacher();
        }
        return null;
    }

    public void setPerson(Person person) {
        if (person == null) {
            throw new DomainException("error.teacher.no.person", new String[0]);
        }
        super.setPerson(person);
    }

    public List<Professorship> responsibleFors() {
        ArrayList<Professorship> result = new ArrayList<Professorship>();
        for (Professorship professorship : this.getProfessorships()) {
            if (!professorship.isResponsibleFor()) continue;
            result.add(professorship);
        }
        return result;
    }

    public Professorship isResponsibleFor(ExecutionCourse executionCourse) {
        for (Professorship professorship : this.getProfessorships()) {
            if (!professorship.getResponsibleFor().booleanValue() || professorship.getExecutionCourse() != executionCourse) continue;
            return professorship;
        }
        return null;
    }

    public Optional<Department> getDepartment(AcademicInterval interval) {
        return this.getTeacherAuthorization(interval).map(a -> a.getDepartment());
    }

    public Department getDepartment() {
        return this.getDepartment(AcademicInterval.readDefaultAcademicInterval(AcademicPeriod.SEMESTER)).orElse(null);
    }

    public Department getLastDepartment(AcademicInterval interval) {
        return this.getLastTeacherAuthorization(interval).map(a -> a.getDepartment()).orElse(null);
    }

    public Department getLastDepartment() {
        return this.getLastDepartment(AcademicInterval.readDefaultAcademicInterval(AcademicPeriod.SEMESTER));
    }

    public Optional<TeacherCategory> getCategory(AcademicInterval interval) {
        return this.getTeacherAuthorization(interval).map(a -> a.getTeacherCategory());
    }

    public TeacherCategory getCategory() {
        return this.getCategory(AcademicInterval.readDefaultAcademicInterval(AcademicPeriod.SEMESTER)).orElse(null);
    }

    public Optional<TeacherCategory> getLastCategory(AcademicInterval interval) {
        return this.getLastTeacherAuthorization(interval).map(a -> a.getTeacherCategory());
    }

    public TeacherCategory getLastCategory() {
        return this.getLastCategory(AcademicInterval.readDefaultAcademicInterval(AcademicPeriod.SEMESTER)).orElse(null);
    }

    public List<ExecutionCourse> getLecturedExecutionCoursesByExecutionYear(ExecutionYear executionYear) {
        ArrayList<ExecutionCourse> executionCourses = new ArrayList<ExecutionCourse>();
        for (ExecutionSemester executionSemester : executionYear.getExecutionPeriodsSet()) {
            executionCourses.addAll(this.getLecturedExecutionCoursesByExecutionPeriod(executionSemester));
        }
        return executionCourses;
    }

    public List<ExecutionCourse> getLecturedExecutionCoursesByExecutionPeriod(ExecutionSemester executionSemester) {
        ArrayList<ExecutionCourse> executionCourses = new ArrayList<ExecutionCourse>();
        for (Professorship professorship : this.getProfessorships()) {
            ExecutionCourse executionCourse = professorship.getExecutionCourse();
            if (!executionCourse.getExecutionPeriod().equals(executionSemester)) continue;
            executionCourses.add(executionCourse);
        }
        return executionCourses;
    }

    public List<ExecutionCourse> getAllLecturedExecutionCourses() {
        ArrayList<ExecutionCourse> executionCourses = new ArrayList<ExecutionCourse>();
        for (Professorship professorship : this.getProfessorships()) {
            executionCourses.add(professorship.getExecutionCourse());
        }
        return executionCourses;
    }

    public Professorship getProfessorshipByExecutionCourse(final ExecutionCourse executionCourse) {
        return (Professorship)((Object)CollectionUtils.find(this.getProfessorships(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                Professorship professorship = (Professorship)((Object)arg0);
                return professorship.getExecutionCourse() == executionCourse;
            }
        }));
    }

    public boolean hasProfessorshipForExecutionCourse(ExecutionCourse executionCourse) {
        return this.getProfessorshipByExecutionCourse(executionCourse) != null;
    }

    public List<Professorship> getDegreeProfessorshipsByExecutionPeriod(final ExecutionSemester executionSemester) {
        return (List)CollectionUtils.select(this.getProfessorships(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                Professorship professorship = (Professorship)((Object)arg0);
                return professorship.getExecutionCourse().getExecutionPeriod() == executionSemester && !professorship.getExecutionCourse().isMasterDegreeDFAOrDEAOnly();
            }
        });
    }

    public static Teacher readTeacherByUsername(String userName) {
        Person person = Person.readPersonByUsername(userName);
        return person.getTeacher() != null ? person.getTeacher() : null;
    }

    public static List<Teacher> readByNumbers(Collection<String> teacherId) {
        ArrayList<Teacher> selectedTeachers = new ArrayList<Teacher>();
        for (Teacher teacher : Bennu.getInstance().getTeachersSet()) {
            if (teacherId.contains(teacher.getPerson().getUsername())) {
                selectedTeachers.add(teacher);
            }
            if (teacherId.size() != selectedTeachers.size()) continue;
            break;
        }
        return selectedTeachers;
    }

    public List<Professorship> getProfessorships(ExecutionSemester executionSemester) {
        return this.getPerson().getProfessorships(executionSemester);
    }

    public List<Professorship> getProfessorships(ExecutionYear executionYear) {
        return this.getPerson().getProfessorships(executionYear);
    }

    public SortedSet<ExecutionCourse> getCurrentExecutionCourses() {
        TreeSet<ExecutionCourse> executionCourses = new TreeSet<ExecutionCourse>(ExecutionCourse.EXECUTION_COURSE_COMPARATOR_BY_EXECUTION_PERIOD_AND_NAME);
        ExecutionSemester currentExecutionPeriod = ExecutionSemester.readActualExecutionSemester();
        ExecutionSemester previousExecutionPeriod = currentExecutionPeriod.getPreviousExecutionPeriod();
        for (Professorship professorship : this.getProfessorshipsSet()) {
            ExecutionCourse executionCourse = professorship.getExecutionCourse();
            ExecutionSemester executionSemester = executionCourse.getExecutionPeriod();
            if (executionSemester != currentExecutionPeriod && executionSemester != previousExecutionPeriod) continue;
            executionCourses.add(executionCourse);
        }
        return executionCourses;
    }

    public boolean isResponsibleFor(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        for (ExecutionCourse executionCourse : curricularCourse.getAssociatedExecutionCoursesSet()) {
            if (executionCourse.getExecutionPeriod() != executionSemester || this.isResponsibleFor(executionCourse) == null) continue;
            return true;
        }
        return false;
    }

    public boolean teachesAny(Collection<ExecutionCourse> executionCourses, ExecutionYear executionYear) {
        for (Professorship professorship : this.getProfessorships(executionYear)) {
            if (!executionCourses.contains((Object)professorship.getExecutionCourse())) continue;
            return true;
        }
        return false;
    }

    public boolean teachesAny(Collection<ExecutionCourse> executionCourses) {
        return this.getPerson().teachesAny(executionCourses);
    }

    public void delete() {
        super.setPerson(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public boolean hasLessons(DateTime begin, DateTime end) {
        return this.hasLessons(begin, end, ExecutionYear.readCurrentExecutionYear());
    }

    public boolean hasLessons(DateTime begin, DateTime end, ExecutionYear executionYear) {
        Interval interval = new Interval((ReadableInstant)begin, (ReadableInstant)end);
        for (Professorship professorship : this.getProfessorships(executionYear)) {
            Set<Shift> associatedShifts = professorship.getExecutionCourse().getAssociatedShifts();
            for (Shift shift : associatedShifts) {
                Set associatedLessons = shift.getAssociatedLessonsSet();
                for (Lesson lesson : associatedLessons) {
                    if (!lesson.contains(interval)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Collection<? extends Forum> getForuns(ExecutionSemester executionSemester) {
        HashSet<ExecutionCourseForum> res = new HashSet<ExecutionCourseForum>();
        for (Professorship professorship : this.getProfessorshipsSet()) {
            if (professorship.getExecutionCourse().getExecutionPeriod() != executionSemester) continue;
            res.addAll(professorship.getExecutionCourse().getForuns());
        }
        return res;
    }

    public boolean teachesAt(Space campus) {
        for (Professorship professorship : this.getProfessorshipsSet()) {
            ExecutionCourse executionCourse = professorship.getExecutionCourse();
            if (!executionCourse.getExecutionPeriod().getState().equals(PeriodState.CURRENT)) continue;
            return executionCourse.functionsAt(campus);
        }
        return false;
    }

    public Set<Professorship> getProfessorshipsSet() {
        return this.getPerson().getProfessorshipsSet();
    }

    public void addProfessorships(Professorship professorship) {
        this.getPerson().addProfessorships(professorship);
    }

    public void removeProfessorships(Professorship professorship) {
        this.getPerson().removeProfessorships(professorship);
    }

    public Collection<Professorship> getProfessorships() {
        return this.getPerson().getProfessorshipsSet();
    }

    public Iterator<Professorship> getProfessorshipsIterator() {
        return this.getPerson().getProfessorshipsSet().iterator();
    }

    public Stream<TeacherAuthorization> getRevokedTeacherAuthorizationStream() {
        return this.getRevokedAuthorizationSet().stream().sorted(Collections.reverseOrder());
    }

    public Stream<TeacherAuthorization> getTeacherAuthorizationStream() {
        return this.getAuthorizationSet().stream().sorted(Collections.reverseOrder());
    }

    public Optional<TeacherAuthorization> getTeacherAuthorization(AcademicInterval interval) {
        return this.getTeacherAuthorizationStream().filter(a -> a.getExecutionSemester().getAcademicInterval().equals(interval)).findFirst();
    }

    public Optional<TeacherAuthorization> getTeacherAuthorization() {
        return this.getTeacherAuthorization(AcademicInterval.readDefaultAcademicInterval(AcademicPeriod.SEMESTER));
    }

    public boolean hasTeacherAuthorization(AcademicInterval interval) {
        return this.getTeacherAuthorization(interval).isPresent();
    }

    public boolean hasTeacherAuthorization() {
        return this.getTeacherAuthorization().isPresent();
    }

    protected Optional<TeacherAuthorization> getLastTeacherAuthorization(AcademicInterval interval) {
        return this.getTeacherAuthorizationStream().filter(a -> !a.getExecutionSemester().getAcademicInterval().isAfter((ReadableInterval)interval)).findFirst();
    }

    public Optional<TeacherAuthorization> getLatestTeacherAuthorizationInInterval(Interval interval) {
        return this.getTeacherAuthorizationStream().filter(a -> a.getExecutionSemester().getAcademicInterval().overlaps((ReadableInterval)interval)).findFirst();
    }

    public boolean isActiveContractedTeacher() {
        return this.getTeacherAuthorization().map(a -> a.isContracted()).orElse(false);
    }

    public boolean isErasmusCoordinator() {
        return !this.getMobilityCoordinationsSet().isEmpty();
    }
}

