/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.student;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.WeeklyWorkLoad;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.student.CreateWeeklyWorkLoad;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.student.StudentApplication;
import org.fenixedu.academic.ui.struts.action.student.WeeklyWorkLoadBean;
import org.fenixedu.academic.util.PeriodState;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import pt.ist.fenixWebFramework.renderers.components.state.LifeCycleConstants;
import pt.ist.fenixWebFramework.renderers.components.state.ViewState;

@StrutsFunctionality(app=StudentApplication.StudentParticipateApp.class, path="weekly-workload", titleKey="link.weekly.work.load")
@Mapping(module="student", path="/weeklyWorkLoad", input="/weeklyWorkLoad.do?method=prepare&page=0", formBean="weeklyWorkLoadForm")
@Forwards(value={@Forward(name="showWeeklyWorkLoad", path="/student/weeklyWorkLoad.jsp")})
public class WeeklyWorkLoadDA
extends FenixDispatchAction {
    private static final Comparator<Attends> ATTENDS_COMPARATOR = new Comparator<Attends>(){

        @Override
        public int compare(Attends attends1, Attends attends2) {
            ExecutionCourse executionCourse1 = attends1.getExecutionCourse();
            ExecutionCourse executionCourse2 = attends2.getExecutionCourse();
            return executionCourse1.getNome().compareTo(executionCourse2.getNome());
        }
    };

    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        Set executionSemesters = rootDomainObject.getExecutionPeriodsSet();
        TreeSet sortedExecutionPeriods = new TreeSet(executionSemesters);
        request.setAttribute("executionPeriods", sortedExecutionPeriods);
        DynaActionForm dynaActionForm = (DynaActionForm)form;
        String executionPeriodID = this.getExecutionPeriodID(dynaActionForm);
        ExecutionSemester selectedExecutionPeriod = this.findExecutionPeriod(executionSemesters, executionPeriodID);
        request.setAttribute("selectedExecutionPeriod", (Object)selectedExecutionPeriod);
        dynaActionForm.set("executionPeriodID", (Object)selectedExecutionPeriod.getExternalId().toString());
        Attends firstAttends = this.findFirstAttends(request, selectedExecutionPeriod);
        request.setAttribute("firstAttends", (Object)firstAttends);
        if (firstAttends != null) {
            Interval executionPeriodInterval = firstAttends.getWeeklyWorkLoadInterval();
            WeeklyWorkLoadView weeklyWorkLoadView = new WeeklyWorkLoadView(executionPeriodInterval);
            request.setAttribute("weeklyWorkLoadView", (Object)weeklyWorkLoadView);
            ArrayList<Attends> attends = new ArrayList<Attends>();
            request.setAttribute("attends", attends);
            for (Registration registration : WeeklyWorkLoadDA.getUserView(request).getPerson().getStudents()) {
                for (Attends attend : registration.getOrderedAttends()) {
                    ExecutionCourse executionCourse;
                    if (attend.getEnrolment() == null || (executionCourse = attend.getExecutionCourse()).getExecutionPeriod() != selectedExecutionPeriod) continue;
                    weeklyWorkLoadView.add(attend);
                    attends.add(attend);
                }
            }
            request.setAttribute("weeklyWorkLoadBean", (Object)new WeeklyWorkLoadBean());
        }
        dynaActionForm.set("contact", null);
        dynaActionForm.set("autonomousStudy", null);
        dynaActionForm.set("other", null);
        return mapping.findForward("showWeeklyWorkLoad");
    }

    private SortedSet<Week> getWeeks(ExecutionSemester executionSemester) {
        return null;
    }

    private Attends findFirstAttends(HttpServletRequest request, ExecutionSemester selectedExecutionPeriod) throws FenixServiceException {
        for (Registration registration : WeeklyWorkLoadDA.getUserView(request).getPerson().getStudents()) {
            for (Attends attend : registration.getOrderedAttends()) {
                ExecutionCourse executionCourse = attend.getExecutionCourse();
                if (executionCourse.getExecutionPeriod() != selectedExecutionPeriod || attend.getEnrolment() == null) continue;
                return attend;
            }
        }
        return null;
    }

    public ActionForward create(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        WeeklyWorkLoadBean weeklyWorkLoadBean = this.getWeeklyWorkLoadBean(request);
        String attendsID = weeklyWorkLoadBean.getAttendsID();
        Integer contact = weeklyWorkLoadBean.getContact();
        Integer autonomousStudy = weeklyWorkLoadBean.getAutonomousStudy();
        Integer other = weeklyWorkLoadBean.getOther();
        this.create(request, attendsID, contact, autonomousStudy, other);
        return this.prepare(mapping, form, request, response);
    }

    public ActionForward createFromForm(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        DynaActionForm dynaActionForm = (DynaActionForm)form;
        String attendsID = dynaActionForm.getString("attendsID");
        Integer contact = this.getInteger(dynaActionForm, "contact");
        Integer autonomousStudy = this.getInteger(dynaActionForm, "autonomousStudy");
        Integer other = this.getInteger(dynaActionForm, "other");
        this.create(request, attendsID, contact, autonomousStudy, other);
        dynaActionForm.set("contact", null);
        dynaActionForm.set("autonomousStudy", null);
        dynaActionForm.set("other", null);
        return this.prepare(mapping, form, request, response);
    }

    public void create(HttpServletRequest request, String attendsID, Integer contact, Integer autonomousStudy, Integer other) throws FenixServiceException {
        CreateWeeklyWorkLoad.run(attendsID, contact, autonomousStudy, other);
    }

    private WeeklyWorkLoadBean getWeeklyWorkLoadBean(HttpServletRequest request) {
        ViewState viewState = (ViewState)request.getAttribute(LifeCycleConstants.VIEWSTATE_PARAM_NAME);
        return (WeeklyWorkLoadBean)viewState.getMetaObject().getObject();
    }

    private String getExecutionPeriodID(DynaActionForm dynaActionForm) {
        String exeutionPeriodIDString = dynaActionForm.getString("executionPeriodID");
        return exeutionPeriodIDString == null || exeutionPeriodIDString.length() == 0 ? null : exeutionPeriodIDString;
    }

    private ExecutionSemester findExecutionPeriod(Collection<ExecutionSemester> executionSemesters, String executionPeriodID) {
        for (ExecutionSemester executionSemester : executionSemesters) {
            if (executionPeriodID == null && executionSemester.getState().equals(PeriodState.CURRENT)) {
                return executionSemester;
            }
            if (executionPeriodID == null || !executionSemester.getExternalId().equals(executionPeriodID)) continue;
            return executionSemester;
        }
        return null;
    }

    static /* synthetic */ Comparator access$000() {
        return ATTENDS_COMPARATOR;
    }

    private static class Week {
        private int weekOffset;
        private Interval interval;

        private Week() {
        }

        public int getWeekOffset() {
            return this.weekOffset;
        }

        public void setWeekOffset(int weekOffset) {
            this.weekOffset = weekOffset;
        }

        public Interval getInterval() {
            return this.interval;
        }

        public void setInterval(Interval interval) {
            this.interval = interval;
        }
    }

    public static class WeeklyWorkLoadView {
        final Interval executionPeriodInterval;
        final int numberOfWeeks;
        final Map<Attends, WeeklyWorkLoad[]> weeklyWorkLoadMap = new TreeMap<Attends, WeeklyWorkLoad[]>(WeeklyWorkLoadDA.access$000());
        final Interval[] intervals;
        final IntervalType[] intervalTypes;

        public WeeklyWorkLoadView(Interval executionPeriodInterval) {
            this.executionPeriodInterval = executionPeriodInterval;
            Period period = executionPeriodInterval.toPeriod();
            int extraWeek = period.getDays() > 0 ? 1 : 0;
            this.numberOfWeeks = (period.getYears() * 12 + period.getMonths()) * 4 + period.getWeeks() + extraWeek + 1;
            this.intervals = new Interval[this.numberOfWeeks];
            this.intervalTypes = new IntervalType[this.numberOfWeeks];
            for (int i = 0; i < this.numberOfWeeks; ++i) {
                DateTime start = executionPeriodInterval.getStart().plusWeeks(i);
                DateTime end = start.plusWeeks(1);
                this.intervals[i] = new Interval((ReadableInstant)start, (ReadableInstant)end);
            }
        }

        public void add(Attends attends) {
            WeeklyWorkLoad[] weeklyWorkLoadArray = new WeeklyWorkLoad[this.numberOfWeeks];
            Iterator iterator = attends.getWeeklyWorkLoadsSet().iterator();
            while (iterator.hasNext()) {
                WeeklyWorkLoad weeklyWorkLoad;
                weeklyWorkLoadArray[weeklyWorkLoad.getWeekOffset().intValue()] = weeklyWorkLoad = (WeeklyWorkLoad)iterator.next();
            }
            this.weeklyWorkLoadMap.put(attends, weeklyWorkLoadArray);
        }

        public Interval[] getIntervals() {
            return this.intervals;
        }

        public Interval getExecutionPeriodInterval() {
            return this.executionPeriodInterval;
        }

        public Map<Attends, WeeklyWorkLoad[]> getWeeklyWorkLoadMap() {
            return this.weeklyWorkLoadMap;
        }
    }

    public static enum IntervalType {
        LESSON_INTERVAL,
        EXAM_INTERVAL;

    }
}

