/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.directiveCouncil;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.interfaces.HasDegreeType;
import org.fenixedu.academic.domain.interfaces.HasExecutionYear;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.directiveCouncil.DirectiveCouncilApplication;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=DirectiveCouncilApplication.class, path="student-statistics", titleKey="link.statistics.students")
@Mapping(path="/studentStatistics", module="directiveCouncil")
@Forwards(value={@Forward(name="show.student.statistics", path="/directiveCouncil/showStudentStatistics.jsp")})
public class StudentStatisticsDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward showStatistics(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ContextBean contextBean = (ContextBean)this.getRenderedObject();
        if (contextBean == null) {
            contextBean = new ContextBean();
            contextBean.setExecutionYear(ExecutionYear.readCurrentExecutionYear());
        }
        RenderUtils.invalidateViewState();
        request.setAttribute("contextBean", (Object)contextBean);
        request.setAttribute("statisticsBean", (Object)new StatisticsBean(contextBean));
        return mapping.findForward("show.student.statistics");
    }

    public static class StatisticsBean
    implements Serializable {
        private final ContextBean contextBean;

        public StatisticsBean(ContextBean contextBean) {
            this.contextBean = contextBean;
        }

        public int getNumberOfRegisteredStudents() {
            ExecutionDegree executionDegree = this.contextBean.getExecutionDegree();
            int counter = 0;
            if (executionDegree == null) {
                ExecutionYear executionYear = this.contextBean.getExecutionYear();
                DegreeType degreeType = this.contextBean.getDegreeType();
                for (Degree degree : rootDomainObject.getDegreesSet()) {
                    if (degree.getDegreeType() != degreeType) continue;
                    counter += this.countDegreeRegistrations(executionYear, degree);
                }
            } else {
                Degree degree = executionDegree.getDegree();
                counter = this.countDegreeRegistrations(executionDegree.getExecutionYear(), degree);
            }
            return counter;
        }

        private int countDegreeRegistrations(ExecutionYear executionYear, Degree degree) {
            int counter = 0;
            for (Registration registration : degree.getRegistrationsSet()) {
                if (!registration.isRegistered(executionYear)) continue;
                ++counter;
            }
            return counter;
        }

        public Boolean getShowResult() {
            return this.contextBean.getDegreeType() != null && this.contextBean.getExecutionYear() != null || this.contextBean.getExecutionDegree() != null;
        }
    }

    public static class ContextBean
    implements Serializable,
    HasExecutionYear,
    HasDegreeType {
        private DegreeType degreeType;
        private ExecutionYear executionYearReference;
        private ExecutionDegree executionDegreeReference;

        @Override
        public DegreeType getDegreeType() {
            return this.degreeType;
        }

        public void setDegreeType(DegreeType degreeType) {
            this.degreeType = degreeType;
        }

        @Override
        public ExecutionYear getExecutionYear() {
            return this.executionYearReference;
        }

        public void setExecutionYear(ExecutionYear executionYear) {
            this.executionYearReference = executionYear;
        }

        public ExecutionDegree getExecutionDegree() {
            return this.executionDegreeReference;
        }

        public void setExecutionDegree(ExecutionDegree executionDegree) {
            this.executionDegreeReference = executionDegree;
        }

        public ExecutionYear getExecutionYearFourYearsBack() {
            ExecutionYear executionYear = this.getExecutionYear();
            return executionYear == null ? null : ContextBean.getExecutionYearFourYearsBack(executionYear);
        }

        public static ExecutionYear getExecutionYearFourYearsBack(ExecutionYear executionYear) {
            ExecutionYear executionYearFourYearsBack = executionYear;
            if (executionYear != null) {
                for (int i = 5; i > 1; --i) {
                    ExecutionYear previousExecutionYear = executionYearFourYearsBack.getPreviousExecutionYear();
                    if (previousExecutionYear == null) continue;
                    executionYearFourYearsBack = previousExecutionYear;
                }
            }
            return executionYearFourYearsBack;
        }
    }
}

