/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.candidacy.graduatedPerson;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.graduatedPerson.DegreeCandidacyForGraduatedPersonIndividualProcess;
import org.fenixedu.academic.domain.candidacyProcess.graduatedPerson.DegreeCandidacyForGraduatedPersonProcess;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.period.DegreeCandidacyForGraduatedPersonCandidacyPeriod;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.candidacy.CandidacyProcessDA;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.fenixedu.commons.spreadsheet.SpreadsheetXLSExporter;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminCandidaciesApp.class, path="degree-candidacy-for-graduated-person", titleKey="label.candidacy.graduatedPerson", accessGroup="(academic(MANAGE_CANDIDACY_PROCESSES) | academic(MANAGE_INDIVIDUAL_CANDIDACIES))", bundle="ApplicationResources")
@Mapping(path="/caseHandlingDegreeCandidacyForGraduatedPersonProcess", module="academicAdministration", formBeanClass=CandidacyProcessDA.CandidacyProcessForm.class)
@Forwards(value={@Forward(name="intro", path="/candidacy/mainCandidacyProcess.jsp"), @Forward(name="prepare-create-new-process", path="/candidacy/createCandidacyPeriod.jsp"), @Forward(name="prepare-edit-candidacy-period", path="/candidacy/editCandidacyPeriod.jsp"), @Forward(name="send-to-coordinator", path="/candidacy/sendToCoordinator.jsp"), @Forward(name="send-to-scientificCouncil", path="/candidacy/sendToScientificCouncil.jsp"), @Forward(name="view-candidacy-results", path="/candidacy/graduatedPerson/viewCandidacyResults.jsp"), @Forward(name="introduce-candidacy-results", path="/candidacy/graduatedPerson/introduceCandidacyResults.jsp"), @Forward(name="create-registrations", path="/candidacy/createRegistrations.jsp"), @Forward(name="prepare-select-available-degrees", path="/candidacy/selectAvailableDegrees.jsp")})
public class DegreeCandidacyForGraduatedPersonProcessDA
extends CandidacyProcessDA {
    @Override
    protected Class getProcessType() {
        return DegreeCandidacyForGraduatedPersonProcess.class;
    }

    @Override
    protected Class getChildProcessType() {
        return DegreeCandidacyForGraduatedPersonIndividualProcess.class;
    }

    @Override
    protected Class getCandidacyPeriodType() {
        return DegreeCandidacyForGraduatedPersonCandidacyPeriod.class;
    }

    protected DegreeCandidacyForGraduatedPersonProcess getProcess(HttpServletRequest request) {
        return (DegreeCandidacyForGraduatedPersonProcess)((Object)super.getProcess(request));
    }

    @Override
    protected CandidacyProcess getCandidacyProcess(HttpServletRequest request, ExecutionInterval executionInterval) {
        return executionInterval.hasDegreeCandidacyForGraduatedPersonCandidacyPeriod() ? executionInterval.getDegreeCandidacyForGraduatedPersonCandidacyPeriod().getDegreeCandidacyForGraduatedPersonProcess() : null;
    }

    @Override
    protected ActionForward introForward(ActionMapping mapping) {
        return mapping.findForward("intro");
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setChooseDegreeBean(request);
        return super.execute(mapping, actionForm, request, response);
    }

    @Override
    public ActionForward listProcessAllowedActivities(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)this.getProcess(request)));
        this.setCandidacyProcessInformation(form, (CandidacyProcess)((Object)this.getProcess(request)));
        return this.introForward(mapping);
    }

    protected void setCandidacyProcessInformation(ActionForm actionForm, CandidacyProcess process2) {
        CandidacyProcessDA.CandidacyProcessForm form = (CandidacyProcessDA.CandidacyProcessForm)actionForm;
        form.setExecutionIntervalId(process2.getCandidacyExecutionInterval().getExternalId());
    }

    private void setChooseDegreeBean(HttpServletRequest request) {
        CandidacyProcessDA.ChooseDegreeBean chooseDegreeBean = (CandidacyProcessDA.ChooseDegreeBean)this.getObjectFromViewState("choose.degree.bean");
        if (chooseDegreeBean == null) {
            chooseDegreeBean = new CandidacyProcessDA.ChooseDegreeBean();
        }
        request.setAttribute("chooseDegreeBean", (Object)chooseDegreeBean);
    }

    private CandidacyProcessDA.ChooseDegreeBean getChooseDegreeBean(HttpServletRequest request) {
        return (CandidacyProcessDA.ChooseDegreeBean)request.getAttribute("chooseDegreeBean");
    }

    @Override
    protected void setStartInformation(ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        if (!this.hasExecutionInterval(request)) {
            List<ExecutionInterval> executionIntervals = ExecutionInterval.readExecutionIntervalsWithCandidacyPeriod(this.getCandidacyPeriodType());
            if (executionIntervals.size() == 1) {
                this.setCandidacyProcessInformation(request, this.getCandidacyProcess(request, executionIntervals.iterator().next()));
            } else {
                request.setAttribute("canCreateProcess", this.canCreateProcess(this.getProcessType().getName()));
                request.setAttribute("executionIntervals", executionIntervals);
            }
        } else {
            this.setCandidacyProcessInformation(request, this.getCandidacyProcess(request, this.getExecutionInterval(request)));
        }
    }

    public ActionForward prepareExecuteSendToCoordinator(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("send-to-coordinator");
    }

    public ActionForward executeSendToCoordinator(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeActivity((Process)((Object)this.getProcess(request)), "SendToCoordinator");
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            return this.prepareExecuteSendToCoordinator(mapping, actionForm, request, response);
        }
        return this.listProcessAllowedActivities(mapping, actionForm, request, response);
    }

    public ActionForward prepareExecuteSendToScientificCouncil(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("send-to-scientificCouncil");
    }

    public ActionForward executeSendToScientificCouncil(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeActivity((Process)((Object)this.getProcess(request)), "SendToScientificCouncil");
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            return this.prepareExecuteSendToScientificCouncil(mapping, actionForm, request, response);
        }
        return this.listProcessAllowedActivities(mapping, actionForm, request, response);
    }

    public ActionForward prepareExecutePrintCandidacies(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment; filename=" + this.getReportFilename());
        this.writeReport(this.getProcess(request), response.getOutputStream());
        response.getOutputStream().flush();
        response.flushBuffer();
        return null;
    }

    private void writeReport(DegreeCandidacyForGraduatedPersonProcess process2, ServletOutputStream outputStream) throws IOException {
        ArrayList<Spreadsheet> spreadsheets = new ArrayList<Spreadsheet>();
        for (Map.Entry<Degree, SortedSet<DegreeCandidacyForGraduatedPersonIndividualProcess>> entry : process2.getValidDegreeCandidaciesForGraduatedPersonsByDegree().entrySet()) {
            spreadsheets.add(this.buildReport(entry.getKey(), entry.getValue()));
        }
        new SpreadsheetXLSExporter().exportToXLSSheets((OutputStream)outputStream, spreadsheets);
    }

    private Spreadsheet buildReport(Degree degree, SortedSet<DegreeCandidacyForGraduatedPersonIndividualProcess> candidacyProcesses) {
        Spreadsheet spreadsheet = new Spreadsheet(degree.getSigla(), this.getHeader());
        for (DegreeCandidacyForGraduatedPersonIndividualProcess process2 : candidacyProcesses) {
            Spreadsheet.Row row = spreadsheet.addRow();
            row.setCell(process2.getPersonalDetails().getName());
            row.setCell(process2.getPrecedentDegreeInformation().getDegreeAndInstitutionName());
            row.setCell(process2.getCandidacyAffinity());
            row.setCell(process2.getCandidacyDegreeNature());
            row.setCell(process2.getPrecedentDegreeInformation().getConclusionGrade());
            row.setCell(process2.getCandidacyGrade());
            if (process2.isCandidacyAccepted() || process2.isCandidacyRejected()) {
                row.setCell(BundleUtil.getString((String)"resources.EnumerationResources", (String)process2.getCandidacyState().getQualifiedName(), (String[])new String[0]));
                continue;
            }
            row.setCell("");
        }
        return spreadsheet;
    }

    private List<Object> getHeader() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.name", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.degree.and.school", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.affinity", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.degreeNature", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.mfc", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.grade", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.result", (String[])new String[0]));
        return result;
    }

    @Override
    protected List<CandidacyProcessDA.CandidacyDegreeBean> createCandidacyDegreeBeans(HttpServletRequest request) {
        DegreeCandidacyForGraduatedPersonProcess process2 = this.getProcess(request);
        ArrayList<CandidacyProcessDA.CandidacyDegreeBean> candidacyDegreeBeans = new ArrayList<CandidacyProcessDA.CandidacyDegreeBean>();
        for (DegreeCandidacyForGraduatedPersonIndividualProcess child : process2.getAcceptedDegreeCandidacyForGraduatedPersonIndividualCandidacies()) {
            candidacyDegreeBeans.add(new DegreeCandidacyForGraduatedPersonDegreeBean(child));
        }
        Collections.sort(candidacyDegreeBeans);
        return candidacyDegreeBeans;
    }

    @Override
    protected Spreadsheet buildIndividualCandidacyReport(Spreadsheet spreadsheet, IndividualCandidacyProcess individualCandidacyProcess) {
        DegreeCandidacyForGraduatedPersonIndividualProcess degreeCandidacyForGraduatedPersonProcess = (DegreeCandidacyForGraduatedPersonIndividualProcess)((Object)individualCandidacyProcess);
        Spreadsheet.Row row = spreadsheet.addRow();
        row.setCell(degreeCandidacyForGraduatedPersonProcess.getProcessCode());
        row.setCell(degreeCandidacyForGraduatedPersonProcess.getPersonalDetails().getName());
        row.setCell(degreeCandidacyForGraduatedPersonProcess.getPersonalDetails().getIdDocumentType().getLocalizedName());
        row.setCell(degreeCandidacyForGraduatedPersonProcess.getPersonalDetails().getDocumentIdNumber());
        row.setCell(degreeCandidacyForGraduatedPersonProcess.getPersonalDetails().getCountry().getCountryNationality().getContent());
        row.setCell(degreeCandidacyForGraduatedPersonProcess.getPrecedentDegreeInformation().getDegreeAndInstitutionName());
        row.setCell(degreeCandidacyForGraduatedPersonProcess.getPrecedentDegreeInformation().getDegreeDesignation());
        row.setCell(degreeCandidacyForGraduatedPersonProcess.getPrecedentDegreeInformation().getConclusionDate().toString(dateFormat));
        row.setCell(degreeCandidacyForGraduatedPersonProcess.getPrecedentDegreeInformation().getConclusionGrade());
        row.setCell(degreeCandidacyForGraduatedPersonProcess.getCandidacy().getSelectedDegree().getName());
        row.setCell(BundleUtil.getString((String)"resources.EnumerationResources", (String)individualCandidacyProcess.getCandidacyState().getQualifiedName(), (String[])new String[0]));
        row.setCell(BundleUtil.getString((String)"resources.CandidateResources", (String)(degreeCandidacyForGraduatedPersonProcess.getProcessChecked() != null && degreeCandidacyForGraduatedPersonProcess.getProcessChecked() != false ? this.MESSAGE_YES : this.MESSAGE_NO), (String[])new String[0]));
        return spreadsheet;
    }

    @Override
    protected Predicate<IndividualCandidacyProcess> getChildProcessSelectionPredicate(CandidacyProcess process2, HttpServletRequest request) {
        final Degree selectedDegree = this.getChooseDegreeBean(request).getDegree();
        if (selectedDegree == null) {
            return Predicates.alwaysTrue();
        }
        return new Predicate<IndividualCandidacyProcess>(){

            public boolean apply(IndividualCandidacyProcess process2) {
                return ((DegreeCandidacyForGraduatedPersonIndividualProcess)((Object)process2)).getCandidacy().getSelectedDegree() == selectedDegree;
            }
        };
    }

    public static class DegreeCandidacyForGraduatedPersonDegreeBean
    extends CandidacyProcessDA.CandidacyDegreeBean {
        public DegreeCandidacyForGraduatedPersonDegreeBean(DegreeCandidacyForGraduatedPersonIndividualProcess process2) {
            this.setPersonalDetails(process2.getPersonalDetails());
            this.setDegree(process2.getCandidacySelectedDegree());
            this.setState(process2.getCandidacyState());
            this.setRegistrationCreated(process2.hasRegistrationForCandidacy());
        }
    }
}

