/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.candidacy.erasmus;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.ui.struts.action.candidacy.erasmus.DegreeCourseInformationBean;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class DegreesForExecutionYearProvider
implements DataProvider {
    public Object provide(Object source, Object currentValue) {
        final Set programs = AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.MANAGE_INDIVIDUAL_CANDIDACIES, Authenticate.getUser()).collect(Collectors.toSet());
        return Collections2.filter(this.getDegrees(source), (Predicate)new Predicate<Degree>(){

            public boolean apply(Degree degree) {
                return programs.contains(degree);
            }
        });
    }

    public Set<Degree> getDegrees(Object source) {
        TreeSet<Degree> result = new TreeSet<Degree>(Degree.COMPARATOR_BY_DEGREE_TYPE_AND_NAME_AND_ID);
        DegreeCourseInformationBean chooseDegreeBean = (DegreeCourseInformationBean)source;
        for (Degree degree : Degree.readAllMatching(DegreeType.oneOf(DegreeType::isIntegratedMasterDegree, DegreeType::isBolonhaMasterDegree))) {
            if (degree.getSigla().equals("MSCIT") || degree.getSigla().equals("MCR") || degree.getSigla().equals("MEEst") || degree.getSigla().equals("MMM") || degree.getSigla().equals("MEFarm") || !this.matchesExecutionYear(degree, chooseDegreeBean.getExecutionYear())) continue;
            result.add(degree);
        }
        return result;
    }

    private boolean matchesExecutionYear(Degree degree, ExecutionYear executionYear) {
        for (ExecutionDegree executionDegree : executionYear.getExecutionDegreesSet()) {
            if (executionDegree.getDegree() != degree) continue;
            return true;
        }
        return false;
    }

    public Converter getConverter() {
        return new DomainObjectKeyConverter();
    }
}

