/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.gradeSubmission;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.MarkSheet;
import org.fenixedu.academic.domain.accessControl.TeachersWithGradesToSubmitGroup;
import org.fenixedu.academic.domain.accessControl.TeachersWithMarkSheetsToConfirmGroup;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.domain.util.email.UnitBasedSender;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission.GradesToSubmitExecutionCourseSendMailBean;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission.MarkSheetSendMailBean;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission.MarkSheetToConfirmSendMailBean;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.gradeSubmission.MarkSheetDispatchAction;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.gradeSubmission.MarkSheetSearchDispatchAction;
import org.fenixedu.academic.ui.struts.action.messaging.EmailsDA;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@Mapping(path="/markSheetSendMail", module="academicAdministration", formBean="markSheetSendMailForm", input="/gradeSubmission/searchSendMail.jsp", functionality=MarkSheetSearchDispatchAction.class)
@Forwards(value={@Forward(name="searchSendMail", path="/academicAdministration/gradeSubmission/searchSendMail.jsp")})
public class SendMailMarkSheetDispatchAction
extends MarkSheetDispatchAction {
    public ActionForward prepareSearchSendMail(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        MarkSheetSendMailBean bean = new MarkSheetSendMailBean();
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("searchSendMail");
    }

    public ActionForward prepareSearchSendMailPostBack(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        MarkSheetSendMailBean bean = (MarkSheetSendMailBean)this.getRenderedObject();
        bean.setMarkSheetToConfirmSendMailBean(null);
        bean.setGradesToSubmitExecutionCourseSendMailBean(null);
        RenderUtils.invalidateViewState();
        request.setAttribute("bean", (Object)bean);
        return mapping.getInputForward();
    }

    public ActionForward prepareSearchSendMailInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("bean", RenderUtils.getViewState().getMetaObject().getObject());
        return mapping.getInputForward();
    }

    public ActionForward searchSendMail(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        MarkSheetSendMailBean bean = (MarkSheetSendMailBean)RenderUtils.getViewState().getMetaObject().getObject();
        Collection<MarkSheet> markSheets = bean.getExecutionPeriod().getMarkSheetsToConfirm(bean.getDegreeCurricularPlan());
        Collection<ExecutionCourse> executionCourses = bean.getExecutionPeriod().getExecutionCoursesWithDegreeGradesToSubmit(bean.getDegreeCurricularPlan());
        if (!markSheets.isEmpty()) {
            HashMap<CurricularCourse, MarkSheetToConfirmSendMailBean> map = new HashMap<CurricularCourse, MarkSheetToConfirmSendMailBean>();
            for (MarkSheet markSheet : markSheets) {
                if (map.get((Object)markSheet.getCurricularCourse()) != null) continue;
                map.put(markSheet.getCurricularCourse(), new MarkSheetToConfirmSendMailBean(markSheet, true));
            }
            bean.setMarkSheetToConfirmSendMailBean(new ArrayList<MarkSheetToConfirmSendMailBean>(map.values()));
        }
        if (!executionCourses.isEmpty()) {
            ArrayList<GradesToSubmitExecutionCourseSendMailBean> executionCoursesBean = new ArrayList<GradesToSubmitExecutionCourseSendMailBean>();
            for (ExecutionCourse course : executionCourses) {
                executionCoursesBean.add(new GradesToSubmitExecutionCourseSendMailBean(bean.getDegreeCurricularPlan(), course, true));
            }
            bean.setGradesToSubmitExecutionCourseSendMailBean(executionCoursesBean);
        }
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("searchSendMail");
    }

    public ActionForward prepareMarkSheetsToConfirmSendMail(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        MarkSheetSendMailBean bean = (MarkSheetSendMailBean)RenderUtils.getViewState((String)"sendMailBean").getMetaObject().getObject();
        TeachersWithMarkSheetsToConfirmGroup teachersGroup = TeachersWithMarkSheetsToConfirmGroup.get(bean.getExecutionPeriod(), bean.getDegreeCurricularPlan());
        String message = this.getResources(request, "ACADEMIC_OFFICE_RESOURCES").getMessage("label.markSheets.to.confirm.send.mail");
        Recipient recipient = Recipient.newInstance(message, (Group)teachersGroup);
        UnitBasedSender sender = (UnitBasedSender)((Object)bean.getDegree().getAdministrativeOffice().getUnit().getUnitBasedSenderSet().iterator().next());
        return EmailsDA.sendEmail(request, (Sender)((Object)sender), recipient);
    }

    public ActionForward prepareGradesToSubmitSendMail(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        MarkSheetSendMailBean bean = (MarkSheetSendMailBean)RenderUtils.getViewState((String)"sendMailBean").getMetaObject().getObject();
        TeachersWithGradesToSubmitGroup teachersGroup = TeachersWithGradesToSubmitGroup.get(bean.getExecutionPeriod(), bean.getDegreeCurricularPlan());
        String message = this.getResources(request, "ACADEMIC_OFFICE_RESOURCES").getMessage("label.grades.to.submit.send.mail");
        Recipient recipient = Recipient.newInstance(message, (Group)teachersGroup);
        UnitBasedSender sender = (UnitBasedSender)((Object)AdministrativeOffice.readDegreeAdministrativeOffice().getUnit().getUnitBasedSenderSet().iterator().next());
        return EmailsDA.sendEmail(request, (Sender)((Object)sender), recipient);
    }
}

