/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.spring.controller.teacher.professorship;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Degree_Base;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.ui.spring.controller.teacher.professorship.CreateProfessorshipBean;
import org.fenixedu.academic.ui.spring.controller.teacher.professorship.ProfessorshipService$callable$changeResponsibleFor;
import org.fenixedu.academic.ui.spring.controller.teacher.professorship.ProfessorshipService$callable$deleteProfessorship;
import org.fenixedu.bennu.core.domain.User;
import org.springframework.stereotype.Service;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Service
public class ProfessorshipService {
    public static final Advice advice$changeResponsibleFor = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$deleteProfessorship = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    public List<Professorship> getProfessorships(User user, ExecutionSemester period) {
        Teacher teacher = user.getPerson().getTeacher();
        if (teacher == null) {
            return ImmutableList.builder().build();
        }
        return teacher.getProfessorships(period).stream().collect(Collectors.toList());
    }

    public String getDegreeAcronyms(Professorship professorship, String separator) {
        return professorship.getExecutionCourse().getExecutionDegrees().stream().map(ExecutionDegree::getDegree).map(Degree_Base::getSigla).distinct().collect(Collectors.joining(separator));
    }

    public Boolean changeResponsibleFor(Professorship professorship, Boolean bl) {
        return (Boolean)advice$changeResponsibleFor.perform((Callable)new ProfessorshipService$callable$changeResponsibleFor(this, professorship, bl));
    }

    static /* synthetic */ Boolean advised$changeResponsibleFor(ProfessorshipService this_, Professorship professorship, Boolean responsibleFor) {
        if (responsibleFor != null && !professorship.getResponsibleFor().equals(responsibleFor)) {
            professorship.setResponsibleFor(responsibleFor);
        }
        return professorship.getResponsibleFor();
    }

    public List<ExecutionDegree> getDegrees(ExecutionSemester period) {
        if (period == null) {
            return ImmutableList.builder().build();
        }
        return period.getExecutionYear().getExecutionDegreesSet().stream().sorted(ExecutionDegree.EXECUTION_DEGREE_COMPARATOR_BY_DEGREE_TYPE_AND_DEGREE_NAME).distinct().collect(Collectors.toList());
    }

    public List<ExecutionCourse> getCourses(ExecutionDegree executionDegree, ExecutionSemester period) {
        if (executionDegree == null) {
            return ImmutableList.builder().build();
        }
        return executionDegree.getDegreeCurricularPlan().getExecutionCoursesByExecutionPeriod(period).stream().distinct().sorted(ExecutionCourse.EXECUTION_COURSE_NAME_COMPARATOR).collect(Collectors.toList());
    }

    public Professorship create(CreateProfessorshipBean bean) throws DomainException {
        return Professorship.create(bean.getResponsibleFor(), bean.getCourse(), bean.getTeacher());
    }

    public void deleteProfessorship(Professorship professorship) throws DomainException {
        Object object = advice$deleteProfessorship.perform((Callable)new ProfessorshipService$callable$deleteProfessorship(this, professorship));
    }

    static /* synthetic */ void advised$deleteProfessorship(ProfessorshipService this_, Professorship professorship) throws DomainException {
        professorship.delete();
    }
}

