/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.strategy.groupEnrolment.strategys;

import org.fenixedu.academic.domain.Grouping;
import org.fenixedu.academic.service.strategy.groupEnrolment.strategys.AtomicGroupEnrolmentStrategy;
import org.fenixedu.academic.service.strategy.groupEnrolment.strategys.GroupEnrolmentStrategy;
import org.fenixedu.academic.service.strategy.groupEnrolment.strategys.IGroupEnrolmentStrategy;
import org.fenixedu.academic.service.strategy.groupEnrolment.strategys.IGroupEnrolmentStrategyFactory;
import org.fenixedu.academic.service.strategy.groupEnrolment.strategys.IndividualGroupEnrolmentStrategy;
import org.fenixedu.academic.util.EnrolmentGroupPolicyType;

public class GroupEnrolmentStrategyFactory
implements IGroupEnrolmentStrategyFactory {
    private static GroupEnrolmentStrategyFactory instance = null;

    private GroupEnrolmentStrategyFactory() {
    }

    public static synchronized GroupEnrolmentStrategyFactory getInstance() {
        if (instance == null) {
            instance = new GroupEnrolmentStrategyFactory();
        }
        return instance;
    }

    public static synchronized void resetInstance() {
        if (instance != null) {
            instance = null;
        }
    }

    @Override
    public IGroupEnrolmentStrategy getGroupEnrolmentStrategyInstance(Grouping grouping) {
        GroupEnrolmentStrategy strategyInstance = null;
        EnrolmentGroupPolicyType policy = grouping.getEnrolmentPolicy();
        if (policy == null) {
            throw new IllegalArgumentException("Must initialize Group Properties!");
        }
        if (policy.equals(new EnrolmentGroupPolicyType(1))) {
            strategyInstance = new AtomicGroupEnrolmentStrategy();
        } else if (policy.equals(new EnrolmentGroupPolicyType(2))) {
            strategyInstance = new IndividualGroupEnrolmentStrategy();
        }
        return strategyInstance;
    }
}

