/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.filter;

import java.util.TreeSet;
import org.fenixedu.academic.domain.Coordinator;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.service.filter.coordinator.CoordinatorAuthorizationFilter;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.fenixframework.FenixFramework;

public class ExecutionCourseCoordinatorAuthorizationFilter
extends CoordinatorAuthorizationFilter {
    public static final ExecutionCourseCoordinatorAuthorizationFilter instance = new ExecutionCourseCoordinatorAuthorizationFilter();

    protected ExecutionYear getSpecificExecutionYear(String executionCourseID) {
        ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseID);
        return executionCourse == null ? null : executionCourse.getExecutionYear();
    }

    public void execute(String executionCourseID) throws NotAuthorizedException {
        Person person = Authenticate.getUser().getPerson();
        if (!RoleType.COORDINATOR.isMember(person.getUser())) {
            this.deny();
        }
        TreeSet<Coordinator> coordinators = new TreeSet<Coordinator>(new CoordinatorAuthorizationFilter.CoordinatorByExecutionDegreeComparator());
        coordinators.addAll(person.getCoordinatorsSet());
        if (coordinators.isEmpty()) {
            this.deny();
        }
        ExecutionYear executionYear = this.getSpecificExecutionYear(executionCourseID);
        Coordinator coordinator = (Coordinator)((Object)coordinators.first());
        ExecutionYear coordinatorExecutionYear = coordinator.getExecutionDegree().getExecutionYear();
        if (executionYear == null || coordinatorExecutionYear.compareTo(executionYear) < 0) {
            this.deny();
        }
    }

    public void deny() throws NotAuthorizedException {
        throw new NotAuthorizedException();
    }
}

