/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.student;

import java.io.Serializable;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.StudentDataShareAuthorization;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;

public class RegistrationWithStateForExecutionYearBean
implements Serializable {
    private final Registration registration;
    private final ExecutionYear executionYear;
    private RegistrationStateType registrationState;

    public RegistrationWithStateForExecutionYearBean(Registration registration, ExecutionYear executionYear) {
        this.registration = registration;
        this.executionYear = executionYear;
    }

    public RegistrationWithStateForExecutionYearBean(Registration registration, RegistrationStateType registrationState, ExecutionYear executionYear) {
        this.registration = registration;
        this.registrationState = registrationState;
        this.executionYear = executionYear;
    }

    public RegistrationStateType getActiveStateType() {
        return this.registrationState != null ? this.registrationState : this.getRegistration().getLastRegistrationState(this.getExecutionYear()).getStateType();
    }

    private ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public Registration getRegistration() {
        return this.registration;
    }

    public Student getStudent() {
        return this.getRegistration().getStudent();
    }

    public String getPersonalDataAuthorization() {
        StudentDataShareAuthorization dataAccess = this.getStudent().getPersonalDataAuthorizationAt(this.getExecutionYear().getEndDateYearMonthDay().toDateTimeAtMidnight());
        return dataAccess != null ? dataAccess.getAuthorizationChoice().getDescription() : "";
    }
}

