/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.resourceAllocationManager;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.CurricularYearList;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.OccupationPeriod;
import org.fenixedu.academic.domain.OccupationPeriodReference;
import org.fenixedu.academic.domain.OccupationPeriodType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.resourceAllocationManager.OccupationPeriodBean$callable$create;
import org.fenixedu.academic.dto.resourceAllocationManager.OccupationPeriodBean$callable$deletePeriod;
import org.fenixedu.academic.dto.resourceAllocationManager.OccupationPeriodBean$callable$duplicate;
import org.fenixedu.academic.dto.resourceAllocationManager.OccupationPeriodBean$callable$updateCourses;
import org.fenixedu.academic.dto.resourceAllocationManager.OccupationPeriodBean$callable$updateDates;
import org.fenixedu.academic.util.date.IntervalTools;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class OccupationPeriodBean
implements Serializable,
Comparable<OccupationPeriodBean> {
    private static final long serialVersionUID = -9196229454898126127L;
    private List<Interval> intervals = new ArrayList<Interval>();
    private OccupationPeriodType occupationPeriodType;
    private OccupationPeriod occupationPeriod;
    private Integer semester;
    private List<OccupationPeriodReference> references = new ArrayList<OccupationPeriodReference>();
    private final int id;
    private static final Splitter SPLITTER;
    private static final DateTimeFormatter FORMATTER;
    public static final Advice advice$updateDates;
    public static final Advice advice$updateCourses;
    public static final Advice advice$deletePeriod;
    public static final Advice advice$create;
    public static final Advice advice$duplicate;

    public OccupationPeriodBean(int id) {
        this.id = id;
        this.semester = ExecutionSemester.readActualExecutionSemester().getSemester();
        this.occupationPeriodType = OccupationPeriodType.LESSONS;
        this.intervals = Lists.newArrayList((Object[])new Interval[]{new Interval((ReadableInstant)new DateTime(), (ReadableInstant)new DateTime().plusDays(1))});
    }

    public OccupationPeriodBean(OccupationPeriodReference reference, int id) {
        this.occupationPeriod = reference.getOccupationPeriod();
        this.reloadIntervals();
        this.semester = reference.getSemester();
        this.occupationPeriodType = reference.getPeriodType();
        this.id = id;
    }

    private void reloadIntervals() {
        this.intervals = this.occupationPeriod.getIntervals();
    }

    public int getId() {
        return this.id;
    }

    public List<Interval> getIntervals() {
        return this.intervals;
    }

    public void setIntervals(List<Interval> intervals) {
        this.intervals = intervals;
    }

    public OccupationPeriodType getOccupationPeriodType() {
        return this.occupationPeriodType;
    }

    public void setOccupationPeriodType(OccupationPeriodType occupationPeriodType) {
        this.occupationPeriodType = occupationPeriodType;
    }

    public OccupationPeriod getOccupationPeriod() {
        return this.occupationPeriod;
    }

    public void setOccupationPeriod(OccupationPeriod occupationPeriod) {
        this.occupationPeriod = occupationPeriod;
    }

    public List<OccupationPeriodReference> getReferences() {
        return this.references;
    }

    public void setReferences(List<OccupationPeriodReference> references) {
        this.references = references;
    }

    public void addReference(OccupationPeriodReference reference) {
        this.references.add(reference);
    }

    public Integer getSemester() {
        return this.semester;
    }

    public void setSemester(Integer semester) {
        this.semester = semester;
    }

    public Collection<Integer> getPossibleSemesters() {
        return Lists.newArrayList((Object[])new Integer[]{1, 2});
    }

    public boolean getNewObject() {
        return this.occupationPeriod == null;
    }

    public String getDatesString() {
        if (this.intervals.size() == 0 || this.occupationPeriod == null) {
            return BundleUtil.getString((String)"resources.ResourceAllocationManagerResources", (String)"label.periods.no.dates", (String[])new String[0]);
        }
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"dd MMM").withLocale(I18N.getLocale());
        StringBuilder builder = new StringBuilder();
        for (Interval interval : this.getIntervals()) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(formatter.print((ReadableInstant)interval.getStart()));
            builder.append(" - ");
            builder.append(formatter.print((ReadableInstant)interval.getEnd()));
        }
        return builder.toString();
    }

    public String getName() {
        if (this.occupationPeriod == null) {
            return "Novo per\u00edodo";
        }
        return "Per\u00edodo de " + this.occupationPeriodType.getLocalizedName() + (this.semester == null ? "" : " - " + this.semester + "\u00ba Semestre");
    }

    @Override
    public int compareTo(OccupationPeriodBean other) {
        return ComparisonChain.start().compare(this.getOccupationPeriod().getPeriodInterval().getStartMillis(), other.getOccupationPeriod().getPeriodInterval().getStartMillis()).compare(this.getReferences().size(), this.getReferences().size()).result();
    }

    public void updateDates(String string) {
        Object object = advice$updateDates.perform((Callable)new OccupationPeriodBean$callable$updateDates(this, string));
    }

    static /* synthetic */ void advised$updateDates(OccupationPeriodBean this_, String parameter) {
        Iterable<Interval> intervals = this_.extractIntervals(parameter);
        this_.consolidateReferences();
        if (this_.occupationPeriod.getExecutionDegreesSet().size() != this_.getReferences().size()) {
            this_.occupationPeriod = new OccupationPeriod(intervals.iterator());
            this_.consolidateReferences();
        } else {
            this_.occupationPeriod.editDates(intervals.iterator());
        }
        this_.reloadIntervals();
    }

    public void updateCourses(String string) {
        Object object = advice$updateCourses.perform((Callable)new OccupationPeriodBean$callable$updateCourses(this, string));
    }

    static /* synthetic */ void advised$updateCourses(OccupationPeriodBean this_, String parameter) {
        Map<ExecutionDegree, CurricularYearList> degreeMap = this_.extractCourses(parameter);
        Iterator<OccupationPeriodReference> references = this_.getReferences().iterator();
        while (references.hasNext()) {
            OccupationPeriodReference reference = references.next();
            if (degreeMap.containsKey(reference.getExecutionDegree())) continue;
            reference.delete();
            references.remove();
        }
        for (Map.Entry<ExecutionDegree, CurricularYearList> entry : degreeMap.entrySet()) {
            OccupationPeriodReference reference = null;
            for (OccupationPeriodReference ref : this_.getReferences()) {
                if (!ref.getExecutionDegree().equals(entry.getKey())) continue;
                reference = ref;
                break;
            }
            if (reference == null) {
                this_.references.add(new OccupationPeriodReference(this_.occupationPeriod, entry.getKey(), this_.occupationPeriodType, this_.semester, entry.getValue()));
                continue;
            }
            reference.setOccupationPeriod(this_.occupationPeriod);
            reference.setPeriodType(this_.occupationPeriodType);
            reference.setSemester(this_.semester);
            reference.setCurricularYears(entry.getValue());
        }
    }

    public void deletePeriod() {
        Object object = advice$deletePeriod.perform((Callable)new OccupationPeriodBean$callable$deletePeriod(this));
    }

    static /* synthetic */ void advised$deletePeriod(OccupationPeriodBean this_) {
        for (OccupationPeriodReference ref : this_.getReferences()) {
            ref.delete();
        }
    }

    public void create(String string, String string2) {
        Object object = advice$create.perform((Callable)new OccupationPeriodBean$callable$create(this, string, string2));
    }

    static /* synthetic */ void advised$create(OccupationPeriodBean this_, String intervalsStr, String courses) {
        Iterable<Interval> intervals = this_.extractIntervals(intervalsStr);
        this_.occupationPeriod = new OccupationPeriod(intervals.iterator());
        this_.updateCourses(courses);
        this_.reloadIntervals();
    }

    private void consolidateReferences() {
        Preconditions.checkNotNull((Object)((Object)this.occupationPeriod));
        for (OccupationPeriodReference reference : this.references) {
            reference.setOccupationPeriod(this.occupationPeriod);
        }
    }

    private Iterable<Interval> extractIntervals(String parameter) {
        Iterable intervals = Iterables.transform((Iterable)SPLITTER.split((CharSequence)parameter), (Function)new Function<String, Interval>(){

            public Interval apply(String string) {
                String[] dates = string.split(",");
                if (dates.length != 2) {
                    throw new RuntimeException("Error while recreating intervals, '" + string + "' cannot be parsed!");
                }
                LocalDate start = FORMATTER.parseDateTime(dates[0]).toLocalDate();
                LocalDate end = FORMATTER.parseDateTime(dates[1]).toLocalDate();
                return IntervalTools.getInterval(start, end);
            }
        });
        Iterator iter = intervals.iterator();
        Interval last = (Interval)iter.next();
        while (iter.hasNext()) {
            Interval current = (Interval)iter.next();
            if (!current.isAfter((ReadableInterval)last)) {
                throw new DomainException("label.occupation.period.invalid.dates", new String[0]);
            }
            last = current;
        }
        return intervals;
    }

    private Map<ExecutionDegree, CurricularYearList> extractCourses(String parameter) {
        HashMap<ExecutionDegree, CurricularYearList> degreeMap = new HashMap<ExecutionDegree, CurricularYearList>();
        for (String string : SPLITTER.split((CharSequence)parameter)) {
            String[] parts = string.split(":");
            if (parts.length != 2) {
                throw new RuntimeException("Error while recreating execution degree, '" + string + "' cannot be parsed!");
            }
            String oid = parts[0];
            ExecutionDegree degree = (ExecutionDegree)FenixFramework.getDomainObject((String)oid);
            degreeMap.put(degree, CurricularYearList.internalize(parts[1]));
        }
        return degreeMap;
    }

    public OccupationPeriodBean duplicate(int n, OccupationPeriodType occupationPeriodType) {
        return (OccupationPeriodBean)advice$duplicate.perform((Callable)new OccupationPeriodBean$callable$duplicate(this, n, occupationPeriodType));
    }

    static /* synthetic */ OccupationPeriodBean advised$duplicate(OccupationPeriodBean this_, int newId, OccupationPeriodType newPeriodType) {
        if (newPeriodType == null) {
            throw new DomainException("label.occupation.period.duplicate.message", new String[0]);
        }
        OccupationPeriodBean newBean = new OccupationPeriodBean(newId);
        newBean.setOccupationPeriodType(newPeriodType);
        newBean.setIntervals(this_.intervals);
        newBean.setOccupationPeriod(this_.occupationPeriod);
        newBean.setSemester(this_.semester);
        for (OccupationPeriodReference reference : this_.references) {
            newBean.addReference(new OccupationPeriodReference(reference.getOccupationPeriod(), reference.getExecutionDegree(), newPeriodType, this_.semester, reference.getCurricularYears()));
        }
        return newBean;
    }

    static {
        advice$updateDates = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$updateCourses = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$deletePeriod = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$duplicate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        SPLITTER = Splitter.on((char)';').trimResults().omitEmptyStrings();
        FORMATTER = DateTimeFormat.forPattern((String)"dd/MM/yyyy");
    }
}

