/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.administrativeOffice.externalUnits;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.organizationalStructure.PartyTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.dto.LinkObject;
import org.fenixedu.academic.dto.administrativeOffice.externalUnits.AbstractExternalUnitResultBean;

public class ExternalUnitResultBean
extends AbstractExternalUnitResultBean {
    private Unit unit;

    public ExternalUnitResultBean(Unit unit, PartyTypeEnum parentUnitType) {
        this.setUnit(unit);
        this.setParentUnitType(parentUnitType);
    }

    public ExternalUnitResultBean(Unit unit) {
        this(unit, null);
    }

    @Override
    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    @Override
    public PartyTypeEnum getType() {
        return this.getUnit().getType();
    }

    @Override
    public List<LinkObject> getFullPath() {
        ArrayList<LinkObject> result = new ArrayList<LinkObject>();
        for (Unit unit : this.searchFullPath()) {
            LinkObject linkObject = new LinkObject();
            linkObject.setId(unit.getExternalId());
            linkObject.setLabel(unit.getName());
            linkObject.setMethod("viewUnit");
            result.add(linkObject);
        }
        return result;
    }

    @Override
    public String getName() {
        return this.getUnit().getName();
    }

    @Override
    public String getNumberOfUniversities() {
        return this.getUnit().isCountryUnit() ? String.valueOf(this.getUnit().getSubUnits(PartyTypeEnum.UNIVERSITY).size()) : super.getNumberOfUniversities();
    }

    @Override
    public String getNumberOfSchools() {
        return this.getUnit().isCountryUnit() || this.getUnit().isUniversityUnit() ? String.valueOf(this.countNumberOfUnitsWithType(this.getUnit(), PartyTypeEnum.SCHOOL)) : super.getNumberOfSchools();
    }

    @Override
    public String getNumberOfDepartments() {
        return this.getUnit().isUniversityUnit() || this.getUnit().isSchoolUnit() ? String.valueOf(this.countNumberOfUnitsWithType(this.getUnit(), PartyTypeEnum.DEPARTMENT)) : super.getNumberOfDepartments();
    }

    private int countNumberOfUnitsWithType(Unit unit, PartyTypeEnum unitTypeToSearch) {
        int result = unit.getSubUnits(unitTypeToSearch).size();
        switch (unit.getType()) {
            case COUNTRY: {
                result += this.countNumberOfUnitsWithType(unit, PartyTypeEnum.UNIVERSITY, unitTypeToSearch);
                result += this.countNumberOfUnitsWithType(unit, PartyTypeEnum.SCHOOL, unitTypeToSearch);
                break;
            }
            case UNIVERSITY: {
                result += this.countNumberOfUnitsWithType(unit, PartyTypeEnum.SCHOOL, unitTypeToSearch);
                result += this.countNumberOfUnitsWithType(unit, PartyTypeEnum.DEPARTMENT, unitTypeToSearch);
                break;
            }
            case SCHOOL: {
                result += this.countNumberOfUnitsWithType(unit, PartyTypeEnum.DEPARTMENT, unitTypeToSearch);
                break;
            }
        }
        return result;
    }

    private int countNumberOfUnitsWithType(Unit unit, PartyTypeEnum parentUnitType, PartyTypeEnum unitTypeToSearch) {
        int result = 0;
        if (unitTypeToSearch != parentUnitType) {
            for (Unit each : unit.getSubUnits(parentUnitType)) {
                result += this.countNumberOfUnitsWithType(each, unitTypeToSearch);
            }
        }
        return result;
    }

    @Override
    public String getNumberOfExternalCurricularCourses() {
        return !this.getUnit().isCountryUnit() ? String.valueOf(this.countNumberOfExternalCurricularCourses(this.getUnit())) : super.getNumberOfExternalCurricularCourses();
    }

    private int countNumberOfExternalCurricularCourses(Unit unit) {
        int result = unit.getExternalCurricularCoursesSet().size();
        switch (unit.getType()) {
            case COUNTRY: {
                result += this.countNumberOfExternalCurricularCourses(unit, PartyTypeEnum.UNIVERSITY);
                result += this.countNumberOfExternalCurricularCourses(unit, PartyTypeEnum.SCHOOL);
                break;
            }
            case UNIVERSITY: {
                result += this.countNumberOfExternalCurricularCourses(unit, PartyTypeEnum.SCHOOL);
                result += this.countNumberOfExternalCurricularCourses(unit, PartyTypeEnum.DEPARTMENT);
                break;
            }
            case SCHOOL: {
                result += this.countNumberOfExternalCurricularCourses(unit, PartyTypeEnum.DEPARTMENT);
                break;
            }
        }
        return result;
    }

    private int countNumberOfExternalCurricularCourses(Unit unit, PartyTypeEnum parentUnitType) {
        int result = 0;
        for (Unit each : unit.getSubUnits(parentUnitType)) {
            result += this.countNumberOfExternalCurricularCourses(each);
        }
        return result;
    }

    private static List<Unit> getChildUnitsFor(Unit unit, PartyTypeEnum type) {
        ArrayList<Unit> result = new ArrayList<Unit>();
        ExternalUnitResultBean.getChildsWithType(result, unit, type);
        return result;
    }

    private static void getChildsWithType(List<Unit> result, Unit unit, PartyTypeEnum subUnitTypeToSearch) {
        result.addAll(unit.getSubUnits(subUnitTypeToSearch));
        switch (unit.getType()) {
            case COUNTRY: {
                ExternalUnitResultBean.addSubUnits(result, unit, PartyTypeEnum.UNIVERSITY, subUnitTypeToSearch);
                ExternalUnitResultBean.addSubUnits(result, unit, PartyTypeEnum.SCHOOL, subUnitTypeToSearch);
                break;
            }
            case UNIVERSITY: {
                ExternalUnitResultBean.addSubUnits(result, unit, PartyTypeEnum.SCHOOL, subUnitTypeToSearch);
                ExternalUnitResultBean.addSubUnits(result, unit, PartyTypeEnum.DEPARTMENT, subUnitTypeToSearch);
                break;
            }
            case SCHOOL: {
                ExternalUnitResultBean.addSubUnits(result, unit, PartyTypeEnum.DEPARTMENT, subUnitTypeToSearch);
                break;
            }
        }
    }

    private static void addSubUnits(List<Unit> result, Unit unit, PartyTypeEnum parentUnitType, PartyTypeEnum subUnitType) {
        if (subUnitType != parentUnitType) {
            for (Unit each : unit.getSubUnits(parentUnitType)) {
                ExternalUnitResultBean.getChildsWithType(result, each, subUnitType);
            }
        }
    }

    public static List<ExternalUnitResultBean> buildFrom(Unit unit, PartyTypeEnum type) {
        ArrayList<ExternalUnitResultBean> result = new ArrayList<ExternalUnitResultBean>();
        for (Unit each : ExternalUnitResultBean.getChildUnitsFor(unit, type)) {
            result.add(new ExternalUnitResultBean(each, unit.getType()));
        }
        return result;
    }
}

