/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.curriculum.EnrollmentCondition;
import org.fenixedu.academic.domain.curriculum.EnrollmentState;
import org.fenixedu.academic.dto.InfoCurricularCourse;
import org.fenixedu.academic.dto.InfoEnrolmentEvaluation;
import org.fenixedu.academic.dto.InfoEnrolmentEvaluationWithResponsibleForGrade;
import org.fenixedu.academic.dto.InfoExecutionPeriod;
import org.fenixedu.academic.dto.InfoObject;
import org.fenixedu.academic.dto.InfoStudentCurricularPlan;

public class InfoEnrolment
extends InfoObject {
    private Enrolment enrolment;

    protected InfoEnrolment() {
    }

    protected InfoEnrolment(Enrolment enrolment) {
        this.enrolment = enrolment;
    }

    public static InfoEnrolment newInfoFromDomain(Enrolment enrolment) {
        return enrolment != null ? new InfoEnrolment(enrolment) : null;
    }

    public Enrolment getEnrolment() {
        return this.enrolment;
    }

    @Override
    public String getExternalId() {
        return this.enrolment.getExternalId();
    }

    @Override
    public void setExternalId(String integer) {
        throw new Error("Method should not be called!");
    }

    public String getEnrollmentTypeResourceKey() {
        return this.enrolment.getEnrolmentTypeName();
    }

    public InfoCurricularCourse getInfoCurricularCourse() {
        return InfoCurricularCourse.newInfoFromDomain(this.enrolment.getCurricularCourse());
    }

    public InfoExecutionPeriod getInfoExecutionPeriod() {
        return InfoExecutionPeriod.newInfoFromDomain(this.enrolment.getExecutionPeriod());
    }

    public InfoStudentCurricularPlan getInfoStudentCurricularPlan() {
        return InfoStudentCurricularPlan.newInfoFromDomain(this.enrolment.getStudentCurricularPlan());
    }

    public EnrollmentState getEnrollmentState() {
        return this.enrolment.getEnrollmentState();
    }

    public List<InfoEnrolmentEvaluation> getInfoEvaluations() {
        ArrayList<InfoEnrolmentEvaluation> result = new ArrayList<InfoEnrolmentEvaluation>(this.enrolment.getEvaluationsSet().size());
        for (EnrolmentEvaluation enrolmentEvaluation : this.enrolment.getEvaluationsSet()) {
            result.add(InfoEnrolmentEvaluationWithResponsibleForGrade.newInfoFromDomain(enrolmentEvaluation));
        }
        return result;
    }

    public InfoEnrolmentEvaluation getInfoEnrolmentEvaluation() {
        return InfoEnrolmentEvaluationWithResponsibleForGrade.newInfoFromDomain(this.enrolment.getFinalEnrolmentEvaluation());
    }

    public Date getCreationDate() {
        return this.enrolment.getCreationDateDateTime().toDate();
    }

    public EnrollmentCondition getCondition() {
        return this.enrolment.getEnrolmentCondition();
    }

    public String getGradeValue() {
        return this.enrolment.getGradeValue();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof InfoEnrolment ? this.enrolment == ((InfoEnrolment)obj).getEnrolment() : false;
    }

    public String toString() {
        String result = "[" + this.getClass().getName() + "; ";
        result = result + "infoStudentCurricularPlan = " + this.getInfoStudentCurricularPlan() + "; ";
        result = result + "infoExecutionPeriod = " + this.getInfoExecutionPeriod() + "; ";
        result = result + "state = " + (Object)((Object)this.getEnrollmentState()) + "; ";
        result = result + "infoCurricularCourse = " + this.getInfoCurricularCourse() + "; ";
        result = result + "season = " + this.enrolment.getEvaluationSeason().getName().getContent() + "; ";
        result = result + "infoEvaluations = " + this.getInfoEvaluations() + "]\n";
        return result;
    }
}

