/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.curriculum;

import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.RegistrationConclusionProcess_Base;
import org.fenixedu.academic.dto.student.RegistrationConclusionBean;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;
import org.joda.time.LocalDate;

public class RegistrationConclusionProcess
extends RegistrationConclusionProcess_Base {
    private RegistrationConclusionProcess(RegistrationConclusionBean bean) {
        super.setRootDomainObject(Bennu.getInstance());
        Registration registration = bean.getRegistration();
        ExecutionYear conclusionYear = bean.getConclusionYear();
        String[] args = new String[]{};
        if (registration == null) {
            throw new DomainException("error.RegistrationConclusionProcess.argument.must.not.be.null", args);
        }
        String[] args1 = new String[]{};
        if (conclusionYear == null) {
            throw new DomainException("error.RegistrationConclusionProcess.conclusionYear.cannot.be.null", args1);
        }
        super.setRegistration(registration);
        super.setConclusionYear(conclusionYear);
        this.addVersions(bean);
    }

    public void update(RegistrationConclusionBean bean) {
        if (!bean.isConclusionProcessed()) {
            throw new DomainException("error.ConclusionProcess.is.not.concluded", new String[0]);
        }
        this.addVersions(bean);
    }

    public final void update(Person responsible, Grade finalGrade, Grade rawGrade, Grade descriptiveGrade, LocalDate conclusionDate, String notes) {
        this.addVersions(new RegistrationConclusionBean(this.getRegistration(), this.getGroup()));
        this.getLastVersion().update(responsible, finalGrade, rawGrade, descriptiveGrade, conclusionDate, notes);
    }

    protected void addSpecificVersionInfo() {
    }

    public void setRootDomainObject(Bennu rootDomainObject) {
        throw new DomainException("error.ConclusionProcess.method.not.allowed", new String[0]);
    }

    public void setRegistration(Registration registration) {
        throw new DomainException("error.ConclusionProcess.method.not.allowed", new String[0]);
    }

    public void setConclusionYear(ExecutionYear conclusionYear) {
        throw new DomainException("error.ConclusionProcess.method.not.allowed", new String[0]);
    }

    public LocalizedString getName() {
        return this.getDegree().getDegreeType().getName();
    }
}

