/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.space;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.SortedSet;
import org.fenixedu.academic.domain.CourseLoad;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.FrequencyType;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.OccupationPeriod;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.space.LessonSpaceOccupation_Base;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.SpacePredicates;
import org.fenixedu.academic.util.DiaSemana;
import org.fenixedu.academic.util.HourMinuteSecond;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.YearMonthDay;

public class LessonSpaceOccupation
extends LessonSpaceOccupation_Base {
    public LessonSpaceOccupation(Space allocatableSpace, Lesson lesson) {
        if (lesson != null && lesson.getLessonSpaceOccupation() != null) {
            throw new DomainException("error.lesson.already.has.lessonSpaceOccupation", new String[0]);
        }
        this.setLesson(lesson);
        if (this.getPeriod() == null) {
            throw new DomainException("error.LessonSpaceOccupation.empty.period", new String[0]);
        }
        if (allocatableSpace != null && !allocatableSpace.isFree((List)Lists.newArrayList(lesson.getAllLessonIntervalsWithoutInstanceDates()))) {
            throw new DomainException("error.LessonSpaceOccupation.room.is.not.free", allocatableSpace.getName(), this.getPeriod().getStartYearMonthDay().toString("dd-MM-yyy"), this.getPeriod().getLastOccupationPeriodOfNestedPeriods().getEndYearMonthDay().toString("dd-MM-yyy"));
        }
        this.setResource(allocatableSpace);
    }

    public void edit(Space allocatableSpace) {
        AccessControl.check(this, SpacePredicates.checkPermissionsToManageLessonSpaceOccupations);
        if (this.getPeriod() == null) {
            throw new DomainException("error.LessonSpaceOccupation.empty.period", new String[0]);
        }
        SortedSet<Interval> allLessonIntervalsWithoutInstanceDates = this.getLesson().getAllLessonIntervalsWithoutInstanceDates();
        if (allocatableSpace != null && !allocatableSpace.isFree((List)Lists.newArrayList(allLessonIntervalsWithoutInstanceDates))) {
            throw new DomainException("error.LessonSpaceOccupation.room.is.not.free", allocatableSpace.getName(), this.getPeriod().getStartYearMonthDay().toString("dd-MM-yyy"), this.getPeriod().getLastOccupationPeriodOfNestedPeriods().getEndYearMonthDay().toString("dd-MM-yyy"));
        }
        this.setResource(allocatableSpace);
    }

    public void delete() {
        AccessControl.check(this, SpacePredicates.checkPermissionsToDeleteLessonSpaceOccupations);
        super.setLesson(null);
        super.delete();
    }

    public OccupationPeriod getPeriod() {
        return this.getLesson() == null ? null : this.getLesson().getPeriod();
    }

    protected boolean intersects(YearMonthDay startDate, YearMonthDay endDate) {
        return this.getPeriod() != null && this.getPeriod().nestedOccupationPeriodsIntersectDates(startDate, endDate);
    }

    public List<Interval> getEventSpaceOccupationIntervals(YearMonthDay startDateToSearch, YearMonthDay endDateToSearch) {
        return Lists.newArrayList(this.getLesson().getAllLessonIntervalsWithoutInstanceDates());
    }

    public void setLesson(Lesson lesson) {
        if (lesson == null) {
            throw new DomainException("error.LessonSpaceOccupation.empty.lesson", new String[0]);
        }
        super.setLesson(lesson);
    }

    public FrequencyType getFrequency() {
        return this.getLesson().getFrequency();
    }

    public Group getAccessGroup() {
        return this.getSpace().getOccupationsGroupWithChainOfResponsability();
    }

    public YearMonthDay getBeginDate() {
        return this.getPeriod() != null ? this.getPeriod().getStartYearMonthDay() : null;
    }

    public YearMonthDay getEndDate() {
        return this.getPeriod() != null ? this.getPeriod().getLastOccupationPeriodOfNestedPeriods().getEndYearMonthDay() : null;
    }

    public DiaSemana getDayOfWeek() {
        return this.getLesson().getDiaSemana();
    }

    public HourMinuteSecond getStartTimeDateHourMinuteSecond() {
        return this.getLesson().getBeginHourMinuteSecond();
    }

    public HourMinuteSecond getEndTimeDateHourMinuteSecond() {
        return this.getLesson().getEndHourMinuteSecond();
    }

    public Boolean getDailyFrequencyMarkSaturday() {
        return null;
    }

    public Boolean getDailyFrequencyMarkSunday() {
        return null;
    }

    public boolean isOccupiedByExecutionCourse(ExecutionCourse executionCourse, DateTime start, DateTime end) {
        Lesson lesson = this.getLesson();
        if (lesson.getExecutionCourse() == executionCourse) {
            List<Interval> intervals = this.getEventSpaceOccupationIntervals(start.toYearMonthDay(), end.toYearMonthDay().plusDays(1));
            for (Interval interval : intervals) {
                if (!start.isBefore((ReadableInstant)interval.getEnd()) || !end.isAfter((ReadableInstant)interval.getStart())) continue;
                return true;
            }
        }
        return false;
    }

    public String getUrl() {
        Lesson li = this.getLesson();
        if (li == null) {
            return "";
        }
        return li.getShift().getExecutionCourse().getSiteUrl();
    }

    public String getInfo() {
        String asd = ((CourseLoad)((Object)this.getLesson().getShift().getCourseLoadsSet().iterator().next())).getType().getFullNameTipoAula();
        for (YearMonthDay ymd : this.getLesson().getAllLessonDates()) {
            asd = asd + "\n" + ymd.toString();
        }
        return asd;
    }

    public String getPresentationString() {
        return this.getLesson().getShift().getExecutionCourse().getSigla();
    }

    protected boolean overlaps(Interval interval) {
        return this.getLesson().overlaps(interval);
    }
}

