/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.reports;

import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.SearchPhdIndividualProgramProcessBean;
import org.fenixedu.academic.domain.phd.reports.PhdReport;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.YearMonthDay;

public class PhdIndividualProgramProcessesReport
extends PhdReport {
    public PhdIndividualProgramProcessesReport(HSSFWorkbook workbook) {
        super(workbook);
    }

    public HSSFSheet build(SearchPhdIndividualProgramProcessBean bean) {
        HSSFSheet sheet = this.workbook.createSheet("Processos de doutoramento");
        this.setHeaders(sheet);
        List<PhdIndividualProgramProcess> processes = PhdIndividualProgramProcess.search(bean.getExecutionYear(), bean.getPredicates());
        this.setHeaders(sheet);
        int i = 1;
        for (PhdIndividualProgramProcess process2 : processes) {
            if (!process2.isAllowedToManageProcess(Authenticate.getUser())) continue;
            HSSFRow row = sheet.createRow(i);
            this.fillRow(process2, row);
            ++i;
        }
        return sheet;
    }

    private void fillRow(PhdIndividualProgramProcess process2, HSSFRow row) {
        String processNumber = process2.getProcessNumber();
        String studentNumber = process2.getStudent() != null ? process2.getStudent().getNumber().toString() : "";
        String studentName = process2.getPerson().getName();
        YearMonthDay dateOfBirth = process2.getPerson().getDateOfBirthYearMonthDay();
        String documentIdNumber = process2.getPerson().getDocumentIdNumber();
        String documentIdTypeName = process2.getPerson().getIdDocumentType().getLocalizedName();
        String phdProgramName = process2.getPhdProgram() != null ? process2.getPhdProgram().getName().getContent() : "";
        String focusArea = process2.getPhdProgramFocusArea() != null ? process2.getPhdProgramFocusArea().getName().getContent() : "";
        String activeStateName = process2.getActiveState().getLocalizedName();
        LocalDate whenStartStudies = process2.getWhenStartedStudies();
        DateTime stateDate = process2.getMostRecentState().getStateDate() != null ? process2.getMostRecentState().getStateDate() : process2.getMostRecentState().getWhenCreated();
        Boolean migratedProcess = process2.getPhdConfigurationIndividualProgramProcess().isMigratedProcess();
        this.addCellValue(row, this.onNullEmptyString(processNumber), 0);
        this.addCellValue(row, this.onNullEmptyString(studentNumber), 1);
        this.addCellValue(row, this.onNullEmptyString(studentName), 2);
        this.addCellValue(row, this.onNullEmptyString(dateOfBirth), 3);
        this.addCellValue(row, this.onNullEmptyString(documentIdNumber), 4);
        this.addCellValue(row, this.onNullEmptyString(documentIdTypeName), 5);
        this.addCellValue(row, this.onNullEmptyString(phdProgramName), 6);
        this.addCellValue(row, this.onNullEmptyString(focusArea), 7);
        this.addCellValue(row, this.onNullEmptyString(whenStartStudies), 8);
        this.addCellValue(row, this.onNullEmptyString(activeStateName), 9);
        this.addCellValue(row, this.onNullEmptyString(stateDate), 10);
        this.addCellValue(row, this.onNullEmptyString(migratedProcess), 11);
    }

    @Override
    protected void setHeaders(HSSFSheet sheet) {
        this.addHeaderCell(sheet, this.getHeaderInBundle("processNumber"), 0);
        this.addHeaderCell(sheet, this.getHeaderInBundle("studentNumber"), 1);
        this.addHeaderCell(sheet, this.getHeaderInBundle("studentName"), 2);
        this.addHeaderCell(sheet, this.getHeaderInBundle("dateOfBirth"), 3);
        this.addHeaderCell(sheet, this.getHeaderInBundle("identification"), 4);
        this.addHeaderCell(sheet, this.getHeaderInBundle("idDocumentType"), 5);
        this.addHeaderCell(sheet, this.getHeaderInBundle("phdProgram"), 6);
        this.addHeaderCell(sheet, this.getHeaderInBundle("focusArea"), 7);
        this.addHeaderCell(sheet, this.getHeaderInBundle("whenStartStudies"), 8);
        this.addHeaderCell(sheet, this.getHeaderInBundle("currentState"), 9);
        this.addHeaderCell(sheet, this.getHeaderInBundle("stateDate"), 10);
        this.addHeaderCell(sheet, this.getHeaderInBundle("migrated"), 11);
    }

    private String getHeaderInBundle(String field) {
        return BundleUtil.getString((String)"resources.PhdResources", (String)("label.org.fenixedu.academic.domain.phd.reports.PhdIndividualProgramProcessesReport." + field), (String[])new String[0]);
    }
}

