/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.individualProcess.activities;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Qualification;
import org.fenixedu.academic.domain.accessControl.AcademicAuthorizationGroup;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.individualProcess.activities.PhdIndividualProgramProcessActivity;
import org.fenixedu.bennu.core.domain.User;

public class DeleteQualification
extends PhdIndividualProgramProcessActivity {
    @Override
    protected void activityPreConditions(PhdIndividualProgramProcess arg0, User userView) {
    }

    @Override
    protected PhdIndividualProgramProcess executeActivity(PhdIndividualProgramProcess process2, User userView, Object object) {
        Qualification qualification = (Qualification)((Object)object);
        if (process2.getPerson().getAssociatedQualificationsSet().contains((Object)qualification)) {
            if (!this.canDelete(qualification, process2, userView != null ? userView.getPerson() : null)) {
                throw new DomainException("error.PhdIndividualProgramProcess.DeleteQualification.not.authorized", new String[0]);
            }
            qualification.delete();
        }
        return process2;
    }

    private boolean canDelete(Qualification qualification, PhdIndividualProgramProcess process2, Person person) {
        if (qualification.getCreator() == null) {
            return process2.getCandidacyProcess().isPublicCandidacy();
        }
        Person creator = qualification.getCreator();
        return creator == person || AcademicAuthorizationGroup.get(AcademicOperationType.MANAGE_PHD_PROCESS_STATE).isMember(creator.getUser());
    }
}

