/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.candidacy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.PhotoState;
import org.fenixedu.academic.domain.Photograph;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.PostingRule;
import org.fenixedu.academic.domain.accounting.paymentCodes.IndividualCandidacyPaymentCode;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.caseHandling.StartActivity;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.phd.PhdCandidacyProcessState;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramDocumentType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessState;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.phd.PhdProgramCandidacyProcessState;
import org.fenixedu.academic.domain.phd.PhdProgramFocusArea;
import org.fenixedu.academic.domain.phd.PhdProgramProcessDocument;
import org.fenixedu.academic.domain.phd.PhdProgramServiceAgreementTemplate;
import org.fenixedu.academic.domain.phd.alert.PhdFinalProofRequestAlert;
import org.fenixedu.academic.domain.phd.alert.PhdPublicPresentationSeminarAlert;
import org.fenixedu.academic.domain.phd.alert.PhdRegistrationFormalizationAlert;
import org.fenixedu.academic.domain.phd.candidacy.PHDProgramCandidacy;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyPeriod;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyReferee;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyEvent;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyPR;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcessBean;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcess_Base;
import org.fenixedu.academic.domain.phd.candidacy.RatifyCandidacyBean;
import org.fenixedu.academic.domain.phd.candidacy.RegistrationFormalizationBean;
import org.fenixedu.academic.domain.phd.candidacy.activities.AddCandidacyReferees;
import org.fenixedu.academic.domain.phd.candidacy.activities.AddNotification;
import org.fenixedu.academic.domain.phd.candidacy.activities.AddState;
import org.fenixedu.academic.domain.phd.candidacy.activities.AssociateRegistration;
import org.fenixedu.academic.domain.phd.candidacy.activities.DeleteCandidacyReview;
import org.fenixedu.academic.domain.phd.candidacy.activities.DeleteDocument;
import org.fenixedu.academic.domain.phd.candidacy.activities.EditCandidacyDate;
import org.fenixedu.academic.domain.phd.candidacy.activities.EditProcessAttributes;
import org.fenixedu.academic.domain.phd.candidacy.activities.PhdProgramCandidacyProcessActivity;
import org.fenixedu.academic.domain.phd.candidacy.activities.RatifyCandidacy;
import org.fenixedu.academic.domain.phd.candidacy.activities.RegistrationFormalization;
import org.fenixedu.academic.domain.phd.candidacy.activities.RejectCandidacyProcess;
import org.fenixedu.academic.domain.phd.candidacy.activities.RemoveCandidacyDocument;
import org.fenixedu.academic.domain.phd.candidacy.activities.RemoveLastState;
import org.fenixedu.academic.domain.phd.candidacy.activities.RequestCandidacyReview;
import org.fenixedu.academic.domain.phd.candidacy.activities.RequestRatifyCandidacy;
import org.fenixedu.academic.domain.phd.candidacy.activities.UploadCandidacyReview;
import org.fenixedu.academic.domain.phd.candidacy.activities.UploadDocuments;
import org.fenixedu.academic.domain.phd.candidacy.activities.ValidatedByCandidate;
import org.fenixedu.academic.domain.phd.debts.PhdRegistrationFee;
import org.fenixedu.academic.domain.student.PersonalIngressionData;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.UserLoginPeriod;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.LocalDate;

public class PhdProgramCandidacyProcess
extends PhdProgramCandidacyProcess_Base {
    private static List<Activity> activities = new ArrayList<Activity>();

    public boolean isAllowedToManageProcess(User userView) {
        return this.getIndividualProgramProcess().isAllowedToManageProcess(userView);
    }

    private PhdProgramCandidacyProcess(PhdProgramCandidacyProcessBean bean, Person person, boolean isMigratedProcess, PhdIndividualProgramProcess individualProgramProcess) {
        this.checkCandidacyDate(bean.getExecutionYear(), bean.getCandidacyDate());
        this.setCandidacyDate(bean.getCandidacyDate());
        this.setValidatedByCandidate(false);
        this.setCandidacyHashCode(bean.getCandidacyHashCode());
        PHDProgramCandidacy candidacy = new PHDProgramCandidacy(person);
        this.setCandidacy(candidacy);
        this.setIndividualProgramProcess(individualProgramProcess);
        if (bean.hasDegree()) {
            this.getCandidacy().setExecutionDegree(bean.getExecutionDegree());
        }
        if (!isMigratedProcess && (!bean.hasCollaborationType() || bean.getCollaborationType().generateCandidacyDebt()) && this.hasPaymentFees(EventType.CANDIDACY_ENROLMENT)) {
            new PhdProgramCandidacyEvent(person, this);
        }
        if (this.isPublicCandidacy()) {
            if (bean.getPhdCandidacyPeriod() == null) {
                throw new DomainException("error.phd.candidacy.PhdProgramCandidacyProcess.public.candidacy.period.is.missing", new String[0]);
            }
            this.setPublicPhdCandidacyPeriod(bean.getPhdCandidacyPeriod());
        }
    }

    private boolean hasPaymentFees(EventType candidacyEnrolmentEventType) {
        PhdProgramServiceAgreementTemplate serviceAgreementTemplate = this.getPhdProgram().getServiceAgreementTemplate();
        for (PostingRule postingRule : serviceAgreementTemplate.getAllPostingRulesFor(candidacyEnrolmentEventType)) {
            if (!postingRule.isActive()) continue;
            if (postingRule instanceof PhdProgramCandidacyPR) {
                PhdProgramCandidacyPR phdProgramCandidacyPR = (PhdProgramCandidacyPR)((Object)postingRule);
                if (!phdProgramCandidacyPR.getFixedAmount().isPositive()) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public static boolean hasOnlineApplicationForPeriod(Person person, PhdCandidacyPeriod phdCandidacyPeriod) {
        Set phdIndividualProgramProcesses = person.getPhdIndividualProgramProcessesSet();
        for (PhdIndividualProgramProcess phdIndividualProgramProcess : phdIndividualProgramProcesses) {
            if (phdCandidacyPeriod != phdIndividualProgramProcess.getCandidacyProcess().getPublicPhdCandidacyPeriod()) continue;
            return true;
        }
        return false;
    }

    public boolean isPublicCandidacy() {
        return this.getCandidacyHashCode() != null;
    }

    public IndividualCandidacyPaymentCode getAssociatedPaymentCode() {
        if (this.getEvent() == null) {
            return null;
        }
        return this.getEvent().getAssociatedPaymentCode();
    }

    public boolean hasPaymentCodeToPay() {
        if (this.getEvent() == null) {
            return false;
        }
        return this.getEvent().getAssociatedPaymentCode().getMinAmount().isPositive() && this.getEvent().getAssociatedPaymentCode().getMaxAmount().isPositive();
    }

    private void checkCandidacyDate(ExecutionYear executionYear, LocalDate candidacyDate) {
        String[] args = new String[]{};
        if (candidacyDate == null) {
            throw new DomainException("error.phd.candidacy.PhdProgramCandidacyProcess.invalid.candidacy.date", args);
        }
    }

    public boolean canExecuteActivity(User userView) {
        return false;
    }

    public List<Activity> getActivities() {
        return activities;
    }

    public String getDisplayName() {
        return BundleUtil.getString((String)"resources.PhdResources", (String)((Object)((Object)this)).getClass().getSimpleName(), (String[])new String[0]);
    }

    public PhdProgramCandidacyProcess edit(LocalDate candidacyDate) {
        this.checkCandidacyDate(this.getExecutionYear(), candidacyDate);
        this.setCandidacyDate(candidacyDate);
        return this;
    }

    private ExecutionYear getExecutionYear() {
        return this.getIndividualProgramProcess().getExecutionYear();
    }

    public boolean hasAnyPayments() {
        return this.getEvent() != null && this.getEvent().hasAnyPayments();
    }

    public void cancelDebt(Person responsible) {
        if (this.getEvent() != null && this.getEvent().isOpen()) {
            this.getEvent().cancel(responsible);
        }
    }

    public String getProcessNumber() {
        return this.getIndividualProgramProcess().getProcessNumber();
    }

    public Person getPerson() {
        return this.getIndividualProgramProcess().getPerson();
    }

    public Set<PhdProgramProcessDocument> getCandidacyReviewDocuments() {
        return this.getLatestDocumentsByType(PhdIndividualProgramDocumentType.CANDIDACY_REVIEW);
    }

    public boolean hasAnyDocuments(PhdIndividualProgramDocumentType type) {
        return !this.getLatestDocumentsByType(type).isEmpty();
    }

    public int getDocumentsCount(PhdIndividualProgramDocumentType type) {
        return this.getLatestDocumentsByType(type).size();
    }

    public boolean isValidatedByCandidate() {
        return this.getValidatedByCandidate() != null && this.getValidatedByCandidate() != false;
    }

    public boolean isOngoingApplicationAndValidatedByApplicant() {
        return this.isValidatedByCandidate() || this.getIndividualProgramProcess().getActiveState() != PhdIndividualProgramProcessState.CANDIDACY;
    }

    public Set<PhdProgramProcessDocument> getStudyPlanRelevantDocuments() {
        HashSet<PhdProgramProcessDocument> result = new HashSet<PhdProgramProcessDocument>();
        result.addAll(this.getLatestDocumentsByType(PhdIndividualProgramDocumentType.STUDY_PLAN));
        result.addAll(this.getLatestDocumentsByType(PhdIndividualProgramDocumentType.CANDIDACY_REVIEW));
        return result;
    }

    public void createState(PhdProgramCandidacyProcessState stateType, Person person, String remarks) {
        PhdCandidacyProcessState.createStateWithInferredStateDate(this, stateType, person, remarks);
    }

    public PhdCandidacyProcessState getMostRecentState() {
        return (PhdCandidacyProcessState)((Object)super.getMostRecentState());
    }

    public PhdProgramCandidacyProcessState getActiveState() {
        return (PhdProgramCandidacyProcessState)super.getActiveState();
    }

    public boolean isInState(PhdProgramCandidacyProcessState state) {
        return this.getActiveState().equals(state);
    }

    public void ratify(RatifyCandidacyBean bean, Person responsible) {
        LocalDate obj = bean.getWhenRatified();
        String[] args = new String[]{};
        if (obj == null) {
            throw new DomainException("error.phd.candidacy.PhdProgramCandidacyProcess.when.ratified.cannot.be.null", args);
        }
        if (!this.getIndividualProgramProcess().getPhdConfigurationIndividualProgramProcess().isMigratedProcess().booleanValue() && !bean.getRatificationFile().hasAnyInformation()) {
            throw new DomainException("error.phd.candidacy.PhdProgramCandidacyProcess.ratification.document.is.required", new String[0]);
        }
        this.setWhenRatified(bean.getWhenRatified());
        if (bean.getRatificationFile().hasAnyInformation()) {
            this.addDocument(bean.getRatificationFile(), responsible);
        }
        if (!this.getIndividualProgramProcess().getPhdConfigurationIndividualProgramProcess().isMigratedProcess().booleanValue() && !this.getIndividualProgramProcess().hasAnyRegistrationFormalizationActiveAlert()) {
            new PhdRegistrationFormalizationAlert(this.getIndividualProgramProcess(), bean.getMaxDaysToFormalizeRegistration());
        }
        this.createState(PhdProgramCandidacyProcessState.RATIFIED_BY_SCIENTIFIC_COUNCIL, responsible, "");
    }

    public PhdProgramCandidacyProcess registrationFormalization(RegistrationFormalizationBean bean, Person responsible) {
        if (!this.hasStudyPlan()) {
            throw new DomainException("error.phd.candidacy.PhdProgramCandidacyProcess.registrationFormalization.must.create.study.plan", new String[0]);
        }
        LocalDate whenFormalizedRegistration = new LocalDate();
        this.getIndividualProgramProcess().setWhenFormalizedRegistration(whenFormalizedRegistration);
        this.getIndividualProgramProcess().setWhenStartedStudies(bean.getWhenStartedStudies());
        this.assertPersonInformation();
        if (!this.getIndividualProgramProcess().getPhdConfigurationIndividualProgramProcess().isMigratedProcess().booleanValue()) {
            DegreeCurricularPlan dcp = this.getPhdProgramLastActiveDegreeCurricularPlan();
            this.assertStudyPlanInformation(bean, dcp);
            this.assertDebts(bean);
            this.assertRegistrationFormalizationAlerts();
        }
        this.createState(PhdProgramCandidacyProcessState.CONCLUDED, responsible, "");
        this.getIndividualProgramProcess().createState(PhdIndividualProgramProcessState.WORK_DEVELOPMENT, responsible, "");
        return this;
    }

    private void assertStudyPlanInformation(RegistrationFormalizationBean bean, DegreeCurricularPlan degreeCurricularPlan) {
        ExecutionYear executionYear = ExecutionYear.readByDateTime(bean.getWhenStartedStudies());
        if (executionYear == null) {
            throw new DomainException("error.phd.candidacy.PhdProgramCandidacyProcess.StudyPlan.invalid.start.date", new String[0]);
        }
        if (this.hasCurricularStudyPlan()) {
            this.assertCandidacy(degreeCurricularPlan, executionYear);
            this.assertRegistration(bean, degreeCurricularPlan, executionYear);
        }
    }

    public PhdProgramCandidacyProcess associateRegistration(RegistrationFormalizationBean bean) {
        if (this.isStudyPlanExempted()) {
            throw new DomainException("error.phd.candidacy.PhdProgramCandidacyProcess.associateRegistration.study.plan.is.exempted", new String[0]);
        }
        this.assertStudyPlanInformation(bean, bean.getRegistration().getLastDegreeCurricularPlan());
        this.assertRegistrationFormalizationAlerts();
        if (!this.getIndividualProgramProcess().getPhdConfigurationIndividualProgramProcess().isMigratedProcess().booleanValue()) {
            this.assertDebts(bean);
        }
        return this;
    }

    private void assertPersonInformation() {
        Photograph photograph;
        Person person = this.getPerson();
        if (this.getPerson().getStudent() == null) {
            new Student(this.getPerson());
        }
        Student student = this.getPerson().getStudent();
        PrecedentDegreeInformation precedentDegreeInformation = this.getCandidacy().getPrecedentDegreeInformation();
        ExecutionYear executionYear = this.getExecutionYear();
        if (this.getPerson().getStudent().getPersonalIngressionDataByExecutionYear(executionYear) == null) {
            new PersonalIngressionData(student, executionYear, precedentDegreeInformation);
        }
        PersonalIngressionData personalIngressionData = this.getPerson().getStudent().getPersonalIngressionDataByExecutionYear(executionYear);
        personalIngressionData.addPrecedentDegreesInformations(precedentDegreeInformation);
        precedentDegreeInformation.setPhdIndividualProgramProcess(this.getIndividualProgramProcess());
        if (person.getUser() == null) {
            person.setUser(new User(person.getProfile()));
        }
        UserLoginPeriod.createOpenPeriod((User)person.getUser());
        RoleType.grant(RoleType.RESEARCHER, person.getUser());
        if (person.getPersonalPhoto() == null && (photograph = person.getPersonalPhotoEvenIfPending()) != null) {
            photograph.setState(PhotoState.APPROVED);
        }
    }

    private void assertCandidacy(DegreeCurricularPlan dcp, ExecutionYear executionYear) {
        if (this.getCandidacy().getExecutionDegree() == null) {
            ExecutionDegree executionDegree = dcp.getExecutionDegreeByAcademicInterval(executionYear.getAcademicInterval());
            this.getCandidacy().setExecutionDegree(executionDegree);
        }
        this.getCandidacy().setIngressionType(IngressionType.findByPredicate(IngressionType::isInternal3rdCycleAccess).orElse(null));
    }

    private void assertRegistration(RegistrationFormalizationBean bean, DegreeCurricularPlan dcp, ExecutionYear executionYear) {
        Registration registration = this.getOrCreateRegistration(bean, dcp, executionYear);
        registration.setHomologationDate(this.getWhenRatified());
        registration.setStudiesStartDate(bean.getWhenStartedStudies());
        registration.setIngressionType(IngressionType.findByPredicate(IngressionType::isInternal3rdCycleAccess).orElse(null));
        registration.setPhdIndividualProgramProcess(this.getIndividualProgramProcess());
        registration.editStartDates(bean.getWhenStartedStudies(), this.getWhenRatified(), bean.getWhenStartedStudies());
        if (registration.getStudentCandidacy() == this.getIndividualProgramProcess().getCandidacyProcess().getCandidacy()) {
            return;
        }
    }

    private Registration getOrCreateRegistration(RegistrationFormalizationBean bean, DegreeCurricularPlan dcp, ExecutionYear executionYear) {
        Registration registration;
        if (this.getIndividualProgramProcess().getPhdConfigurationIndividualProgramProcess().isMigratedProcess().booleanValue() && bean.hasRegistration()) {
            return bean.getRegistration();
        }
        if (this.hasActiveRegistrationFor(dcp)) {
            if (!bean.hasRegistration()) {
                throw new DomainException("error.PhdProgramCandidacyProcess.regisration.formalization.already.has.registration", new String[0]);
            }
            registration = bean.getRegistration();
        } else {
            registration = new Registration(this.getPerson(), dcp, (StudentCandidacy)((Object)this.getCandidacy()), RegistrationProtocol.getDefault(), null, executionYear);
        }
        return registration;
    }

    private void assertDebts(RegistrationFormalizationBean bean) {
        this.assertPhdRegistrationFee();
        this.assertInsuranceEvent(ExecutionYear.readByDateTime(bean.getWhenStartedStudies()));
    }

    private void assertPhdRegistrationFee() {
        if (this.getIndividualProgramProcess().getRegistrationFee() == null) {
            new PhdRegistrationFee(this.getIndividualProgramProcess());
        }
    }

    private void assertInsuranceEvent(ExecutionYear executionYear) {
    }

    private void assertRegistrationFormalizationAlerts() {
        if (!this.getIndividualProgramProcess().getPhdConfigurationIndividualProgramProcess().isMigratedProcess().booleanValue() && !this.getIndividualProgramProcess().hasPhdPublicPresentationSeminarAlert()) {
            new PhdPublicPresentationSeminarAlert(this.getIndividualProgramProcess());
        }
        if (!this.getIndividualProgramProcess().getPhdConfigurationIndividualProgramProcess().isMigratedProcess().booleanValue() && !this.getIndividualProgramProcess().hasPhdFinalProofRequestAlert()) {
            new PhdFinalProofRequestAlert(this.getIndividualProgramProcess());
        }
    }

    private boolean hasCurricularStudyPlan() {
        return this.hasStudyPlan() && !this.getIndividualProgramProcess().getStudyPlan().isExempted();
    }

    public DegreeCurricularPlan getPhdProgramLastActiveDegreeCurricularPlan() {
        return this.hasPhdProgram() ? this.getPhdProgram().getDegree().getLastActiveDegreeCurricularPlan() : null;
    }

    PhdProgram getPhdProgram() {
        return this.getIndividualProgramProcess().getPhdProgram();
    }

    PhdProgramFocusArea getPhdProgramFocusArea() {
        return this.getIndividualProgramProcess().getPhdProgramFocusArea();
    }

    boolean hasPhdProgramFocusArea() {
        return this.getPhdProgramFocusArea() != null;
    }

    public boolean hasPhdProgram() {
        return this.getPhdProgram() != null;
    }

    public boolean hasStudyPlan() {
        return this.getIndividualProgramProcess().getStudyPlan() != null;
    }

    public boolean isStudyPlanExempted() {
        return this.hasStudyPlan() && this.getIndividualProgramProcess().getStudyPlan().isExempted();
    }

    public boolean hasActiveRegistrationFor(DegreeCurricularPlan degreeCurricularPlan) {
        return this.getPerson().getStudent() != null ? this.getPerson().getStudent().hasActiveRegistrationFor(degreeCurricularPlan) : false;
    }

    public LocalDate getWhenStartedStudies() {
        return this.getIndividualProgramProcess().getWhenStartedStudies();
    }

    public void deleteLastState() {
        if (this.getStatesSet().size() <= 1) {
            throw new DomainException("error.phd.candidacy.PhdProgramCandidacyProcess.cannot.delete.the.only.state", new String[0]);
        }
        this.getMostRecentState().delete();
    }

    public PhdCandidacyReferee getCandidacyRefereeByEmail(String email) {
        Set candidacyReferees = this.getCandidacyRefereesSet();
        for (PhdCandidacyReferee phdCandidacyReferee : candidacyReferees) {
            if (!phdCandidacyReferee.getEmail().trim().equals(email.trim())) continue;
            return phdCandidacyReferee;
        }
        return null;
    }

    public Set<PhdCandidacyProcessState> getStates() {
        return this.getStatesSet();
    }

    public boolean hasAnyStates() {
        return !this.getStatesSet().isEmpty();
    }

    static {
        activities.add(new UploadDocuments());
        activities.add(new DeleteDocument());
        activities.add(new EditCandidacyDate());
        activities.add(new AddCandidacyReferees());
        activities.add(new ValidatedByCandidate());
        activities.add(new RequestCandidacyReview());
        activities.add(new UploadCandidacyReview());
        activities.add(new DeleteCandidacyReview());
        activities.add(new RejectCandidacyProcess());
        activities.add(new RequestRatifyCandidacy());
        activities.add(new RatifyCandidacy());
        activities.add(new AddNotification());
        activities.add(new RegistrationFormalization());
        activities.add(new AssociateRegistration());
        activities.add(new AddState());
        activities.add(new RemoveLastState());
        activities.add(new EditProcessAttributes());
        activities.add(new RemoveCandidacyDocument());
    }

    @StartActivity
    public static class CreateCandidacy
    extends PhdProgramCandidacyProcessActivity {
        @Override
        protected void activityPreConditions(PhdProgramCandidacyProcess process2, User userView) {
        }

        @Override
        protected PhdProgramCandidacyProcess executeActivity(PhdProgramCandidacyProcess process2, User userView, Object object) {
            Object[] values = (Object[])object;
            PhdProgramCandidacyProcessBean bean = this.readBean(values);
            Person person = this.readPerson(values);
            PhdIndividualProgramProcess individualProgramProcess = this.readPhdIndividualProgramProcess(values);
            PhdProgramCandidacyProcess result = new PhdProgramCandidacyProcess(bean, person, bean.getMigratedProcess(), individualProgramProcess);
            result.createState(bean.getState(), person, "");
            return result;
        }

        private Person readPerson(Object[] values) {
            return (Person)((Object)values[1]);
        }

        private PhdProgramCandidacyProcessBean readBean(Object[] values) {
            return (PhdProgramCandidacyProcessBean)values[0];
        }

        private PhdIndividualProgramProcess readPhdIndividualProgramProcess(Object[] values) {
            return (PhdIndividualProgramProcess)((Object)values[2]);
        }
    }
}

