/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.organizationalStructure;

import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityType;
import org.fenixedu.academic.domain.organizationalStructure.ManagementCouncilUnit_Base;
import org.fenixedu.academic.domain.organizationalStructure.PartyType;
import org.fenixedu.academic.domain.organizationalStructure.PartyTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitClassification;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.YearMonthDay;

public class ManagementCouncilUnit
extends ManagementCouncilUnit_Base {
    private ManagementCouncilUnit() {
        super.setType(PartyTypeEnum.MANAGEMENT_COUNCIL);
    }

    public static ManagementCouncilUnit createManagementCouncilUnit(MultiLanguageString name, String unitNameCard, Integer costCenterCode, String acronym, YearMonthDay beginDate, YearMonthDay endDate, Unit parentUnit, AccountabilityType accountabilityType, String webAddress, UnitClassification classification, Boolean canBeResponsibleOfSpaces, Space campus) {
        if (!PartyType.getPartiesSet(PartyTypeEnum.MANAGEMENT_COUNCIL).isEmpty()) {
            throw new DomainException("error.can.only.exist.one.managementCouncilUnit", new String[0]);
        }
        ManagementCouncilUnit unit = new ManagementCouncilUnit();
        unit.init(name, unitNameCard, costCenterCode, acronym, beginDate, endDate, webAddress, classification, null, canBeResponsibleOfSpaces, campus);
        unit.addParentUnit(parentUnit, accountabilityType);
        return unit;
    }

    public void setAcronym(String acronym) {
        if (StringUtils.isEmpty((String)acronym)) {
            throw new DomainException("acronym.cannot.be.null", new String[0]);
        }
        super.setAcronym(acronym);
    }

    public void setType(PartyTypeEnum partyTypeEnum) {
        throw new DomainException("unit.impossible.set.type", new String[0]);
    }
}

