/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import org.fenixedu.academic.domain.curriculum.EnrollmentCondition;

public enum EnrolmentResultType {
    TEMPORARY(0, EnrollmentCondition.TEMPORARY),
    VALIDATED(1, EnrollmentCondition.VALIDATED),
    IMPOSSIBLE(2, EnrollmentCondition.IMPOSSIBLE),
    NULL(3, EnrollmentCondition.INVISIBLE);

    private static final EnrolmentResultType[][] AND_TABLE;
    private static final EnrolmentResultType[][] OR_TABLE;
    private int order;
    private EnrollmentCondition enrollmentCondition;

    private EnrolmentResultType(int order, EnrollmentCondition enrollmentCondition) {
        this.order = order;
        this.enrollmentCondition = enrollmentCondition;
    }

    public int order() {
        return this.order;
    }

    public EnrollmentCondition getEnrollmentCondition() {
        return this.enrollmentCondition;
    }

    public String value() {
        return this.name();
    }

    public EnrolmentResultType and(EnrolmentResultType enrolmentResultType) {
        return AND_TABLE[this.order][enrolmentResultType.order()];
    }

    public EnrolmentResultType or(EnrolmentResultType enrolmentResultType) {
        return OR_TABLE[this.order][enrolmentResultType.order()];
    }

    static {
        AND_TABLE = new EnrolmentResultType[][]{{TEMPORARY, TEMPORARY, IMPOSSIBLE, TEMPORARY}, {TEMPORARY, VALIDATED, IMPOSSIBLE, VALIDATED}, {IMPOSSIBLE, IMPOSSIBLE, IMPOSSIBLE, IMPOSSIBLE}, {TEMPORARY, VALIDATED, IMPOSSIBLE, NULL}};
        OR_TABLE = new EnrolmentResultType[][]{{TEMPORARY, VALIDATED, TEMPORARY, TEMPORARY}, {VALIDATED, VALIDATED, VALIDATED, VALIDATED}, {TEMPORARY, VALIDATED, IMPOSSIBLE, IMPOSSIBLE}, {TEMPORARY, VALIDATED, IMPOSSIBLE, NULL}};
    }
}

