/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import java.util.List;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularRules.AndRule;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.CurricularRule_Base;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.NotRule;
import org.fenixedu.academic.domain.curricularRules.OrRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutorFactory;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleLevel;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.util.LogicOperator;
import org.fenixedu.academic.dto.GenericPair;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.YearMonthDay;

public abstract class CurricularRule
extends CurricularRule_Base
implements ICurricularRule {
    protected CurricularRule() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    protected void init(DegreeModule degreeModuleToApplyRule, CourseGroup contextCourseGroup, ExecutionSemester begin, ExecutionSemester end, CurricularRuleType type) {
        this.init(degreeModuleToApplyRule, contextCourseGroup, begin, end);
        this.checkCurricularRuleType(type);
        this.setCurricularRuleType(type);
    }

    private void checkCurricularRuleType(CurricularRuleType type) {
        if (type == null) {
            throw new DomainException("curricular.rule.invalid.parameters", new String[0]);
        }
    }

    protected void init(DegreeModule degreeModuleToApplyRule, CourseGroup contextCourseGroup, ExecutionSemester begin, ExecutionSemester end) {
        this.checkParameters(degreeModuleToApplyRule, begin);
        this.checkExecutionPeriods(begin, end);
        this.setDegreeModuleToApplyRule(degreeModuleToApplyRule);
        this.setContextCourseGroup(contextCourseGroup);
        this.setBegin(begin);
        this.setEnd(end);
    }

    protected void checkParameters(DegreeModule degreeModuleToApplyRule, ExecutionSemester begin) {
        if (degreeModuleToApplyRule == null || begin == null) {
            throw new DomainException("curricular.rule.invalid.parameters", new String[0]);
        }
    }

    protected void edit(ExecutionSemester beginExecutionPeriod, ExecutionSemester endExecutionPeriod) {
        this.checkExecutionPeriods(beginExecutionPeriod, endExecutionPeriod);
        this.setBegin(beginExecutionPeriod);
        this.setEnd(endExecutionPeriod);
    }

    public void delete() {
        this.removeOwnParameters();
        this.removeCommonParameters();
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    protected void removeCommonParameters() {
        this.setDegreeModuleToApplyRule(null);
        this.setBegin(null);
        this.setEnd(null);
        this.setParentCompositeRule(null);
        this.setContextCourseGroup(null);
        this.setRootDomainObject(null);
    }

    @Override
    public boolean appliesToContext(Context context) {
        return context == null || this.appliesToCourseGroup(context.getParentCourseGroup());
    }

    @Override
    public boolean appliesToCourseGroup(CourseGroup courseGroup) {
        return !this.hasContextCourseGroup() || this.getContextCourseGroup() == courseGroup;
    }

    @Override
    public boolean isCompositeRule() {
        return this.getCurricularRuleType() == null;
    }

    protected boolean belongsToCompositeRule() {
        return this.getParentCompositeRule() != null;
    }

    @Override
    public ExecutionSemester getBegin() {
        return this.belongsToCompositeRule() ? this.getParentCompositeRule().getBegin() : super.getBegin();
    }

    @Override
    public ExecutionSemester getEnd() {
        return this.belongsToCompositeRule() ? this.getParentCompositeRule().getEnd() : super.getEnd();
    }

    @Override
    public DegreeModule getDegreeModuleToApplyRule() {
        return this.belongsToCompositeRule() ? this.getParentCompositeRule().getDegreeModuleToApplyRule() : super.getDegreeModuleToApplyRule();
    }

    @Override
    public CourseGroup getContextCourseGroup() {
        return this.belongsToCompositeRule() ? this.getParentCompositeRule().getContextCourseGroup() : super.getContextCourseGroup();
    }

    public boolean hasContextCourseGroup(CourseGroup parent) {
        return this.getContextCourseGroup() == parent;
    }

    @Override
    public boolean hasCurricularRuleType(CurricularRuleType ruleType) {
        return this.getCurricularRuleType() == ruleType;
    }

    @Override
    public boolean isValid(ExecutionSemester executionSemester) {
        return this.getBegin().isBeforeOrEquals(executionSemester) && (this.getEnd() == null || this.getEnd().isAfterOrEquals(executionSemester));
    }

    @Override
    public boolean isValid(ExecutionYear executionYear) {
        for (ExecutionSemester executionSemester : executionYear.getExecutionPeriodsSet()) {
            if (!this.isValid(executionSemester)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isActive() {
        return this.getEnd() == null || this.getEnd().containsDay(new YearMonthDay());
    }

    protected void checkExecutionPeriods(ExecutionSemester beginExecutionPeriod, ExecutionSemester endExecutionPeriod) {
        if (endExecutionPeriod != null && beginExecutionPeriod.isAfter(endExecutionPeriod)) {
            throw new DomainException("curricular.rule.begin.is.after.end.execution.period", new String[0]);
        }
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public RuleResult evaluate(IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return CurricularRuleExecutorFactory.findExecutor(this).execute(this, sourceDegreeModuleToEvaluate, enrolmentContext);
    }

    @Override
    public RuleResult verify(VerifyRuleLevel level, EnrolmentContext enrolmentContext, DegreeModule degreeModuleToVerify, CourseGroup parentCourseGroup) {
        return this.createVerifyRuleExecutor().verify(this, level, enrolmentContext, degreeModuleToVerify, parentCourseGroup);
    }

    protected abstract void removeOwnParameters();

    public abstract boolean isLeaf();

    public abstract boolean isRulePreventingAutomaticEnrolment();

    @Override
    public abstract List<GenericPair<Object, Boolean>> getLabel();

    public static CurricularRule createCurricularRule(LogicOperator logicOperator, CurricularRule ... curricularRules) {
        switch (logicOperator) {
            case AND: {
                return new AndRule(curricularRules);
            }
            case OR: {
                return new OrRule(curricularRules);
            }
            case NOT: {
                if (curricularRules.length != 1) {
                    throw new DomainException("error.invalid.notRule.parameters", new String[0]);
                }
                return new NotRule(curricularRules[0]);
            }
        }
        throw new DomainException("error.unsupported.logic.operator", new String[0]);
    }

    @Override
    public boolean hasContextCourseGroup() {
        return this.getContextCourseGroup() != null;
    }
}

