/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacy.workflow.form;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.GrantOwnerType;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.ProfessionType;
import org.fenixedu.academic.domain.ProfessionalSituationConditionType;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.organizationalStructure.PartySocialSecurityNumber;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitName;
import org.fenixedu.academic.domain.person.Gender;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.academic.domain.person.MaritalStatus;
import org.fenixedu.academic.domain.util.workflow.Form;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.YearMonthDay;

public class PersonalInformationForm
extends Form {
    private static final long serialVersionUID = 1L;
    private String name;
    private String username;
    private Gender gender;
    private String documentIdNumber;
    private IDDocumentType idDocumentType;
    private String identificationDocumentExtraDigit;
    private String identificationDocumentSeriesNumber;
    private String documentIdEmissionLocation;
    private YearMonthDay documentIdEmissionDate;
    private YearMonthDay documentIdExpirationDate;
    private String socialSecurityNumber;
    private ProfessionType professionType;
    private ProfessionalSituationConditionType professionalCondition;
    private String profession;
    private MaritalStatus maritalStatus;
    private GrantOwnerType grantOwnerType;
    private Unit grantOwnerProvider;
    private String grantOwnerProviderName;

    public PersonalInformationForm() {
    }

    private PersonalInformationForm(YearMonthDay documentIdEmissionDate, String documentIdEmissionLocation, YearMonthDay documentIdExpirationDate, String documentIdNumber, IDDocumentType documentType, Gender gender, MaritalStatus maritalStatus, String name, String profession, String socialSecurityNumber, String username, String identificationDocumentExtraDigit, String identificationDocumentSeriesNumber) {
        this();
        this.documentIdEmissionDate = documentIdEmissionDate;
        this.documentIdEmissionLocation = documentIdEmissionLocation;
        this.documentIdExpirationDate = documentIdExpirationDate;
        this.documentIdNumber = documentIdNumber;
        this.idDocumentType = documentType;
        this.gender = gender;
        this.maritalStatus = maritalStatus;
        this.name = name;
        this.profession = profession;
        this.socialSecurityNumber = socialSecurityNumber;
        this.username = username;
        this.professionType = ProfessionType.OTHER;
        this.professionalCondition = ProfessionalSituationConditionType.STUDENT;
        this.grantOwnerType = GrantOwnerType.STUDENT_WITHOUT_SCHOLARSHIP;
        this.identificationDocumentExtraDigit = identificationDocumentExtraDigit;
        this.identificationDocumentSeriesNumber = identificationDocumentSeriesNumber;
    }

    public static PersonalInformationForm createFromPerson(Person person) {
        return new PersonalInformationForm(person.getEmissionDateOfDocumentIdYearMonthDay(), person.getEmissionLocationOfDocumentId(), person.getExpirationDateOfDocumentIdYearMonthDay(), person.getDocumentIdNumber(), person.getIdDocumentType(), person.getGender(), person.getMaritalStatus(), person.getName(), person.getProfession(), person.getSocialSecurityNumber(), person.getUsername(), person.getIdentificationDocumentExtraDigitValue(), person.getIdentificationDocumentSeriesNumberValue());
    }

    @Override
    public List<LabelFormatter> validate() {
        ArrayList<LabelFormatter> result = new ArrayList<LabelFormatter>();
        this.checkGrantOwnerType(result);
        this.validateSocialSecurityNumber(result);
        return result;
    }

    private void validateSocialSecurityNumber(List<LabelFormatter> result) {
        Party party = PartySocialSecurityNumber.readPartyBySocialSecurityNumber(this.socialSecurityNumber);
        User user = User.findByUsername((String)this.username);
        if (party != null && party != user.getPerson()) {
            result.add(new LabelFormatter().appendLabel("error.candidacy.workflow.PersonalInformationForm.socialSecurityNumber.already.exists", "resources.ApplicationResources"));
        }
    }

    private void checkGrantOwnerType(List<LabelFormatter> result) {
        if (this.getGrantOwnerType().equals((Object)GrantOwnerType.OTHER_INSTITUTION_GRANT_OWNER) && this.getGrantOwnerProvider() == null) {
            result.add(new LabelFormatter().appendLabel("error.candidacy.workflow.PersonalInformationForm.grant.owner.must.choose.granting.institution", "resources.ApplicationResources"));
        }
    }

    public YearMonthDay getDocumentIdEmissionDate() {
        return this.documentIdEmissionDate;
    }

    public void setDocumentIdEmissionDate(YearMonthDay documentIdEmissionDate) {
        this.documentIdEmissionDate = documentIdEmissionDate;
    }

    public String getDocumentIdEmissionLocation() {
        return this.documentIdEmissionLocation;
    }

    public void setDocumentIdEmissionLocation(String documentIdEmissionLocation) {
        this.documentIdEmissionLocation = documentIdEmissionLocation;
    }

    public YearMonthDay getDocumentIdExpirationDate() {
        return this.documentIdExpirationDate;
    }

    public void setDocumentIdExpirationDate(YearMonthDay documentIdExpirationDate) {
        this.documentIdExpirationDate = documentIdExpirationDate;
    }

    public String getDocumentIdNumber() {
        return this.documentIdNumber;
    }

    public void setDocumentIdNumber(String documentIdNumber) {
        this.documentIdNumber = documentIdNumber;
    }

    public IDDocumentType getIdDocumentType() {
        return this.idDocumentType;
    }

    public void setIdDocumentType(IDDocumentType documentType) {
        this.idDocumentType = documentType;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public MaritalStatus getMaritalStatus() {
        return this.maritalStatus;
    }

    public void setMaritalStatus(MaritalStatus maritalStatus) {
        this.maritalStatus = maritalStatus;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProfession() {
        return this.profession;
    }

    public void setProfession(String profession) {
        this.profession = profession;
    }

    public ProfessionType getProfessionType() {
        return this.professionType;
    }

    public void setProfessionType(ProfessionType professionType) {
        this.professionType = professionType;
    }

    public ProfessionalSituationConditionType getProfessionalCondition() {
        return this.professionalCondition;
    }

    public void setProfessionalCondition(ProfessionalSituationConditionType professionalCondition) {
        this.professionalCondition = professionalCondition;
    }

    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    public void setSocialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public GrantOwnerType getGrantOwnerType() {
        return this.grantOwnerType;
    }

    public void setGrantOwnerType(GrantOwnerType grantOwnerType) {
        this.grantOwnerType = grantOwnerType;
    }

    public Unit getGrantOwnerProvider() {
        return this.grantOwnerProvider;
    }

    public void setGrantOwnerProvider(Unit grantOwnerProvider) {
        this.grantOwnerProvider = grantOwnerProvider;
    }

    public String getGrantOwnerProviderName() {
        return this.grantOwnerProviderName;
    }

    public void setGrantOwnerProviderName(String grantOwnerProviderName) {
        this.grantOwnerProviderName = grantOwnerProviderName;
    }

    public UnitName getGrantOwnerProviderUnitName() {
        return this.grantOwnerProvider == null ? null : this.grantOwnerProvider.getUnitName();
    }

    public void setGrantOwnerProviderUnitName(UnitName grantOwnerProviderUnitName) {
        this.grantOwnerProvider = grantOwnerProviderUnitName == null ? null : grantOwnerProviderUnitName.getUnit();
    }

    @Override
    public String getFormName() {
        return "label.candidacy.workflow.personalInformationForm";
    }

    public String getIdentificationDocumentExtraDigit() {
        return this.identificationDocumentExtraDigit;
    }

    public void setIdentificationDocumentExtraDigit(String identificationDocumentExtraDigit) {
        this.identificationDocumentExtraDigit = identificationDocumentExtraDigit;
    }

    public String getIdentificationDocumentSeriesNumber() {
        return this.identificationDocumentSeriesNumber;
    }

    public void setIdentificationDocumentSeriesNumber(String identificationDocumentSeriesNumber) {
        this.identificationDocumentSeriesNumber = identificationDocumentSeriesNumber;
    }
}

