/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.serviceRequests;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.CertificateRequestEvent;
import org.fenixedu.academic.domain.accounting.postingRules.serviceRequests.CourseLoadRequestPR_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;

public class CourseLoadRequestPR
extends CourseLoadRequestPR_Base {
    protected CourseLoadRequestPR() {
    }

    public CourseLoadRequestPR(ServiceAgreementTemplate serviceAgreementTemplate, DateTime startDate, DateTime endDate, Money certificateAmount, Money amountFirstPage, Money amountPerPage) {
        this();
        super.init(EntryType.COURSE_LOAD_REQUEST_FEE, EventType.COURSE_LOAD_REQUEST, startDate, endDate, serviceAgreementTemplate, certificateAmount, amountPerPage);
        this.checkParameters(amountFirstPage);
        super.setAmountFirstPage(amountFirstPage);
    }

    protected void checkParameters(Money amountFirstPage) {
        if (amountFirstPage == null) {
            throw new DomainException("error.accounting.postingRules.CourseLoadRequestPR.amountFirstPage.cannot.be.null", new String[0]);
        }
    }

    public CourseLoadRequestPR edit(Money baseAmount, Money amountFirstPage, Money amountPerUnit) {
        this.deactivate();
        return new CourseLoadRequestPR(this.getServiceAgreementTemplate(), new DateTime().minus(1000L), null, baseAmount, amountFirstPage, amountPerUnit);
    }

    protected Money getAmountForPages(Event event) {
        CertificateRequestEvent requestEvent = (CertificateRequestEvent)((Object)event);
        int extraPages = requestEvent.getNumberOfPages() - 1;
        return extraPages <= 0 ? Money.ZERO : this.getAmountFirstPage().add(this.getAmountPerPage().multiply(BigDecimal.valueOf(--extraPages)));
    }

    protected boolean isUrgent(Event event) {
        return ((CertificateRequestEvent)((Object)event)).isUrgentRequest();
    }
}

