/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules;

import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.postingRules.PartialRegistrationRegimeRequestPR_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class PartialRegistrationRegimeRequestPR
extends PartialRegistrationRegimeRequestPR_Base {
    protected PartialRegistrationRegimeRequestPR() {
    }

    public PartialRegistrationRegimeRequestPR(ExecutionYear executionYear, ServiceAgreementTemplate serviceAgreementTemplate, Money fixedAmount) {
        this();
        this.init(EntryType.PARTIAL_REGISTRATION_REGIME_REQUEST_FEE, EventType.PARTIAL_REGISTRATION_REGIME_REQUEST, executionYear, executionYear.getBeginDateYearMonthDay().toDateTimeAtMidnight(), executionYear.getEndDateYearMonthDay().toDateTimeAtMidnight(), serviceAgreementTemplate, fixedAmount);
    }

    private void checkParameters(ExecutionYear executionYear) {
        if (executionYear == null) {
            throw new DomainException("error.accounting.postingRules.PartialRegistrationRegimeRequestPR.executionYear.cannot.be.null", new String[0]);
        }
    }

    protected void init(EntryType entryType, EventType eventType, ExecutionYear executionYear, DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money fixedAmount) {
        this.checkParameters(executionYear);
        super.init(entryType, eventType, startDate, endDate, serviceAgreementTemplate, fixedAmount);
        this.setExecutionYear(executionYear);
    }

    public boolean isVisible() {
        return this == PartialRegistrationRegimeRequestPR.readMostRecentPostingRule();
    }

    public boolean isActive() {
        return super.isActive();
    }

    public boolean isActiveForDate(DateTime when) {
        ExecutionYear executionYear = ExecutionYear.readByDateTime(when);
        return this == PartialRegistrationRegimeRequestPR.readMostRecentPostingRuleForExecutionYear(executionYear);
    }

    public boolean overlaps(EventType eventType, DateTime startDate, DateTime endDate) {
        return false;
    }

    public static PartialRegistrationRegimeRequestPR readMostRecentPostingRule() {
        for (ExecutionYear executionYear = ExecutionYear.readCurrentExecutionYear(); executionYear != null; executionYear = executionYear.getPreviousExecutionYear()) {
            PartialRegistrationRegimeRequestPR mostRecent = PartialRegistrationRegimeRequestPR.readMostRecentPostingRuleForExecutionYear(executionYear);
            if (mostRecent == null) continue;
            return mostRecent;
        }
        return null;
    }

    public static PartialRegistrationRegimeRequestPR readMostRecentPostingRuleForExecutionYear(ExecutionYear executionYear) {
        PartialRegistrationRegimeRequestPR mostRecent = null;
        for (PartialRegistrationRegimeRequestPR postingRule : executionYear.getPartialRegistrationRegimeRequestPostingRulesSet()) {
            if (mostRecent == null) {
                mostRecent = postingRule;
                continue;
            }
            if (!postingRule.getCreationDate().isAfter((ReadableInstant)mostRecent.getCreationDate())) continue;
            mostRecent = postingRule;
        }
        return mostRecent;
    }

    public PartialRegistrationRegimeRequestPR edit(Money fixedAmount) {
        return new PartialRegistrationRegimeRequestPR(this.getExecutionYear(), this.getServiceAgreementTemplate(), fixedAmount);
    }
}

