/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events;

import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.accounting.events.InsuranceExemption;
import org.fenixedu.academic.domain.accounting.events.InsuranceExemptionJustificationByDispatch_Base;
import org.fenixedu.academic.domain.accounting.events.InsuranceExemptionJustificationType;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.util.LabelFormatter;
import org.joda.time.YearMonthDay;

public class InsuranceExemptionJustificationByDispatch
extends InsuranceExemptionJustificationByDispatch_Base {
    protected InsuranceExemptionJustificationByDispatch() {
    }

    public InsuranceExemptionJustificationByDispatch(InsuranceExemption exemption, InsuranceExemptionJustificationType justificationType, String reason, YearMonthDay dispatchDate) {
        this();
        this.init(exemption, justificationType, reason, dispatchDate);
    }

    private void init(InsuranceExemption exemption, InsuranceExemptionJustificationType justificationType, String reason, YearMonthDay dispatchDate) {
        this.checkParameters(justificationType, reason, dispatchDate);
        super.init(exemption, justificationType, reason);
        super.setDispatchDate(dispatchDate);
    }

    private void checkParameters(InsuranceExemptionJustificationType justificationType, String reason, YearMonthDay dispatchDate) {
        if (dispatchDate == null || StringUtils.isEmpty((String)reason)) {
            throw new DomainExceptionWithLabelFormatter("error.accounting.events.InsuranceExemptionJustificationByDispatch.dispatchDate.and.reason.are.required", new LabelFormatter(justificationType.getQualifiedName(), "resources.EnumerationResources"));
        }
    }

    public LabelFormatter getDescription() {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel(this.getJustificationType().getQualifiedName(), "resources.EnumerationResources");
        String formatedDate = this.getDispatchDate() != null ? this.getDispatchDate().toString("dd/MM/yyyy") : "-";
        labelFormatter.appendLabel(" (").appendLabel("label.in", "resources.ApplicationResources").appendLabel(" ").appendLabel(formatedDate).appendLabel(")");
        return labelFormatter;
    }
}

