/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountType;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.Entry;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.PaymentMode;
import org.fenixedu.academic.domain.accounting.PostingRule;
import org.fenixedu.academic.domain.accounting.ResidenceEvent_Base;
import org.fenixedu.academic.domain.accounting.paymentCodes.AccountingEventPaymentCode;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.ResidenceManagementUnit;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.residence.ResidenceMonth;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.dto.accounting.SibsTransactionDetailDTO;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;
import org.joda.time.YearMonthDay;

public class ResidenceEvent
extends ResidenceEvent_Base {
    protected ResidenceEvent() {
    }

    public ResidenceEvent(ResidenceMonth month, Person person, Money roomValue, String room) {
        this.init(EventType.RESIDENCE_PAYMENT, person, month, roomValue, room);
    }

    protected void init(EventType eventType, Person person, ResidenceMonth month, Money roomValue, String room) {
        super.init(eventType, person);
        if (month == null) {
            throw new DomainException("error.accounting.events.ResidenceEvent.ResidenceMonth.cannot.be.null", new String[0]);
        }
        this.setResidenceMonth(month);
        this.setRoomValue(roomValue);
        this.setRoom(room);
    }

    public LabelFormatter getDescription() {
        return this.getDescriptionForEntryType(EntryType.RESIDENCE_FEE);
    }

    public LabelFormatter getDescriptionForEntryType(EntryType entryType) {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel(entryType.name(), "resources.EnumerationResources");
        labelFormatter.appendLabel(" - ");
        labelFormatter.appendLabel(this.getResidenceMonth().getMonth().getName(), "resources.EnumerationResources");
        labelFormatter.appendLabel("-");
        labelFormatter.appendLabel(this.getResidenceMonth().getYear().getYear().toString());
        return labelFormatter;
    }

    protected Account getFromAccount() {
        return this.getPerson().getAccountBy(AccountType.EXTERNAL);
    }

    public PostingRule getPostingRule() {
        return this.getManagementUnit().getUnitServiceAgreementTemplate().findPostingRuleBy(this.getEventType(), this.getWhenOccured(), null);
    }

    public Account getToAccount() {
        return this.getManagementUnit().getAccountBy(AccountType.INTERNAL);
    }

    public ResidenceManagementUnit getManagementUnit() {
        return this.getResidenceMonth().getManagementUnit();
    }

    public DateTime getPaymentStartDate() {
        return this.getResidenceMonth().getPaymentStartDate();
    }

    public DateTime getPaymentLimitDate() {
        return this.getResidenceMonth().getPaymentLimitDateTime();
    }

    public void cancel(Person responsible) {
        super.cancel(responsible);
    }

    public DateTime getPaymentDate() {
        return this.getNonAdjustingTransactions().isEmpty() ? null : ((AccountingTransaction)((Object)this.getNonAdjustingTransactions().iterator().next())).getTransactionDetail().getWhenRegistered();
    }

    public PaymentMode getPaymentMode() {
        return this.getNonAdjustingTransactions().isEmpty() ? null : ((AccountingTransaction)((Object)this.getNonAdjustingTransactions().iterator().next())).getTransactionDetail().getPaymentMode();
    }

    public Money getAmountToPay() {
        return this.calculateAmountToPay(new DateTime());
    }

    protected List<AccountingEventPaymentCode> createPaymentCodes() {
        EntryDTO entryDTO = (EntryDTO)this.calculateEntries(new DateTime()).iterator().next();
        return Collections.singletonList(AccountingEventPaymentCode.create(PaymentCodeType.RESIDENCE_FEE, new YearMonthDay(), this.getPaymentLimitDate().toYearMonthDay(), (Event)((Object)this), entryDTO.getAmountToPay(), entryDTO.getAmountToPay(), this.getPerson()));
    }

    protected List<AccountingEventPaymentCode> updatePaymentCodes() {
        EntryDTO entryDTO = (EntryDTO)this.calculateEntries(new DateTime()).iterator().next();
        ((AccountingEventPaymentCode)((Object)this.getNonProcessedPaymentCodes().iterator().next())).update(new YearMonthDay(), this.getPaymentLimitDate().toYearMonthDay(), entryDTO.getAmountToPay(), entryDTO.getAmountToPay());
        return this.getNonProcessedPaymentCodes();
    }

    protected Set<Entry> internalProcess(User responsibleUser, AccountingEventPaymentCode paymentCode, Money amountToPay, SibsTransactionDetailDTO transactionDetail) {
        return this.internalProcess(responsibleUser, Collections.singletonList(new EntryDTO(EntryType.RESIDENCE_FEE, (Event)((Object)this), amountToPay)), transactionDetail);
    }

    public boolean isFor(int year) {
        return this.getResidenceMonth().isFor(year);
    }

    public boolean isResidenceEvent() {
        return true;
    }

    public Unit getOwnerUnit() {
        return this.getManagementUnit();
    }
}

